/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.Collections;
import java.util.Map;
import org.apache.kafka.image.node.ClusterImageNode;
import org.apache.kafka.image.writer.ImageWriter;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.ControllerRegistration;

public record ClusterImage(Map<Integer, BrokerRegistration> brokers, Map<Integer, ControllerRegistration> controllers) {
    public static final ClusterImage EMPTY = new ClusterImage(Map.of(), Map.of());

    public ClusterImage(Map<Integer, BrokerRegistration> brokers, Map<Integer, ControllerRegistration> controllers) {
        this.brokers = Collections.unmodifiableMap(brokers);
        this.controllers = Collections.unmodifiableMap(controllers);
    }

    public boolean isEmpty() {
        return this.brokers.isEmpty();
    }

    public BrokerRegistration broker(int nodeId) {
        return this.brokers.get(nodeId);
    }

    public long brokerEpoch(int brokerId) {
        BrokerRegistration brokerRegistration = this.broker(brokerId);
        if (brokerRegistration == null) {
            return -1L;
        }
        return brokerRegistration.epoch();
    }

    public void write(ImageWriter writer, ImageWriterOptions options) {
        for (BrokerRegistration broker : this.brokers.values()) {
            writer.write(broker.toRecord(options));
        }
        if (!this.controllers.isEmpty()) {
            if (!options.metadataVersion().isControllerRegistrationSupported()) {
                options.handleLoss("controller registration data");
            } else {
                for (ControllerRegistration controller : this.controllers.values()) {
                    writer.write(controller.toRecord(options));
                }
            }
        }
    }

    @Override
    public String toString() {
        return new ClusterImageNode(this).stringify();
    }
}

