/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.network.RequestChannel;
import kafka.server.ApiRequestHandler;
import kafka.utils.Logging;
import org.apache.kafka.common.internals.FatalExitError;
import org.apache.kafka.common.message.BeginQuorumEpochResponseData;
import org.apache.kafka.common.message.EndQuorumEpochResponseData;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.FetchSnapshotResponseData;
import org.apache.kafka.common.message.VoteResponseData;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.BeginQuorumEpochResponse;
import org.apache.kafka.common.requests.EndQuorumEpochResponse;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.FetchSnapshotResponse;
import org.apache.kafka.common.requests.VoteResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.RaftManager;
import org.apache.kafka.server.ApiVersionManager;
import org.apache.kafka.server.common.RequestLocal;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005Ub\u0001\u0002\b\u0010\u0001QA\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005\u0001\"Aa\t\u0001B\u0001B\u0003%q\t\u0003\u0005O\u0001\t\u0005\t\u0015!\u0003P\u0011\u0015!\u0006\u0001\"\u0001V\u0011\u0015\u0001\u0007\u0001\"\u0011b\u0011\u0015)\b\u0001\"\u0003w\u0011\u0015A\b\u0001\"\u0003z\u0011\u0015Y\b\u0001\"\u0003}\u0011\u0015q\b\u0001\"\u0003\u0000\u0011\u001d\t\u0019\u0001\u0001C\u0005\u0003\u000bAq!!\u0003\u0001\t\u0013\tY\u0001\u0003\u0004a\u0001\u0011%\u0011q\u0002\u0002\u0017)\u0016\u001cHOU1giJ+\u0017/^3ti\"\u000bg\u000e\u001a7fe*\u0011\u0001#E\u0001\u0006i>|Gn\u001d\u0006\u0002%\u0005)1.\u00194lC\u000e\u00011\u0003\u0002\u0001\u00167\u0005\u0002\"AF\r\u000e\u0003]Q\u0011\u0001G\u0001\u0006g\u000e\fG.Y\u0005\u00035]\u0011a!\u00118z%\u00164\u0007C\u0001\u000f \u001b\u0005i\"B\u0001\u0010\u0012\u0003\u0019\u0019XM\u001d<fe&\u0011\u0001%\b\u0002\u0012\u0003BL'+Z9vKN$\b*\u00198eY\u0016\u0014\bC\u0001\u0012&\u001b\u0005\u0019#B\u0001\u0013\u0012\u0003\u0015)H/\u001b7t\u0013\t13EA\u0004M_\u001e<\u0017N\\4\u0002\u0017I\fg\r^'b]\u0006<WM\u001d\u0019\u0003SY\u00022A\u000b\u001a5\u001b\u0005Y#B\u0001\u0017.\u0003\u0011\u0011\u0018M\u001a;\u000b\u0005Iq#BA\u00181\u0003\u0019\t\u0007/Y2iK*\t\u0011'A\u0002pe\u001eL!aM\u0016\u0003\u0017I\u000bg\r^'b]\u0006<WM\u001d\t\u0003kYb\u0001\u0001B\u00058\u0003\u0005\u0005\t\u0011!B\u0001q\t\u0019q\fJ\u0019\u0012\u0005eb\u0004C\u0001\f;\u0013\tYtCA\u0004O_RD\u0017N\\4\u0011\u0005Yi\u0014B\u0001 \u0018\u0005\r\te._\u0001\u000fe\u0016\fX/Z:u\u0007\"\fgN\\3m!\t\tE)D\u0001C\u0015\t\u0019\u0015#A\u0004oKR<xN]6\n\u0005\u0015\u0013%A\u0004*fcV,7\u000f^\"iC:tW\r\\\u0001\u0005i&lW\r\u0005\u0002I\u00196\t\u0011J\u0003\u0002%\u0015*\u00111*L\u0001\u0007G>lWn\u001c8\n\u00055K%\u0001\u0002+j[\u0016\f\u0011#\u00199j-\u0016\u00148/[8o\u001b\u0006t\u0017mZ3s!\t\u0001&+D\u0001R\u0015\tqR&\u0003\u0002T#\n\t\u0012\t]5WKJ\u001c\u0018n\u001c8NC:\fw-\u001a:\u0002\rqJg.\u001b;?)\u00151\u0006,\u00180`!\t9\u0006!D\u0001\u0010\u0011\u00159S\u00011\u0001Za\tQF\fE\u0002+em\u0003\"!\u000e/\u0005\u0013]B\u0016\u0011!A\u0001\u0006\u0003A\u0004\"B \u0006\u0001\u0004\u0001\u0005\"\u0002$\u0006\u0001\u00049\u0005\"\u0002(\u0006\u0001\u0004y\u0015A\u00025b]\u0012dW\rF\u0002cK:\u0004\"AF2\n\u0005\u0011<\"\u0001B+oSRDQA\u001a\u0004A\u0002\u001d\fqA]3rk\u0016\u001cH\u000f\u0005\u0002iW:\u0011\u0011)[\u0005\u0003U\n\u000baBU3rk\u0016\u001cHo\u00115b]:,G.\u0003\u0002m[\n9!+Z9vKN$(B\u00016C\u0011\u0015yg\u00011\u0001q\u00031\u0011X-];fgRdunY1m!\t\t8/D\u0001s\u0015\tY\u0015+\u0003\u0002ue\na!+Z9vKN$Hj\\2bY\u0006\t\u0002.\u00198eY\u0016\f\u0005/\u001b,feNLwN\\:\u0015\u0005\t<\b\"\u00024\b\u0001\u00049\u0017A\u00035b]\u0012dWMV8uKR\u0011!M\u001f\u0005\u0006M\"\u0001\raZ\u0001\u0017Q\u0006tG\r\\3CK\u001eLg.U;peVlW\t]8dQR\u0011!- \u0005\u0006M&\u0001\raZ\u0001\u0015Q\u0006tG\r\\3F]\u0012\fVo\u001c:v[\u0016\u0003xn\u00195\u0015\u0007\t\f\t\u0001C\u0003g\u0015\u0001\u0007q-A\u0006iC:$G.\u001a$fi\u000eDGc\u00012\u0002\b!)am\u0003a\u0001O\u0006\u0019\u0002.\u00198eY\u00164U\r^2i':\f\u0007o\u001d5piR\u0019!-!\u0004\t\u000b\u0019d\u0001\u0019A4\u0015\u000b\t\f\t\"a\u0005\t\u000b\u0019l\u0001\u0019A4\t\u000f\u0005UQ\u00021\u0001\u0002\u0018\u0005i!-^5mIJ+7\u000f]8og\u0016\u0004rAFA\r\u0003;\tI#C\u0002\u0002\u001c]\u0011\u0011BR;oGRLwN\\\u0019\u0011\t\u0005}\u0011QE\u0007\u0003\u0003CQ1!a\tK\u0003!\u0001(o\u001c;pG>d\u0017\u0002BA\u0014\u0003C\u0011!\"\u00119j\u001b\u0016\u001c8/Y4f!\u0011\tY#!\r\u000e\u0005\u00055\"bAA\u0018\u0015\u0006A!/Z9vKN$8/\u0003\u0003\u00024\u00055\"\u0001E!cgR\u0014\u0018m\u0019;SKN\u0004xN\\:f\u0001")
public class TestRaftRequestHandler
implements ApiRequestHandler,
Logging {
    private final RaftManager<?> raftManager;
    private final RequestChannel requestChannel;
    private final Time time;
    private final ApiVersionManager apiVersionManager;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public void tryCompleteActions() {
        ApiRequestHandler.tryCompleteActions$(this);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public void handle(RequestChannel.Request request, RequestLocal requestLocal) {
        block13: {
            try {
                try {
                    this.trace((Function0<String>)(Function0 & Serializable)() -> "Handling request:" + request.requestDesc(true) + " with context " + request.context());
                    ApiKeys apiKeys = request.header().apiKey();
                    if (ApiKeys.API_VERSIONS.equals(apiKeys)) {
                        this.handleApiVersions(request);
                        break block13;
                    }
                    if (ApiKeys.VOTE.equals(apiKeys)) {
                        this.handleVote(request);
                        break block13;
                    }
                    if (ApiKeys.BEGIN_QUORUM_EPOCH.equals(apiKeys)) {
                        this.handleBeginQuorumEpoch(request);
                        break block13;
                    }
                    if (ApiKeys.END_QUORUM_EPOCH.equals(apiKeys)) {
                        this.handleEndQuorumEpoch(request);
                        break block13;
                    }
                    if (ApiKeys.FETCH.equals(apiKeys)) {
                        this.handleFetch(request);
                        break block13;
                    }
                    if (ApiKeys.FETCH_SNAPSHOT.equals(apiKeys)) {
                        this.handleFetchSnapshot(request);
                        break block13;
                    }
                    throw new IllegalArgumentException("Unsupported api key: " + request.header().apiKey());
                }
                catch (FatalExitError fatalExitError) {
                    throw fatalExitError;
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> "Unexpected error handling request " + request.requestDesc(true) + " with context " + request.context(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                    AbstractResponse errorResponse = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class)).getErrorResponse(e);
                    this.requestChannel.sendResponse(request, errorResponse, (Option<Function1<Send, BoxedUnit>>)None$.MODULE$);
                }
            }
            finally {
                if (request.apiLocalCompleteTimeNanos() < 0L) {
                    request.apiLocalCompleteTimeNanos_$eq(this.time.nanoseconds());
                }
            }
        }
    }

    private void handleApiVersions(RequestChannel.Request request) {
        this.requestChannel.sendResponse(request, (AbstractResponse)this.apiVersionManager.apiVersionResponse(0, request.header().apiVersion() < 4), (Option<Function1<Send, BoxedUnit>>)None$.MODULE$);
    }

    private void handleVote(RequestChannel.Request request) {
        Function1 & Serializable handle_buildResponse = (Function1 & Serializable)response -> new VoteResponse((VoteResponseData)response);
        Object handle_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class));
        this.raftManager.handleRequest(request.context(), request.header(), handle_requestBody.data(), this.time.milliseconds()).whenComplete((response, exception) -> {
            AbstractResponse res = exception != null ? handle_requestBody.getErrorResponse(exception) : (AbstractResponse)handle_buildResponse.apply(response);
            $this.requestChannel.sendResponse(request, res, (Option<Function1<Send, BoxedUnit>>)None$.MODULE$);
        });
    }

    private void handleBeginQuorumEpoch(RequestChannel.Request request) {
        Function1 & Serializable handle_buildResponse = (Function1 & Serializable)response -> new BeginQuorumEpochResponse((BeginQuorumEpochResponseData)response);
        Object handle_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class));
        this.raftManager.handleRequest(request.context(), request.header(), handle_requestBody.data(), this.time.milliseconds()).whenComplete((response, exception) -> {
            AbstractResponse res = exception != null ? handle_requestBody.getErrorResponse(exception) : (AbstractResponse)handle_buildResponse.apply(response);
            $this.requestChannel.sendResponse(request, res, (Option<Function1<Send, BoxedUnit>>)None$.MODULE$);
        });
    }

    private void handleEndQuorumEpoch(RequestChannel.Request request) {
        Function1 & Serializable handle_buildResponse = (Function1 & Serializable)response -> new EndQuorumEpochResponse((EndQuorumEpochResponseData)response);
        Object handle_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class));
        this.raftManager.handleRequest(request.context(), request.header(), handle_requestBody.data(), this.time.milliseconds()).whenComplete((response, exception) -> {
            AbstractResponse res = exception != null ? handle_requestBody.getErrorResponse(exception) : (AbstractResponse)handle_buildResponse.apply(response);
            $this.requestChannel.sendResponse(request, res, (Option<Function1<Send, BoxedUnit>>)None$.MODULE$);
        });
    }

    private void handleFetch(RequestChannel.Request request) {
        Function1 & Serializable handle_buildResponse = (Function1 & Serializable)response -> FetchResponse.of((FetchResponseData)((FetchResponseData)response));
        Object handle_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class));
        this.raftManager.handleRequest(request.context(), request.header(), handle_requestBody.data(), this.time.milliseconds()).whenComplete((response, exception) -> {
            AbstractResponse res = exception != null ? handle_requestBody.getErrorResponse(exception) : (AbstractResponse)handle_buildResponse.apply(response);
            $this.requestChannel.sendResponse(request, res, (Option<Function1<Send, BoxedUnit>>)None$.MODULE$);
        });
    }

    private void handleFetchSnapshot(RequestChannel.Request request) {
        Function1 & Serializable handle_buildResponse = (Function1 & Serializable)response -> new FetchSnapshotResponse((FetchSnapshotResponseData)response);
        Object handle_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class));
        this.raftManager.handleRequest(request.context(), request.header(), handle_requestBody.data(), this.time.milliseconds()).whenComplete((response, exception) -> {
            AbstractResponse res = exception != null ? handle_requestBody.getErrorResponse(exception) : (AbstractResponse)handle_buildResponse.apply(response);
            $this.requestChannel.sendResponse(request, res, (Option<Function1<Send, BoxedUnit>>)None$.MODULE$);
        });
    }

    private void handle(RequestChannel.Request request, Function1<ApiMessage, AbstractResponse> buildResponse) {
        Object requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class));
        this.raftManager.handleRequest(request.context(), request.header(), requestBody.data(), this.time.milliseconds()).whenComplete((response, exception) -> {
            AbstractResponse res = exception != null ? handle_requestBody.getErrorResponse(exception) : (AbstractResponse)handle_buildResponse.apply(response);
            $this.requestChannel.sendResponse(request, res, (Option<Function1<Send, BoxedUnit>>)None$.MODULE$);
        });
    }

    public TestRaftRequestHandler(RaftManager<?> raftManager, RequestChannel requestChannel, Time time, ApiVersionManager apiVersionManager) {
        this.raftManager = raftManager;
        this.requestChannel = requestChannel;
        this.time = time;
        this.apiVersionManager = apiVersionManager;
    }
}

