/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Meter;
import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.network.RequestChannel;
import kafka.network.RequestChannel$ShutdownRequest$;
import kafka.network.RequestChannel$WakeupRequest$;
import kafka.server.ApiRequestHandler;
import kafka.server.KafkaRequestHandler$;
import kafka.utils.Logging;
import org.apache.kafka.common.internals.FatalExitError;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.RequestLocal;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005mx!B\u0015+\u0011\u0003yc!B\u0019+\u0011\u0003\u0011\u0004\"B\u001d\u0002\t\u0003Q\u0004bB\u001e\u0002\u0005\u0004%I\u0001\u0010\u0005\u0007\u0017\u0006\u0001\u000b\u0011B\u001f\t\u000f1\u000b!\u0019!C\u0005\u001b\"1a+\u0001Q\u0001\n9CqaV\u0001A\u0002\u0013%\u0001\fC\u0004]\u0003\u0001\u0007I\u0011B/\t\r\r\f\u0001\u0015)\u0003Z\u0011\u0015A\u0017\u0001\"\u0001j\u0011\u0015a\u0017\u0001\"\u0001n\r\u0015\t$\u0006AA\u0011\u0011)\tY\u0004\u0004B\u0001B\u0003%\u0011Q\b\u0005\u000b\u0003\u0007b!\u0011!Q\u0001\n\u0005u\u0002BCA#\u0019\t\u0015\r\u0011\"\u0001\u0002H!Q\u0011\u0011\r\u0007\u0003\u0002\u0003\u0006I!!\u0013\t\u0015\u0005\rDB!b\u0001\n\u0003\t)\u0007\u0003\u0006\u0002|1\u0011\t\u0011)A\u0005\u0003OB!\"! \r\u0005\u000b\u0007I\u0011AA$\u0011)\ty\b\u0004B\u0001B\u0003%\u0011\u0011\n\u0005\u000b\u0003\u0003c!Q1A\u0005\u0002\u0005\u0015\u0004BCAB\u0019\t\u0005\t\u0015!\u0003\u0002h!Q\u0011Q\u0011\u0007\u0003\u0006\u0004%\t!a\"\t\u0013\u0005%EB!A!\u0002\u0013)\u0005BCAF\u0019\t\u0005\t\u0015!\u0003\u0002\u000e\"Q\u00111\u0013\u0007\u0003\u0002\u0003\u0006I!!&\t\u0015\u0005\u0005FB!A!\u0002\u0013\t\u0019\u000b\u0003\u0004:\u0019\u0011\u0005\u0011\u0011\u0018\u0005\n\u0003#d!\u0019!C\u0005\u0003'D\u0001\"!8\rA\u0003%\u0011Q\u001b\u0005\n\u0003?a!\u0019!C\u0005\u0003?D\u0001\"!9\rA\u0003%\u0011Q\u0001\u0005\t\u0003Gd\u0001\u0019!C\u00051\"I\u0011Q\u001d\u0007A\u0002\u0013%\u0011q\u001d\u0005\b\u0003Wd\u0001\u0015)\u0003Z\u0011\u001d\ty\u000f\u0004C\u0001\u0003cDq!a=\r\t\u0013\t\t\u0010C\u0004\u0002v2!\t!!=\t\u000f\u0005]H\u0002\"\u0001\u0002r\"9\u0011\u0011 \u0007\u0005\u0002\u0005E\u0018aE&bM.\f'+Z9vKN$\b*\u00198eY\u0016\u0014(BA\u0016-\u0003\u0019\u0019XM\u001d<fe*\tQ&A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005A\nQ\"\u0001\u0016\u0003'-\u000bgm[1SKF,Xm\u001d;IC:$G.\u001a:\u0014\u0005\u0005\u0019\u0004C\u0001\u001b8\u001b\u0005)$\"\u0001\u001c\u0002\u000bM\u001c\u0017\r\\1\n\u0005a*$AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002_\u0005!B\u000f\u001b:fC\u0012\u0014V-];fgR\u001c\u0005.\u00198oK2,\u0012!\u0010\t\u0004}\r+U\"A \u000b\u0005\u0001\u000b\u0015\u0001\u00027b]\u001eT\u0011AQ\u0001\u0005U\u00064\u0018-\u0003\u0002E\u007f\tYA\u000b\u001b:fC\u0012dunY1m!\t1\u0015*D\u0001H\u0015\tAE&A\u0004oKR<xN]6\n\u0005);%A\u0004*fcV,7\u000f^\"iC:tW\r\\\u0001\u0016i\"\u0014X-\u00193SKF,Xm\u001d;DQ\u0006tg.\u001a7!\u0003Q!\bN]3bI\u000e+(O]3oiJ+\u0017/^3tiV\ta\nE\u0002?\u0007>\u0003\"\u0001U*\u000f\u0005\u0019\u000b\u0016B\u0001*H\u00039\u0011V-];fgR\u001c\u0005.\u00198oK2L!\u0001V+\u0003\u000fI+\u0017/^3ti*\u0011!kR\u0001\u0016i\"\u0014X-\u00193DkJ\u0014XM\u001c;SKF,Xm\u001d;!\u0003E\u0011\u0017\u0010]1tgRC'/Z1e\u0007\",7m[\u000b\u00023B\u0011AGW\u0005\u00037V\u0012qAQ8pY\u0016\fg.A\u000bcsB\f7o\u001d+ie\u0016\fGm\u00115fG.|F%Z9\u0015\u0005y\u000b\u0007C\u0001\u001b`\u0013\t\u0001WG\u0001\u0003V]&$\bb\u00022\t\u0003\u0003\u0005\r!W\u0001\u0004q\u0012\n\u0014A\u00052za\u0006\u001c8\u000f\u00165sK\u0006$7\t[3dW\u0002B#!C3\u0011\u0005Q2\u0017BA46\u0005!1x\u000e\\1uS2,\u0017\u0001F:fi\nK\b/Y:t)\"\u0014X-\u00193DQ\u0016\u001c7\u000e\u0006\u0002_U\")1N\u0003a\u00013\u0006Y!-\u001f9bgN\u001c\u0005.Z2l\u0003E9(/\u00199Bgft7mQ1mY\n\f7m[\u000b\u0003]R$Ba\\?\u0002\u001eA!A\u0007\u001d:_\u0013\t\tXGA\u0005Gk:\u001cG/[8ocA\u00111\u000f\u001e\u0007\u0001\t\u0015)8B1\u0001w\u0005\u0005!\u0016CA<{!\t!\u00040\u0003\u0002zk\t9aj\u001c;iS:<\u0007C\u0001\u001b|\u0013\taXGA\u0002B]fDQA`\u0006A\u0002}\fq#Y:z]\u000e\u001cu.\u001c9mKRLwN\\\"bY2\u0014\u0017mY6\u0011\u000fQ\n\t!!\u0002s=&\u0019\u00111A\u001b\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004\u0003BA\u0004\u00033i!!!\u0003\u000b\t\u0005-\u0011QB\u0001\u0007G>lWn\u001c8\u000b\u0007-\nyAC\u0002.\u0003#QA!a\u0005\u0002\u0016\u00051\u0011\r]1dQ\u0016T!!a\u0006\u0002\u0007=\u0014x-\u0003\u0003\u0002\u001c\u0005%!\u0001\u0004*fcV,7\u000f\u001e'pG\u0006d\u0007bBA\u0010\u0017\u0001\u0007\u0011QA\u0001\re\u0016\fX/Z:u\u0019>\u001c\u0017\r\\\n\b\u0019\u0005\r\u0012\u0011FA\u0018!\rq\u0014QE\u0005\u0004\u0003Oy$AB(cU\u0016\u001cG\u000fE\u0002?\u0003WI1!!\f@\u0005!\u0011VO\u001c8bE2,\u0007\u0003BA\u0019\u0003oi!!a\r\u000b\u0007\u0005UB&A\u0003vi&d7/\u0003\u0003\u0002:\u0005M\"a\u0002'pO\u001eLgnZ\u0001\u0003S\u0012\u00042\u0001NA \u0013\r\t\t%\u000e\u0002\u0004\u0013:$\u0018\u0001\u00032s_.,'/\u00133\u0002%\u0005<wM]3hCR,\u0017\n\u001a7f\u001b\u0016$XM]\u000b\u0003\u0003\u0013\u0002B!a\u0013\u0002^5\u0011\u0011Q\n\u0006\u0005\u0003\u001f\n\t&\u0001\u0003d_J,'\u0002BA*\u0003+\nq!\\3ue&\u001c7O\u0003\u0003\u0002X\u0005e\u0013AB=b[6,'O\u0003\u0002\u0002\\\u0005\u00191m\\7\n\t\u0005}\u0013Q\n\u0002\u0006\u001b\u0016$XM]\u0001\u0014C\u001e<'/Z4bi\u0016LE\r\\3NKR,'\u000fI\u0001\u0011C\u001e<'/Z4bi\u0016$\u0006N]3bIN,\"!a\u001a\u0011\t\u0005%\u0014qO\u0007\u0003\u0003WRA!!\u001c\u0002p\u00051\u0011\r^8nS\u000eTA!!\u001d\u0002t\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0007\u0005U\u0014)\u0001\u0003vi&d\u0017\u0002BA=\u0003W\u0012Q\"\u0011;p[&\u001c\u0017J\u001c;fO\u0016\u0014\u0018!E1hOJ,w-\u0019;f)\"\u0014X-\u00193tA\u0005i\u0001o\\8m\u0013\u0012dW-T3uKJ\fa\u0002]8pY&#G.Z'fi\u0016\u0014\b%\u0001\nq_>d\u0007*\u00198eY\u0016\u0014H\u000b\u001b:fC\u0012\u001c\u0018a\u00059p_2D\u0015M\u001c3mKJ$\u0006N]3bIN\u0004\u0013A\u0004:fcV,7\u000f^\"iC:tW\r\\\u000b\u0002\u000b\u0006y!/Z9vKN$8\t[1o]\u0016d\u0007%\u0001\u0003ba&\u001c\bc\u0001\u0019\u0002\u0010&\u0019\u0011\u0011\u0013\u0016\u0003#\u0005\u0003\u0018NU3rk\u0016\u001cH\u000fS1oI2,'/\u0001\u0003uS6,\u0007\u0003BAL\u0003;k!!!'\u000b\t\u0005U\u00121\u0014\u0006\u0005\u0003\u0017\ty!\u0003\u0003\u0002 \u0006e%\u0001\u0002+j[\u0016\f\u0001B\\8eK:\u000bW.\u001a\t\u0005\u0003K\u000b\u0019L\u0004\u0003\u0002(\u0006=\u0006cAAUk5\u0011\u00111\u0016\u0006\u0004\u0003[s\u0013A\u0002\u001fs_>$h(C\u0002\u00022V\na\u0001\u0015:fI\u00164\u0017\u0002BA[\u0003o\u0013aa\u0015;sS:<'bAAYkQ1\u00121XA_\u0003\u007f\u000b\t-a1\u0002F\u0006\u001d\u0017\u0011ZAf\u0003\u001b\fy\r\u0005\u00021\u0019!9\u00111\b\u000fA\u0002\u0005u\u0002bBA\"9\u0001\u0007\u0011Q\b\u0005\b\u0003\u000bb\u0002\u0019AA%\u0011\u001d\t\u0019\u0007\ba\u0001\u0003OBq!! \u001d\u0001\u0004\tI\u0005C\u0004\u0002\u0002r\u0001\r!a\u001a\t\r\u0005\u0015E\u00041\u0001F\u0011\u001d\tY\t\ba\u0001\u0003\u001bCq!a%\u001d\u0001\u0004\t)\nC\u0004\u0002\"r\u0001\r!a)\u0002!MDW\u000f\u001e3po:\u001cu.\u001c9mKR,WCAAk!\u0011\t9.!7\u000e\u0005\u0005=\u0014\u0002BAn\u0003_\u0012abQ8v]R$un\u001e8MCR\u001c\u0007.A\ttQV$Hm\\<o\u0007>l\u0007\u000f\\3uK\u0002*\"!!\u0002\u0002\u001bI,\u0017/^3ti2{7-\u00197!\u0003\u001d\u0019Ho\u001c9qK\u0012\f1b\u001d;paB,Gm\u0018\u0013fcR\u0019a,!;\t\u000f\t\u0014\u0013\u0011!a\u00013\u0006A1\u000f^8qa\u0016$\u0007\u0005\u000b\u0002$K\u0006\u0019!/\u001e8\u0015\u0003y\u000b\u0001cY8na2,G/Z*ikR$wn\u001e8\u0002\tM$x\u000e]\u0001\u0011S:LG/[1uKNCW\u000f\u001e3po:\fQ\"Y<bSR\u001c\u0006.\u001e;e_^t\u0007")
public class KafkaRequestHandler
implements Runnable,
Logging {
    private final int id;
    private final int brokerId;
    private final Meter aggregateIdleMeter;
    private final AtomicInteger aggregateThreads;
    private final Meter poolIdleMeter;
    private final AtomicInteger poolHandlerThreads;
    private final RequestChannel requestChannel;
    private final ApiRequestHandler apis;
    private final Time time;
    private final CountDownLatch shutdownComplete;
    private final RequestLocal requestLocal;
    private volatile boolean stopped;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static <T> Function1<T, BoxedUnit> wrapAsyncCallback(Function2<RequestLocal, T, BoxedUnit> asyncCompletionCallback, RequestLocal requestLocal) {
        return KafkaRequestHandler$.MODULE$.wrapAsyncCallback(asyncCompletionCallback, requestLocal);
    }

    public static void setBypassThreadCheck(boolean bypassCheck) {
        KafkaRequestHandler$.MODULE$.setBypassThreadCheck(bypassCheck);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Meter aggregateIdleMeter() {
        return this.aggregateIdleMeter;
    }

    public AtomicInteger aggregateThreads() {
        return this.aggregateThreads;
    }

    public Meter poolIdleMeter() {
        return this.poolIdleMeter;
    }

    public AtomicInteger poolHandlerThreads() {
        return this.poolHandlerThreads;
    }

    public RequestChannel requestChannel() {
        return this.requestChannel;
    }

    private CountDownLatch shutdownComplete() {
        return this.shutdownComplete;
    }

    private RequestLocal requestLocal() {
        return this.requestLocal;
    }

    private boolean stopped() {
        return this.stopped;
    }

    private void stopped_$eq(boolean x$1) {
        this.stopped = x$1;
    }

    @Override
    public void run() {
        KafkaRequestHandler$.MODULE$.kafka$server$KafkaRequestHandler$$threadRequestChannel().set(this.requestChannel());
        while (!this.stopped()) {
            long startSelectTime = this.time.nanoseconds();
            RequestChannel.BaseRequest req = this.requestChannel().receiveRequest(300L);
            long endTime = this.time.nanoseconds();
            long idleTime = endTime - startSelectTime;
            this.poolIdleMeter().mark(idleTime / (long)this.poolHandlerThreads().get());
            this.aggregateIdleMeter().mark(idleTime / (long)this.aggregateThreads().get());
            if (RequestChannel$ShutdownRequest$.MODULE$.equals(req)) {
                this.debug((Function0<String>)(Function0 & Serializable)() -> "Kafka request handler " + $this.id + " on broker " + $this.brokerId + " received shut down command");
                this.completeShutdown();
                return;
            }
            if (req instanceof RequestChannel.CallbackRequest) {
                RequestChannel.CallbackRequest callbackRequest = (RequestChannel.CallbackRequest)req;
                RequestChannel.Request originalRequest = callbackRequest.originalRequest();
                try {
                    try {
                        if (originalRequest.callbackRequestDequeueTimeNanos().isDefined()) {
                            long prevCallbacksTimeNanos = BoxesRunTime.unboxToLong((Object)originalRequest.callbackRequestCompleteTimeNanos().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)) - BoxesRunTime.unboxToLong((Object)originalRequest.callbackRequestDequeueTimeNanos().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
                            originalRequest.callbackRequestCompleteTimeNanos_$eq((Option<Object>)None$.MODULE$);
                            originalRequest.callbackRequestDequeueTimeNanos_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)(this.time.nanoseconds() - prevCallbacksTimeNanos))));
                        } else {
                            originalRequest.callbackRequestDequeueTimeNanos_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.time.nanoseconds())));
                        }
                        KafkaRequestHandler$.MODULE$.kafka$server$KafkaRequestHandler$$threadCurrentRequest().set(originalRequest);
                        BoxedUnit cfr_ignored_0 = (BoxedUnit)callbackRequest.fun().apply((Object)this.requestLocal());
                    }
                    catch (FatalExitError e) {
                        this.completeShutdown();
                        Exit.exit((int)e.statusCode(), null);
                    }
                    catch (Throwable e) {
                        this.error((Function0<String>)(Function0 & Serializable)() -> "Exception when handling request", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                    }
                    continue;
                }
                finally {
                    this.apis.tryCompleteActions();
                    if (originalRequest.callbackRequestCompleteTimeNanos().isEmpty()) {
                        originalRequest.callbackRequestCompleteTimeNanos_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.time.nanoseconds())));
                    }
                    KafkaRequestHandler$.MODULE$.kafka$server$KafkaRequestHandler$$threadCurrentRequest().remove();
                    continue;
                }
            }
            if (req instanceof RequestChannel.Request) {
                RequestChannel.Request request = (RequestChannel.Request)req;
                try {
                    try {
                        request.requestDequeueTimeNanos_$eq(endTime);
                        this.trace((Function0<String>)(Function0 & Serializable)() -> "Kafka request handler " + $this.id + " on broker " + $this.brokerId + " handling request " + request);
                        KafkaRequestHandler$.MODULE$.kafka$server$KafkaRequestHandler$$threadCurrentRequest().set(request);
                        this.apis.handle(request, this.requestLocal());
                    }
                    catch (FatalExitError e) {
                        this.completeShutdown();
                        Exit.exit((int)e.statusCode(), null);
                    }
                    catch (Throwable e) {
                        this.error((Function0<String>)(Function0 & Serializable)() -> "Exception when handling request", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                    }
                    continue;
                }
                finally {
                    KafkaRequestHandler$.MODULE$.kafka$server$KafkaRequestHandler$$threadCurrentRequest().remove();
                    request.releaseBuffer();
                    continue;
                }
            }
            if (RequestChannel$WakeupRequest$.MODULE$.equals(req)) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> "Received a wakeup request outside of typical usage.");
                continue;
            }
            if (req == null) continue;
            throw new MatchError((Object)req);
        }
        this.completeShutdown();
    }

    private void completeShutdown() {
        this.requestLocal().close();
        KafkaRequestHandler$.MODULE$.kafka$server$KafkaRequestHandler$$threadRequestChannel().remove();
        this.shutdownComplete().countDown();
    }

    public void stop() {
        this.stopped_$eq(true);
    }

    public void initiateShutdown() {
        this.requestChannel().sendShutdownRequest();
    }

    public void awaitShutdown() {
        this.shutdownComplete().await();
    }

    public KafkaRequestHandler(int id, int brokerId, Meter aggregateIdleMeter, AtomicInteger aggregateThreads, Meter poolIdleMeter, AtomicInteger poolHandlerThreads, RequestChannel requestChannel, ApiRequestHandler apis, Time time, String nodeName) {
        this.id = id;
        this.brokerId = brokerId;
        this.aggregateIdleMeter = aggregateIdleMeter;
        this.aggregateThreads = aggregateThreads;
        this.poolIdleMeter = poolIdleMeter;
        this.poolHandlerThreads = poolHandlerThreads;
        this.requestChannel = requestChannel;
        this.apis = apis;
        this.time = time;
        this.logIdent_$eq("[Kafka Request Handler " + id + " on " + StringOps$.MODULE$.capitalize$extension(Predef$.MODULE$.augmentString(nodeName)) + " " + brokerId + "] ");
        this.shutdownComplete = new CountDownLatch(1);
        this.requestLocal = RequestLocal.withThreadConfinedCaching();
        this.stopped = false;
    }
}

