/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kafka.server.FailedPartitions;
import kafka.server.FetcherLagStats;
import kafka.server.FetcherStats;
import kafka.server.InitialFetchState;
import kafka.server.OffsetTruncationState;
import kafka.server.TierStateMachine;
import kafka.utils.Logging;
import org.apache.kafka.common.ClientIdAndBroker;
import org.apache.kafka.common.InvalidRecordException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.errors.FencedLeaderEpochException;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.errors.UnknownLeaderEpochException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.internals.PartitionStates;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.server.LeaderEndPoint;
import org.apache.kafka.server.PartitionFetchState;
import org.apache.kafka.server.ReplicaState;
import org.apache.kafka.server.ResultWithPartitions;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.server.log.remote.storage.RetriableRemoteStorageException;
import org.apache.kafka.server.util.ShutdownableThread;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.log.metrics.BrokerTopicStats;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Growable;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0011\u0005b!B#G\u0003\u0003Y\u0005\u0002\u00030\u0001\u0005\u0003\u0005\u000b\u0011B0\t\u00111\u0004!\u0011!Q\u0001\n}C\u0001\"\u001c\u0001\u0003\u0006\u0004%\tA\u001c\u0005\tg\u0002\u0011\t\u0011)A\u0005_\"AA\u000f\u0001B\u0001B\u0003%Q\u000f\u0003\u0005z\u0001\t\u0015\r\u0011\"\u0001{\u0011!q\bA!A!\u0002\u0013Y\b\"C@\u0001\u0005\u0003\u0005\u000b\u0011BA\u0001\u0011)\tI\u0001\u0001B\u0001B\u0003%\u00111\u0002\u0005\u000b\u0003#\u0001!Q1A\u0005\u0002\u0005M\u0001BCA\u0015\u0001\t\u0005\t\u0015!\u0003\u0002\u0016!9\u00111\u0006\u0001\u0005\u0002\u00055RABA!\u0001\u0001\t\u0019%\u0002\u0004\u0002\\\u0001\u0001\u0011Q\f\u0005\n\u0003W\u0002!\u0019!C\u0005\u0003[B\u0001\"!!\u0001A\u0003%\u0011q\u000e\u0005\n\u0003\u0007\u0003!\u0019!C\t\u0003\u000bC\u0001\"!(\u0001A\u0003%\u0011q\u0011\u0005\n\u0003?\u0003!\u0019!C\u0005\u0003CC\u0001\"!+\u0001A\u0003%\u00111\u0015\u0005\n\u0003W\u0003!\u0019!C\u0005\u0003[C\u0001\"a.\u0001A\u0003%\u0011q\u0016\u0005\n\u0003s\u0003!\u0019!C\u0001\u0003wC\u0001\"a1\u0001A\u0003%\u0011Q\u0018\u0005\n\u0003\u000b\u0004!\u0019!C\u0001\u0003\u000fD\u0001\"a4\u0001A\u0003%\u0011\u0011\u001a\u0005\b\u0003#\u0004a\u0011CAj\u0011\u001d\u00119\u0001\u0001D\t\u0005\u0013AqA!\b\u0001\r#\u0011y\u0002C\u0004\u0003(\u00011\tB!\u000b\t\u000f\t\u0005\u0003A\"\u0005\u0003D!9!q\t\u0001\u0007\u0012\t%\u0003b\u0002B'\u0001\u0019E!q\n\u0005\b\u0005G\u0002A\u0011\tB3\u0011\u001d\u00119\u0007\u0001C!\u0005KBqA!\u001b\u0001\t\u0013\u0011)\u0007C\u0004\u0003l\u0001!IA!\u001c\t\u000f\t%\u0005\u0001\"\u0003\u0003\f\"9!q\u0015\u0001\u0005\n\t\u0015\u0004b\u0002BU\u0001\u0011%!1\u0016\u0005\b\u0005c\u0003A\u0011\u0002BZ\u0011!\u0011I\f\u0001C\t\r\nm\u0006\u0002\u0003Bs\u0001\u0011\u0005aIa:\t\u000f\t-\b\u0001\"\u0003\u0003n\"9!Q \u0001\u0005\n\t}\b\u0002CB\u0005\u0001\u0011\u0005aia\u0003\t\u000f\rE\u0002\u0001\"\u0001\u00044!911\b\u0001\u0005\n\ru\u0002bBB!\u0001\u0011%11\t\u0005\b\u0007+\u0002A\u0011AB,\u0011\u001d\u0019y\u0006\u0001C\u0001\u0007CBqaa\u001e\u0001\t\u0013\u0019I\bC\u0004\u0004\u0000\u0001!Ia!!\t\u000f\r%\u0005\u0001\"\u0003\u0004\f\"91q\u0013\u0001\u0005\n\re\u0005bBBS\u0001\u0011%1q\u0015\u0005\b\u0007o\u0003A\u0011BB]\u0011\u001d\u0019\t\r\u0001C\u0001\u0007\u0007Dqaa3\u0001\t\u0003\u0019i\rC\u0004\u0004P\u0002!\ta!5\t\u000f\tE\u0004\u0001\"\u0001\u0004T\"A1q\u0014\u0001\u0005\u0002\u0019\u001b)\u000eC\u0004\u0004\\\u0002!\tb!8\b\u0013\rUh)!A\t\u0002\r]h\u0001C#G\u0003\u0003E\ta!?\t\u000f\u0005-\u0012\t\"\u0001\u0005\u0002!IA1A!\u0012\u0002\u0013\u0005AQ\u0001\u0005\n\t7\t\u0015\u0013!C\u0001\t;\u0011Q#\u00112tiJ\f7\r\u001e$fi\u000eDWM\u001d+ie\u0016\fGM\u0003\u0002H\u0011\u000611/\u001a:wKJT\u0011!S\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001A\n\u0017\t\u0003\u001bZk\u0011A\u0014\u0006\u0003\u001fB\u000bA!\u001e;jY*\u0011q)\u0015\u0006\u0003\u0013JS!a\u0015+\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0016aA8sO&\u0011qK\u0014\u0002\u0013'\",H\u000fZ8x]\u0006\u0014G.\u001a+ie\u0016\fG\r\u0005\u0002Z96\t!L\u0003\u0002\\\u0011\u0006)Q\u000f^5mg&\u0011QL\u0017\u0002\b\u0019><w-\u001b8h\u0003\u0011q\u0017-\\3\u0011\u0005\u0001LgBA1h!\t\u0011W-D\u0001d\u0015\t!'*\u0001\u0004=e>|GO\u0010\u0006\u0002M\u0006)1oY1mC&\u0011\u0001.Z\u0001\u0007!J,G-\u001a4\n\u0005)\\'AB*ue&twM\u0003\u0002iK\u0006A1\r\\5f]RLE-\u0001\u0004mK\u0006$WM]\u000b\u0002_B\u0011\u0001/]\u0007\u0002!&\u0011!\u000f\u0015\u0002\u000f\u0019\u0016\fG-\u001a:F]\u0012\u0004v.\u001b8u\u0003\u001daW-\u00193fe\u0002\n\u0001CZ1jY\u0016$\u0007+\u0019:uSRLwN\\:\u0011\u0005Y<X\"\u0001$\n\u0005a4%\u0001\u0005$bS2,G\rU1si&$\u0018n\u001c8t\u0003U1W\r^2i)&,'o\u0015;bi\u0016l\u0015m\u00195j]\u0016,\u0012a\u001f\t\u0003mrL!! $\u0003!QKWM]*uCR,W*Y2iS:,\u0017A\u00064fi\u000eDG+[3s'R\fG/Z'bG\"Lg.\u001a\u0011\u0002\u001d\u0019,Go\u00195CC\u000e\\wJ\u001a4NgB!\u00111AA\u0003\u001b\u0005)\u0017bAA\u0004K\n\u0019\u0011J\u001c;\u0002\u001f%\u001c\u0018J\u001c;feJ,\b\u000f^5cY\u0016\u0004B!a\u0001\u0002\u000e%\u0019\u0011qB3\u0003\u000f\t{w\u000e\\3b]\u0006\u0001\"M]8lKJ$v\u000e]5d'R\fGo]\u000b\u0003\u0003+\u0001B!a\u0006\u0002&5\u0011\u0011\u0011\u0004\u0006\u0005\u00037\ti\"A\u0004nKR\u0014\u0018nY:\u000b\t\u0005}\u0011\u0011E\u0001\u0004Y><'bAA\u0012#\u000691\u000f^8sC\u001e,\u0017\u0002BA\u0014\u00033\u0011\u0001C\u0011:pW\u0016\u0014Hk\u001c9jGN#\u0018\r^:\u0002#\t\u0014xn[3s)>\u0004\u0018nY*uCR\u001c\b%\u0001\u0004=S:LGO\u0010\u000b\u0013\u0003_\t\t$a\r\u00026\u0005]\u0012\u0011HA\u001e\u0003{\ty\u0004\u0005\u0002w\u0001!)a\f\u0004a\u0001?\")A\u000e\u0004a\u0001?\")Q\u000e\u0004a\u0001_\")A\u000f\u0004a\u0001k\")\u0011\u0010\u0004a\u0001w\"Aq\u0010\u0004I\u0001\u0002\u0004\t\t\u0001C\u0005\u0002\n1\u0001\n\u00111\u0001\u0002\f!9\u0011\u0011\u0003\u0007A\u0002\u0005U!!\u0003$fi\u000eDG)\u0019;b!\u0011\t)%!\u0016\u000f\t\u0005\u001d\u0013\u0011K\u0007\u0003\u0003\u0013RA!a\u0013\u0002N\u00059Q.Z:tC\u001e,'bAA(#\u000611m\\7n_:LA!a\u0015\u0002J\u0005\tb)\u001a;dQJ+7\u000f]8og\u0016$\u0015\r^1\n\t\u0005]\u0013\u0011\f\u0002\u000e!\u0006\u0014H/\u001b;j_:$\u0015\r^1\u000b\t\u0005M\u0013\u0011\n\u0002\n\u000bB|7\r\u001b#bi\u0006\u0004B!a\u0018\u0002f9!\u0011qIA1\u0013\u0011\t\u0019'!\u0013\u0002?=3gm]3u\r>\u0014H*Z1eKJ,\u0005o\\2i%\u0016\fX/Z:u\t\u0006$\u0018-\u0003\u0003\u0002h\u0005%$\u0001G(gMN,GOR8s\u0019\u0016\fG-\u001a:QCJ$\u0018\u000e^5p]*!\u00111MA%\u0003=\u0001\u0018M\u001d;ji&|gn\u0015;bi\u0016\u001cXCAA8!\u0019\t\t(a\u001e\u0002|5\u0011\u00111\u000f\u0006\u0005\u0003k\ni%A\u0005j]R,'O\\1mg&!\u0011\u0011PA:\u0005=\u0001\u0016M\u001d;ji&|gn\u0015;bi\u0016\u001c\bc\u00019\u0002~%\u0019\u0011q\u0010)\u0003'A\u000b'\u000f^5uS>tg)\u001a;dQN#\u0018\r^3\u0002!A\f'\u000f^5uS>t7\u000b^1uKN\u0004\u0013\u0001\u00059beRLG/[8o\u001b\u0006\u0004Hj\\2l+\t\t9\t\u0005\u0003\u0002\n\u0006eUBAAF\u0015\u0011\ti)a$\u0002\u000b1|7m[:\u000b\t\u0005E\u00151S\u0001\u000bG>t7-\u001e:sK:$(bA(\u0002\u0016*\u0011\u0011qS\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u001c\u0006-%!\u0004*fK:$(/\u00198u\u0019>\u001c7.A\tqCJ$\u0018\u000e^5p]6\u000b\u0007\u000fT8dW\u0002\n\u0001\u0003]1si&$\u0018n\u001c8NCB\u001cuN\u001c3\u0016\u0005\u0005\r\u0006\u0003BAE\u0003KKA!a*\u0002\f\nI1i\u001c8eSRLwN\\\u0001\u0012a\u0006\u0014H/\u001b;j_:l\u0015\r]\"p]\u0012\u0004\u0013\u0001C7fiJL7-\u00133\u0016\u0005\u0005=\u0006\u0003BAY\u0003gk!!!\u0014\n\t\u0005U\u0016Q\n\u0002\u0012\u00072LWM\u001c;JI\u0006sGM\u0011:pW\u0016\u0014\u0018!C7fiJL7-\u00133!\u000311W\r^2iKJ\u001cF/\u0019;t+\t\ti\fE\u0002w\u0003\u007fK1!!1G\u000511U\r^2iKJ\u001cF/\u0019;t\u000351W\r^2iKJ\u001cF/\u0019;tA\u0005ya-\u001a;dQ\u0016\u0014H*Y4Ti\u0006$8/\u0006\u0002\u0002JB\u0019a/a3\n\u0007\u00055gIA\bGKR\u001c\u0007.\u001a:MC\u001e\u001cF/\u0019;t\u0003A1W\r^2iKJd\u0015mZ*uCR\u001c\b%\u0001\u000bqe>\u001cWm]:QCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\u000b\u000b\u0003+\f9/!=\u0002|\u0006}\bCBA\u0002\u0003/\fY.C\u0002\u0002Z\u0016\u0014aa\u00149uS>t\u0007\u0003BAo\u0003Gl!!a8\u000b\t\u0005}\u0011\u0011\u001d\u0006\u0005\u0003k\n\t#\u0003\u0003\u0002f\u0006}'!\u0004'pO\u0006\u0003\b/\u001a8e\u0013:4w\u000eC\u0004\u0002jn\u0001\r!a;\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]B!\u0011\u0011WAw\u0013\u0011\ty/!\u0014\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"9\u00111_\u000eA\u0002\u0005U\u0018a\u00034fi\u000eDwJ\u001a4tKR\u0004B!a\u0001\u0002x&\u0019\u0011\u0011`3\u0003\t1{gn\u001a\u0005\b\u0003{\\\u0002\u0019AA\u0001\u0003Q\u0001\u0018M\u001d;ji&|g\u000eT3bI\u0016\u0014X\t]8dQ\"9!\u0011A\u000eA\u0002\t\r\u0011!\u00049beRLG/[8o\t\u0006$\u0018\rE\u0002\u0003\u00065i\u0011\u0001A\u0001\tiJ,hnY1uKR1!1\u0002B\t\u0005'\u0001B!a\u0001\u0003\u000e%\u0019!qB3\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003Sd\u0002\u0019AAv\u0011\u001d\u0011)\u0002\ba\u0001\u0005/\tq\u0002\u001e:v]\u000e\fG/[8o'R\fG/\u001a\t\u0004m\ne\u0011b\u0001B\u000e\r\n)rJ\u001a4tKR$&/\u001e8dCRLwN\\*uCR,\u0017a\u0006;sk:\u001c\u0017\r^3Gk2d\u00170\u00118e'R\f'\u000f^!u)\u0019\u0011YA!\t\u0003$!9\u0011\u0011^\u000fA\u0002\u0005-\bb\u0002B\u0013;\u0001\u0007\u0011Q_\u0001\u0007_\u001a47/\u001a;\u0002\u00171\fG/Z:u\u000bB|7\r\u001b\u000b\u0005\u0005W\u0011y\u0004\u0005\u0004\u0003.\t=\"1G\u0007\u0003\u0003'KAA!\r\u0002\u0014\nAq\n\u001d;j_:\fG\u000e\u0005\u0003\u00036\tmRB\u0001B\u001c\u0015\u0011\u0011I$!&\u0002\t1\fgnZ\u0005\u0005\u0005{\u00119DA\u0004J]R,w-\u001a:\t\u000f\u0005%h\u00041\u0001\u0002l\u0006qAn\\4Ti\u0006\u0014Ho\u00144gg\u0016$H\u0003BA{\u0005\u000bBq!!; \u0001\u0004\tY/\u0001\u0007m_\u001e,e\u000eZ(gMN,G\u000f\u0006\u0003\u0002v\n-\u0003bBAuA\u0001\u0007\u00111^\u0001\u0012K:$wJ\u001a4tKR4uN]#q_\u000eDGC\u0002B)\u0005;\u0012y\u0006\u0005\u0004\u0003.\t=\"1\u000b\t\u0005\u0005+\u0012I&\u0004\u0002\u0003X)\u0019\u0011q\n)\n\t\tm#q\u000b\u0002\u000f\u001f\u001a47/\u001a;B]\u0012,\u0005o\\2i\u0011\u001d\tI/\ta\u0001\u0003WDqA!\u0019\"\u0001\u0004\t\t!A\u0003fa>\u001c\u0007.\u0001\u0005tQV$Hm\\<o)\t\u0011Y!\u0001\u0004e_^{'o[\u0001\u000b[\u0006L(-\u001a$fi\u000eD\u0017A\u00075b]\u0012dW\rU1si&$\u0018n\u001c8t/&$\b.\u0012:s_J\u001cHC\u0002B\u0006\u0005_\u0012)\tC\u0004\u0003r\u0015\u0002\rAa\u001d\u0002\u0015A\f'\u000f^5uS>t7\u000f\u0005\u0004\u0003v\t}\u00141\u001e\b\u0005\u0005o\u0012YHD\u0002c\u0005sJ\u0011AZ\u0005\u0004\u0005{*\u0017a\u00029bG.\fw-Z\u0005\u0005\u0005\u0003\u0013\u0019I\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\r\u0011i(\u001a\u0005\u0007\u0005\u000f+\u0003\u0019A0\u0002\u00155,G\u000f[8e\u001d\u0006lW-A\rgKR\u001c\u0007\u000e\u0016:v]\u000e\fG/\u001b8h!\u0006\u0014H/\u001b;j_:\u001cHC\u0001BG!!\t\u0019Aa$\u0003\u0014\n\u0005\u0016b\u0001BIK\n1A+\u001e9mKJ\u0002\u0002B!&\u0003\u001c\u0006-(qT\u0007\u0003\u0005/S1A!'f\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005;\u00139JA\u0002NCB\u00042A!\u0002\u000f!\u0019\u0011)Ja)\u0002l&!!Q\u0015BL\u0005\r\u0019V\r^\u0001\u000e[\u0006L(-\u001a+sk:\u001c\u0017\r^3\u0002\u0015\u0011|GK];oG\u0006$X\r\u0006\u0004\u0002\f\t5&q\u0016\u0005\b\u0003SD\u0003\u0019AAv\u0011\u001d\u0011)\u0002\u000ba\u0001\u0005/\t\u0011\u0004\u001e:v]\u000e\fG/\u001a+p\u000bB|7\r[#oI>3gm]3ugR!!1\u0002B[\u0011\u001d\u00119,\u000ba\u0001\u0005'\u000b\u0011\u0004\\1uKN$X\t]8dQN4uN\u001d)beRLG/[8og\u00069BO];oG\u0006$Xm\u00148GKR\u001c\u0007NU3ta>t7/\u001a\u000b\u0005\u0005\u0017\u0011i\fC\u0004\u0003@*\u0002\rA!1\u0002\u001f\u0015\u0004xn\u00195F]\u0012|eMZ:fiN\u0004\u0002B!&\u0003\u001c\u0006-(1\u0019\t\u0005\u0005\u000b\u0014yN\u0004\u0003\u0003H\nmg\u0002\u0002Be\u00053tAAa3\u0003X:!!Q\u001aBk\u001d\u0011\u0011yMa5\u000f\u0007\t\u0014\t.C\u0001V\u0013\t\u0019F+\u0003\u0002J%&\u0019\u0011qJ)\n\t\u0005-\u0013QJ\u0005\u0005\u0005;\fI%\u0001\u0011PM\u001a\u001cX\r\u001e$pe2+\u0017\rZ3s\u000bB|7\r\u001b*fgB|gn]3ECR\f\u0017\u0002\u0002Bq\u0005G\u0014a\"\u00129pG\",e\u000eZ(gMN,GO\u0003\u0003\u0003^\u0006%\u0013a\u0006;sk:\u001c\u0017\r^3U_\"Kw\r[,bi\u0016\u0014X.\u0019:l)\u0011\u0011YA!;\t\u000f\tE4\u00061\u0001\u0003\"\u0006qR.Y=cKR\u0013XO\\2bi\u0016$v.\u00129pG\",e\u000eZ(gMN,Go\u001d\u000b\u0007\u0005_\u00149Pa?\u0011\u000bA\u0014\tP!>\n\u0007\tM\bK\u0001\u000bSKN,H\u000e^,ji\"\u0004\u0016M\u001d;ji&|gn\u001d\t\t\u0005+\u0013Y*a;\u0003\u0018!9!\u0011 \u0017A\u0002\t\u0005\u0017!\u00044fi\u000eDW\rZ#q_\u000eD7\u000fC\u0004\u000382\u0002\rAa%\u0002#=t\u0007+\u0019:uSRLwN\u001c$f]\u000e,G\r\u0006\u0004\u0002\f\r\u00051Q\u0001\u0005\b\u0007\u0007i\u0003\u0019AAv\u0003\t!\b\u000fC\u0004\u0004\b5\u0002\rAa\u000b\u0002\u0019I,\u0017/^3ti\u0016\u0003xn\u00195\u0002'A\u0014xnY3tg\u001a+Go\u00195SKF,Xm\u001d;\u0015\r\t-1QBB\u0014\u0011\u001d\u0019yA\fa\u0001\u0007#\t\u0011c]3tg&|g\u000eU1si&$\u0018n\u001c8t!!\u0011ica\u0005\u0002l\u000eU\u0011\u0002\u0002BO\u0003'\u0003Baa\u0006\u0004$9!1\u0011DB\u0010\u001b\t\u0019YB\u0003\u0003\u0004\u001e\u00055\u0013\u0001\u0003:fcV,7\u000f^:\n\t\r\u000521D\u0001\r\r\u0016$8\r\u001b*fcV,7\u000f^\u0005\u0005\u0003/\u001a)C\u0003\u0003\u0004\"\rm\u0001bBB\u0015]\u0001\u000711F\u0001\rM\u0016$8\r\u001b*fcV,7\u000f\u001e\t\u0005\u0007/\u0019i#\u0003\u0003\u00040\r\u0015\"a\u0002\"vS2$WM]\u0001\u001c[\u0006\u00148\u000eU1si&$\u0018n\u001c8t\r>\u0014HK];oG\u0006$\u0018n\u001c8\u0015\r\t-1QGB\u001c\u0011\u001d\tIo\fa\u0001\u0003WDqa!\u000f0\u0001\u0004\t)0\u0001\tueVt7-\u0019;j_:|eMZ:fi\u0006\u0019R.\u0019:l!\u0006\u0014H/\u001b;j_:4\u0015-\u001b7fIR!!1BB \u0011\u001d\tI\u000f\ra\u0001\u0003W\f1\u0003]1si&$\u0018n\u001c8GKR\u001c\u0007n\u0015;bi\u0016$\u0002\"a\u001f\u0004F\r\u001d3\u0011\u000b\u0005\b\u0007\u0007\t\u0004\u0019AAv\u0011\u001d\u0019I%\ra\u0001\u0007\u0017\n\u0011#\u001b8ji&\fGNR3uG\"\u001cF/\u0019;f!\r18QJ\u0005\u0004\u0007\u001f2%!E%oSRL\u0017\r\u001c$fi\u000eD7\u000b^1uK\"911K\u0019A\u0002\u0005m\u0014\u0001D2veJ,g\u000e^*uCR,\u0017!D1eIB\u000b'\u000f^5uS>t7\u000f\u0006\u0003\u0003\"\u000ee\u0003bBB.e\u0001\u00071QL\u0001\u0013S:LG/[1m\r\u0016$8\r[*uCR,7\u000f\u0005\u0005\u0003\u0016\nm\u00151^B&\u0003Mi\u0017-\u001f2f+B$\u0017\r^3U_BL7-\u00133t)\u0019\u0011Yaa\u0019\u0004f!9!\u0011O\u001aA\u0002\t\u0005\u0006bBB4g\u0001\u00071\u0011N\u0001\ti>\u0004\u0018nY%egB9\u00111AB6?\u000e=\u0014bAB7K\nIa)\u001e8di&|g.\r\t\u0007\u0003\u0007\t9n!\u001d\u0011\t\u0005E61O\u0005\u0005\u0007k\niE\u0001\u0003Vk&$\u0017aL;qI\u0006$XMR3uG\"|eMZ:fi\u0006sG-T1zE\u0016l\u0015M]6UeVt7-\u0019;j_:\u001cu.\u001c9mKR,G\u0003\u0002B\u0006\u0007wBqa! 5\u0001\u0004\u0011)0\u0001\u0007gKR\u001c\u0007n\u00144gg\u0016$8/\u0001\rhKR|eMZ:fiR\u0013XO\\2bi&|gn\u0015;bi\u0016$bAa\u0006\u0004\u0004\u000e\u0015\u0005bBB\u0002k\u0001\u0007\u00111\u001e\u0005\b\u0007\u000f+\u0004\u0019\u0001Bb\u0003EaW-\u00193fe\u0016\u0003xn\u00195PM\u001a\u001cX\r^\u0001\u0017M\u0016$8\r[(gMN,G/\u00118e)J,hnY1uKRA\u00111PBG\u0007\u001f\u001b\u0019\nC\u0004\u0002jZ\u0002\r!a;\t\u000f\rEe\u00071\u0001\u0004p\u00059Ao\u001c9jG&#\u0007bBBKm\u0001\u0007\u0011\u0011A\u0001\u0013GV\u0014(/\u001a8u\u0019\u0016\fG-\u001a:Fa>\u001c\u0007.A\u000biC:$G.Z(vi>3'+\u00198hK\u0016\u0013(o\u001c:\u0015\u0011\u0005-11TBO\u0007CCq!!;8\u0001\u0004\tY\u000fC\u0004\u0004 ^\u0002\r!a\u001f\u0002\u0015\u0019,Go\u00195Ti\u0006$X\rC\u0004\u0004$^\u0002\rAa\u000b\u0002)1,\u0017\rZ3s\u000bB|7\r[%o%\u0016\fX/Z:u\u0003\u0005B\u0017M\u001c3mK>3gm]3ug6{g/\u001a3U_RKWM]3e'R|'/Y4f))\tYa!+\u0004,\u000e56q\u0016\u0005\b\u0003SD\u0004\u0019AAv\u0011\u001d\u0019y\n\u000fa\u0001\u0003wBqaa)9\u0001\u0004\u0011Y\u0003C\u0004\u00042b\u0002\raa-\u0002%\u0019,Go\u00195QCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\t\u0005\u0007k\u000b)F\u0004\u0003\u0003H\u0006E\u0013a\u00043fY\u0006L\b+\u0019:uSRLwN\\:\u0015\r\t-11XB_\u0011\u001d\u0011\t(\u000fa\u0001\u0005gBqaa0:\u0001\u0004\t)0A\u0003eK2\f\u00170\u0001\tsK6|g/\u001a)beRLG/[8ogR!1QYBd!!\u0011)Ja'\u0002l\u0006m\u0004bBBeu\u0001\u0007!\u0011U\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8og\u0006\u0019\"/Z7pm\u0016\fE\u000e\u001c)beRLG/[8ogR\u00111QY\u0001\u000fa\u0006\u0014H/\u001b;j_:\u001cu.\u001e8u+\t\t\t!\u0006\u0002\u0003\"R!1q[Bm!\u0019\t\u0019!a6\u0002|!9\u0011\u0011\u001e A\u0002\u0005-\u0018a\u0004;p\u001b\u0016lwN]=SK\u000e|'\u000fZ:\u0015\t\r}71\u001e\t\u0005\u0007C\u001c9/\u0004\u0002\u0004d*!1Q]A'\u0003\u0019\u0011XmY8sI&!1\u0011^Br\u00055iU-\\8ssJ+7m\u001c:eg\"91Q^ A\u0002\r=\u0018a\u0002:fG>\u0014Hm\u001d\t\u0005\u0007C\u001c\t0\u0003\u0003\u0004t\u000e\r(a\u0002*fG>\u0014Hm]\u0001\u0016\u0003\n\u001cHO]1di\u001a+Go\u00195feRC'/Z1e!\t1\u0018iE\u0002B\u0007w\u0004B!a\u0001\u0004~&\u00191q`3\u0003\r\u0005s\u0017PU3g)\t\u001990A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEN\u000b\u0003\t\u000fQC!!\u0001\u0005\n-\u0012A1\u0002\t\u0005\t\u001b!9\"\u0004\u0002\u0005\u0010)!A\u0011\u0003C\n\u0003%)hn\u00195fG.,GMC\u0002\u0005\u0016\u0015\f!\"\u00198o_R\fG/[8o\u0013\u0011!I\u0002b\u0004\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeN\u000b\u0003\t?QC!a\u0003\u0005\n\u0001")
public abstract class AbstractFetcherThread
extends ShutdownableThread
implements Logging {
    private final LeaderEndPoint leader;
    private final FailedPartitions failedPartitions;
    private final TierStateMachine fetchTierStateMachine;
    private final int fetchBackOffMs;
    private final BrokerTopicStats brokerTopicStats;
    private final PartitionStates<PartitionFetchState> partitionStates;
    private final ReentrantLock partitionMapLock;
    private final Condition partitionMapCond;
    private final ClientIdAndBroker metricId;
    private final FetcherStats fetcherStats;
    private final FetcherLagStats fetcherLagStats;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$7() {
        return true;
    }

    public static int $lessinit$greater$default$6() {
        return 0;
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public LeaderEndPoint leader() {
        return this.leader;
    }

    public TierStateMachine fetchTierStateMachine() {
        return this.fetchTierStateMachine;
    }

    public BrokerTopicStats brokerTopicStats() {
        return this.brokerTopicStats;
    }

    private PartitionStates<PartitionFetchState> partitionStates() {
        return this.partitionStates;
    }

    public ReentrantLock partitionMapLock() {
        return this.partitionMapLock;
    }

    private Condition partitionMapCond() {
        return this.partitionMapCond;
    }

    private ClientIdAndBroker metricId() {
        return this.metricId;
    }

    public FetcherStats fetcherStats() {
        return this.fetcherStats;
    }

    public FetcherLagStats fetcherLagStats() {
        return this.fetcherLagStats;
    }

    public abstract Option<LogAppendInfo> processPartitionData(TopicPartition var1, long var2, int var4, FetchResponseData.PartitionData var5);

    public abstract void truncate(TopicPartition var1, OffsetTruncationState var2);

    public abstract void truncateFullyAndStartAt(TopicPartition var1, long var2);

    public abstract Optional<Integer> latestEpoch(TopicPartition var1);

    public abstract long logStartOffset(TopicPartition var1);

    public abstract long logEndOffset(TopicPartition var1);

    public abstract Optional<OffsetAndEpoch> endOffsetForEpoch(TopicPartition var1, int var2);

    public void shutdown() {
        this.initiateShutdown();
        ReentrantLock inLock_lock = this.partitionMapLock();
        inLock_lock.lock();
        try {
            AbstractFetcherThread.$anonfun$shutdown$1(this);
        }
        finally {
            inLock_lock.unlock();
        }
        Object var1_1 = null;
        this.awaitShutdown();
        this.fetcherStats().unregister();
        this.fetcherLagStats().unregister();
    }

    public void doWork() {
        this.maybeTruncate();
        this.maybeFetch();
    }

    private void maybeFetch() {
        Optional optional;
        ReentrantLock inLock_lock = this.partitionMapLock();
        inLock_lock.lock();
        try {
            optional = AbstractFetcherThread.$anonfun$maybeFetch$1(this);
        }
        finally {
            inLock_lock.unlock();
        }
        Object var1_1 = null;
        optional.ifPresent(replicaFetch -> this.processFetchRequest(replicaFetch.partitionData(), replicaFetch.fetchRequest()));
    }

    private void handlePartitionsWithErrors(Iterable<TopicPartition> partitions, String methodName) {
        if (partitions.nonEmpty()) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Handling errors in " + methodName + " for partitions " + partitions);
            this.delayPartitions(partitions, this.fetchBackOffMs);
            return;
        }
    }

    private Tuple2<Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition>, Set<TopicPartition>> fetchTruncatingPartitions() {
        Tuple2 tuple2;
        ReentrantLock inLock_lock = this.partitionMapLock();
        inLock_lock.lock();
        try {
            tuple2 = AbstractFetcherThread.$anonfun$fetchTruncatingPartitions$1(this);
        }
        finally {
            inLock_lock.unlock();
        }
        return tuple2;
    }

    /*
     * WARNING - void declaration
     */
    private void maybeTruncate() {
        void var3_3;
        void var2_2;
        Tuple2<Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition>, Set<TopicPartition>> tuple2 = this.fetchTruncatingPartitions();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Map partitionsWithEpochs = (Map)tuple2._1();
        Set partitionsWithoutEpochs = (Set)tuple2._2();
        if (var2_2.nonEmpty()) {
            this.truncateToEpochEndOffsets((Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition>)var2_2);
        }
        if (var3_3.nonEmpty()) {
            this.truncateToHighWatermark((Set<TopicPartition>)var3_3);
            return;
        }
    }

    private boolean doTruncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
        try {
            this.truncate(topicPartition, truncationState);
            return true;
        }
        catch (KafkaStorageException e) {
            this.error((Function0<String>)(Function0 & Serializable)() -> "Failed to truncate " + topicPartition + " at offset " + truncationState.offset(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
            this.markPartitionFailed(topicPartition);
            return false;
        }
        catch (Throwable t) {
            this.error((Function0<String>)(Function0 & Serializable)() -> "Unexpected error occurred during truncation for " + topicPartition + " at offset " + truncationState.offset(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
            this.markPartitionFailed(topicPartition);
            return false;
        }
    }

    private void truncateToEpochEndOffsets(Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> latestEpochsForPartitions) {
        java.util.Map endOffsets = this.leader().fetchEpochEndOffsets(CollectionConverters$.MODULE$.MapHasAsJava(latestEpochsForPartitions).asJava());
        ReentrantLock inLock_lock = this.partitionMapLock();
        inLock_lock.lock();
        try {
            AbstractFetcherThread.$anonfun$truncateToEpochEndOffsets$1(this, endOffsets, latestEpochsForPartitions);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    public void truncateOnFetchResponse(Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> epochEndOffsets) {
        ReentrantLock inLock_lock = this.partitionMapLock();
        inLock_lock.lock();
        try {
            AbstractFetcherThread.$anonfun$truncateOnFetchResponse$1(this, epochEndOffsets);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    public void truncateToHighWatermark(Set<TopicPartition> partitions) {
        ReentrantLock inLock_lock = this.partitionMapLock();
        inLock_lock.lock();
        try {
            AbstractFetcherThread.$anonfun$truncateToHighWatermark$1(this, partitions);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    private ResultWithPartitions<Map<TopicPartition, OffsetTruncationState>> maybeTruncateToEpochEndOffsets(Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchedEpochs, Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> latestEpochsForPartitions) {
        HashMap fetchOffsets = HashMap$.MODULE$.empty();
        HashSet partitionsWithError = HashSet$.MODULE$.empty();
        fetchedEpochs.foreachEntry((Function2 & Serializable)(tp, leaderEpochOffset) -> {
            if (this.partitionStates().contains(tp)) {
                Errors errors = Errors.forCode((short)leaderEpochOffset.errorCode());
                if (Errors.NONE.equals(errors)) {
                    OffsetTruncationState offsetTruncationState = this.getOffsetTruncationState((TopicPartition)tp, (OffsetForLeaderEpochResponseData.EpochEndOffset)leaderEpochOffset);
                    this.info((Function0<String>)(Function0 & Serializable)() -> "Truncating partition " + tp + " with " + offsetTruncationState + " due to leader epoch and offset " + leaderEpochOffset);
                    if (this.doTruncate((TopicPartition)tp, offsetTruncationState)) {
                        return fetchOffsets.put(tp, (Object)offsetTruncationState);
                    }
                    return BoxedUnit.UNIT;
                }
                if (Errors.FENCED_LEADER_EPOCH.equals(errors)) {
                    Optional currentLeaderEpoch = OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(latestEpochsForPartitions.get(tp).map((Function1 & Serializable)epochEndOffset -> BoxesRunTime.boxToInteger((int)epochEndOffset.currentLeaderEpoch()))));
                    if (this.onPartitionFenced((TopicPartition)tp, currentLeaderEpoch)) {
                        return partitionsWithError.$plus$eq(tp);
                    }
                    return BoxedUnit.UNIT;
                }
                this.info((Function0<String>)(Function0 & Serializable)() -> "Retrying leaderEpoch request for partition " + tp + " as the leader reported an error: " + errors);
                return partitionsWithError.$plus$eq(tp);
            }
            this.trace((Function0<String>)(Function0 & Serializable)() -> "Ignoring epoch offsets for partition " + tp + " since it has been removed from this fetcher thread.");
            return BoxedUnit.UNIT;
        });
        return new ResultWithPartitions((Object)fetchOffsets, CollectionConverters$.MODULE$.MutableSetHasAsJava((scala.collection.mutable.Set)partitionsWithError).asJava());
    }

    private boolean onPartitionFenced(TopicPartition tp, Optional<Integer> requestEpoch) {
        boolean bl;
        ReentrantLock inLock_lock = this.partitionMapLock();
        inLock_lock.lock();
        try {
            bl = AbstractFetcherThread.$anonfun$onPartitionFenced$1(this, tp, requestEpoch);
        }
        finally {
            inLock_lock.unlock();
        }
        return bl;
    }

    public void processFetchRequest(java.util.Map<TopicPartition, FetchRequest.PartitionData> sessionPartitions, FetchRequest.Builder fetchRequest) {
        Map map;
        scala.collection.mutable.Map divergingEndOffsets;
        scala.collection.mutable.Set partitionsWithError;
        block11: {
            partitionsWithError = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
            divergingEndOffsets = (scala.collection.mutable.Map)Map$.MODULE$.empty();
            map = (Map)scala.collection.Map$.MODULE$.empty();
            try {
                this.trace((Function0<String>)(Function0 & Serializable)() -> "Sending fetch request " + fetchRequest);
                map = CollectionConverters$.MODULE$.MapHasAsScala(this.leader().fetch(fetchRequest)).asScala();
            }
            catch (Throwable t) {
                if (!this.isRunning()) break block11;
                this.warn((Function0<String>)(Function0 & Serializable)() -> "Error in response for fetch request " + fetchRequest, (Function0<Throwable>)(Function0 & Serializable)() -> t);
                ReentrantLock inLock_lock = this.partitionMapLock();
                inLock_lock.lock();
                try {
                    AbstractFetcherThread.$anonfun$processFetchRequest$4(this, partitionsWithError);
                }
                finally {
                    inLock_lock.unlock();
                }
                Object var6_7 = null;
            }
        }
        this.fetcherStats().requestRate().mark();
        if (map.nonEmpty()) {
            ReentrantLock inLock_lock = this.partitionMapLock();
            inLock_lock.lock();
            try {
                map.foreachEntry((Function2 & Serializable)(topicPartition, partitionData) -> {
                    AbstractFetcherThread.$anonfun$processFetchRequest$6(this, sessionPartitions$1, divergingEndOffsets$1, partitionsWithError$2, topicPartition, partitionData);
                    return BoxedUnit.UNIT;
                });
            }
            finally {
                inLock_lock.unlock();
            }
            Object var8_9 = null;
        }
        if (divergingEndOffsets.nonEmpty()) {
            this.truncateOnFetchResponse((Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset>)divergingEndOffsets);
        }
        if (partitionsWithError.nonEmpty()) {
            this.handlePartitionsWithErrors((Iterable<TopicPartition>)partitionsWithError, "processFetchRequest");
            return;
        }
    }

    public void markPartitionsForTruncation(TopicPartition topicPartition, long truncationOffset) {
        this.partitionMapLock().lockInterruptibly();
        try {
            Option$.MODULE$.apply(this.partitionStates().stateValue(topicPartition)).foreach((Function1 & Serializable)state -> {
                AbstractFetcherThread.$anonfun$markPartitionsForTruncation$1(this, truncationOffset, topicPartition, state);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            this.partitionMapLock().unlock();
        }
    }

    private void markPartitionFailed(TopicPartition topicPartition) {
        this.partitionMapLock().lock();
        try {
            this.failedPartitions.add(topicPartition);
            this.removePartitions((Set<TopicPartition>)((Set)scala.collection.Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))));
        }
        finally {
            this.partitionMapLock().unlock();
        }
        this.warn((Function0<String>)(Function0 & Serializable)() -> "Partition " + topicPartition + " marked as failed");
    }

    private PartitionFetchState partitionFetchState(TopicPartition tp, InitialFetchState initialFetchState, PartitionFetchState currentState) {
        if (currentState != null && currentState.currentLeaderEpoch() == initialFetchState.currentLeaderEpoch()) {
            return currentState;
        }
        if (initialFetchState.initOffset() < 0L) {
            return this.fetchOffsetAndTruncate(tp, initialFetchState.topicId(), initialFetchState.currentLeaderEpoch());
        }
        if (this.leader().isTruncationOnFetchSupported()) {
            Optional<Integer> lastFetchedEpoch = this.latestEpoch(tp);
            ReplicaState state = lastFetchedEpoch.isPresent() ? ReplicaState.FETCHING : ReplicaState.TRUNCATING;
            return new PartitionFetchState(OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(initialFetchState.topicId())), initialFetchState.initOffset(), Optional.empty(), initialFetchState.currentLeaderEpoch(), state, lastFetchedEpoch);
        }
        return new PartitionFetchState(OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(initialFetchState.topicId())), initialFetchState.initOffset(), Optional.empty(), initialFetchState.currentLeaderEpoch(), ReplicaState.TRUNCATING, Optional.empty());
    }

    public Set<TopicPartition> addPartitions(Map<TopicPartition, InitialFetchState> initialFetchStates) {
        Set set;
        this.partitionMapLock().lockInterruptibly();
        try {
            this.failedPartitions.removeAll((Set<TopicPartition>)initialFetchStates.keySet());
            initialFetchStates.foreachEntry((Function2 & Serializable)(tp, initialFetchState) -> {
                AbstractFetcherThread.$anonfun$addPartitions$1(this, tp, initialFetchState);
                return BoxedUnit.UNIT;
            });
            this.partitionMapCond().signalAll();
            set = initialFetchStates.keySet();
        }
        finally {
            this.partitionMapLock().unlock();
        }
        return set;
    }

    public void maybeUpdateTopicIds(Set<TopicPartition> partitions, Function1<String, Option<Uuid>> topicIds) {
        this.partitionMapLock().lockInterruptibly();
        try {
            partitions.foreach((Function1 & Serializable)tp -> {
                AbstractFetcherThread.$anonfun$maybeUpdateTopicIds$1(this, topicIds, tp);
                return BoxedUnit.UNIT;
            });
            this.partitionMapCond().signalAll();
        }
        finally {
            this.partitionMapLock().unlock();
        }
    }

    private void updateFetchOffsetAndMaybeMarkTruncationComplete(Map<TopicPartition, OffsetTruncationState> fetchOffsets) {
        Map newStates = (Map)CollectionConverters$.MODULE$.MapHasAsScala(this.partitionStates().partitionStateMap()).asScala().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                PartitionFetchState partitionFetchState;
                TopicPartition topicPartition = (TopicPartition)x0$1._1();
                PartitionFetchState currentFetchState = (PartitionFetchState)x0$1._2();
                Option option = fetchOffsets.get((Object)topicPartition);
                if (option instanceof Some) {
                    OffsetTruncationState offsetTruncationState = (OffsetTruncationState)((Some)option).value();
                    Optional<Integer> lastFetchedEpoch = this.latestEpoch(topicPartition);
                    ReplicaState state = this.leader().isTruncationOnFetchSupported() || offsetTruncationState.truncationCompleted() ? ReplicaState.FETCHING : ReplicaState.TRUNCATING;
                    partitionFetchState = new PartitionFetchState(currentFetchState.topicId(), offsetTruncationState.offset(), currentFetchState.lag(), currentFetchState.currentLeaderEpoch(), currentFetchState.delay(), state, lastFetchedEpoch);
                } else if (None$.MODULE$.equals(option)) {
                    partitionFetchState = currentFetchState;
                } else {
                    throw new MatchError((Object)option);
                }
                PartitionFetchState maybeTruncationComplete = partitionFetchState;
                return new Tuple2((Object)topicPartition, (Object)maybeTruncationComplete);
            }
            throw new MatchError(null);
        });
        this.partitionStates().set(CollectionConverters$.MODULE$.MapHasAsJava(newStates).asJava());
    }

    private OffsetTruncationState getOffsetTruncationState(TopicPartition tp, OffsetForLeaderEpochResponseData.EpochEndOffset leaderEpochOffset) {
        OffsetTruncationState offsetTruncationState;
        ReentrantLock inLock_lock = this.partitionMapLock();
        inLock_lock.lock();
        try {
            offsetTruncationState = AbstractFetcherThread.$anonfun$getOffsetTruncationState$1(this, leaderEpochOffset, tp);
        }
        finally {
            inLock_lock.unlock();
        }
        return offsetTruncationState;
    }

    private PartitionFetchState fetchOffsetAndTruncate(TopicPartition topicPartition, Option<Uuid> topicId, int currentLeaderEpoch) {
        long replicaEndOffset = this.logEndOffset(topicPartition);
        long leaderEndOffset = this.leader().fetchLatestOffset(topicPartition, currentLeaderEpoch).offset();
        if (leaderEndOffset < replicaEndOffset) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> "Reset fetch offset for partition " + topicPartition + " from " + replicaEndOffset + " to current leader's latest offset " + leaderEndOffset);
            this.truncate(topicPartition, new OffsetTruncationState(leaderEndOffset, true));
            this.fetcherLagStats().getAndMaybePut(topicPartition).lag_$eq(0L);
            return new PartitionFetchState(OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(topicId)), leaderEndOffset, Optional.of(Predef$.MODULE$.long2Long(0L)), currentLeaderEpoch, ReplicaState.FETCHING, this.latestEpoch(topicPartition));
        }
        long leaderStartOffset = this.leader().fetchEarliestOffset(topicPartition, currentLeaderEpoch).offset();
        long offsetToFetch = Math.max(leaderStartOffset, replicaEndOffset);
        if (leaderStartOffset > replicaEndOffset) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> "Truncate fully and reset fetch offset for partition " + topicPartition + " from " + replicaEndOffset + " to the current leader's start offset " + leaderStartOffset + " because the local replica's end offset is smaller than the current leader's start offsets.");
            this.truncateFullyAndStartAt(topicPartition, leaderStartOffset);
        } else {
            this.info((Function0<String>)(Function0 & Serializable)() -> "Reset fetch offset for partition " + topicPartition + " from " + replicaEndOffset + " to the current local replica's end offset " + offsetToFetch);
        }
        long initialLag = leaderEndOffset - offsetToFetch;
        this.fetcherLagStats().getAndMaybePut(topicPartition).lag_$eq(initialLag);
        return new PartitionFetchState(OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(topicId)), offsetToFetch, Optional.of(Predef$.MODULE$.long2Long(initialLag)), currentLeaderEpoch, ReplicaState.FETCHING, this.latestEpoch(topicPartition));
    }

    private boolean handleOutOfRangeError(TopicPartition topicPartition, PartitionFetchState fetchState, Optional<Integer> leaderEpochInRequest) {
        try {
            PartitionFetchState newFetchState = this.fetchOffsetAndTruncate(topicPartition, (Option<Uuid>)OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(fetchState.topicId())), fetchState.currentLeaderEpoch());
            this.partitionStates().updateAndMoveToEnd(topicPartition, (Object)newFetchState);
            this.info((Function0<String>)(Function0 & Serializable)() -> "Current offset " + fetchState.fetchOffset() + " for partition " + topicPartition + " is out of range, which typically implies a leader change. Reset fetch offset to " + newFetchState.fetchOffset());
            return true;
        }
        catch (Throwable throwable) {
            if (throwable instanceof FencedLeaderEpochException) {
                return this.onPartitionFenced(topicPartition, leaderEpochInRequest);
            }
            if (throwable instanceof UnknownTopicOrPartitionException ? true : (throwable instanceof UnknownLeaderEpochException ? true : throwable instanceof NotLeaderOrFollowerException)) {
                this.info((Function0<String>)(Function0 & Serializable)() -> "Could not fetch offset for " + topicPartition + " due to error: " + throwable.getMessage());
                return false;
            }
            if (throwable != null) {
                this.error((Function0<String>)(Function0 & Serializable)() -> "Error getting offset for partition " + topicPartition, (Function0<Throwable>)(Function0 & Serializable)() -> throwable);
                return false;
            }
            throw null;
        }
    }

    private boolean handleOffsetsMovedToTieredStorage(TopicPartition topicPartition, PartitionFetchState fetchState, Optional<Integer> leaderEpochInRequest, FetchResponseData.PartitionData fetchPartitionData) {
        try {
            PartitionFetchState newFetchState = this.fetchTierStateMachine().start(topicPartition, fetchState, fetchPartitionData);
            this.fetcherLagStats().getAndMaybePut(topicPartition).lag_$eq(Predef$.MODULE$.Long2long(newFetchState.lag().orElse(Predef$.MODULE$.long2Long(0L))));
            this.partitionStates().updateAndMoveToEnd(topicPartition, (Object)newFetchState);
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Current offset " + fetchState.fetchOffset() + " for partition " + topicPartition + " is out of range or moved to remote tier. Reset fetch offset to " + newFetchState.fetchOffset());
            return true;
        }
        catch (Throwable throwable) {
            if (throwable instanceof FencedLeaderEpochException) {
                return this.onPartitionFenced(topicPartition, leaderEpochInRequest);
            }
            if (throwable instanceof UnknownTopicOrPartitionException ? true : (throwable instanceof UnknownLeaderEpochException ? true : (throwable instanceof NotLeaderOrFollowerException ? true : throwable instanceof RetriableRemoteStorageException))) {
                this.info((Function0<String>)(Function0 & Serializable)() -> "Could not build remote log auxiliary state for " + topicPartition + " due to error: " + throwable.getMessage());
                return false;
            }
            if (throwable != null) {
                this.error((Function0<String>)(Function0 & Serializable)() -> "Error building remote log auxiliary state for " + topicPartition, (Function0<Throwable>)(Function0 & Serializable)() -> throwable);
                return false;
            }
            throw null;
        }
    }

    private void delayPartitions(Iterable<TopicPartition> partitions, long delay) {
        this.partitionMapLock().lockInterruptibly();
        try {
            partitions.foreach((Function1 & Serializable)partition -> {
                AbstractFetcherThread.$anonfun$delayPartitions$1(this, delay, partition);
                return BoxedUnit.UNIT;
            });
            this.partitionMapCond().signalAll();
        }
        finally {
            this.partitionMapLock().unlock();
        }
    }

    public Map<TopicPartition, PartitionFetchState> removePartitions(Set<TopicPartition> topicPartitions) {
        scala.collection.immutable.Map map;
        this.partitionMapLock().lockInterruptibly();
        try {
            map = ((IterableOnceOps)((IterableOps)topicPartitions.map((Function1 & Serializable)topicPartition -> {
                PartitionFetchState state = (PartitionFetchState)this.partitionStates().stateValue(topicPartition);
                this.partitionStates().remove(topicPartition);
                this.fetcherLagStats().unregister((TopicPartition)topicPartition);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topicPartition), (Object)state);
            })).filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherThread.$anonfun$removePartitions$2(x$3)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        finally {
            this.partitionMapLock().unlock();
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    public Map<TopicPartition, PartitionFetchState> removeAllPartitions() {
        void v0;
        this.partitionMapLock().lockInterruptibly();
        try {
            void var1_1;
            scala.collection.immutable.Map allPartitionState = CollectionConverters$.MODULE$.MapHasAsScala(this.partitionStates().partitionStateMap()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            allPartitionState.keys().foreach((Function1 & Serializable)tp -> {
                AbstractFetcherThread.$anonfun$removeAllPartitions$1(this, tp);
                return BoxedUnit.UNIT;
            });
            v0 = var1_1;
        }
        finally {
            this.partitionMapLock().unlock();
        }
        return v0;
    }

    public int partitionCount() {
        int n;
        this.partitionMapLock().lockInterruptibly();
        try {
            n = this.partitionStates().size();
        }
        finally {
            this.partitionMapLock().unlock();
        }
        return n;
    }

    public Set<TopicPartition> partitions() {
        scala.collection.immutable.Set set;
        this.partitionMapLock().lockInterruptibly();
        try {
            set = CollectionConverters$.MODULE$.SetHasAsScala(this.partitionStates().partitionSet()).asScala().toSet();
        }
        finally {
            this.partitionMapLock().unlock();
        }
        return set;
    }

    public Option<PartitionFetchState> fetchState(TopicPartition topicPartition) {
        Option option;
        ReentrantLock inLock_lock = this.partitionMapLock();
        inLock_lock.lock();
        try {
            option = Option$.MODULE$.apply(this.partitionStates().stateValue(topicPartition));
        }
        finally {
            inLock_lock.unlock();
        }
        return option;
    }

    public MemoryRecords toMemoryRecords(Records records) {
        if (records instanceof MemoryRecords) {
            return (MemoryRecords)records;
        }
        if (records instanceof FileRecords) {
            FileRecords fileRecords = (FileRecords)records;
            ByteBuffer buffer = ByteBuffer.allocate(fileRecords.sizeInBytes());
            fileRecords.readInto(buffer, 0);
            return MemoryRecords.readableRecords((ByteBuffer)buffer);
        }
        throw new MatchError((Object)records);
    }

    public static final /* synthetic */ void $anonfun$shutdown$1(AbstractFetcherThread $this) {
        $this.partitionMapCond().signalAll();
    }

    public static final /* synthetic */ Optional $anonfun$maybeFetch$1(AbstractFetcherThread $this) {
        ResultWithPartitions result = $this.leader().buildFetch($this.partitionStates().partitionStateMap());
        Optional fetchRequestOpt = (Optional)result.result();
        java.util.Set partitionsWithError = result.partitionsWithError();
        $this.handlePartitionsWithErrors((Iterable<TopicPartition>)CollectionConverters$.MODULE$.SetHasAsScala(partitionsWithError).asScala(), "maybeFetch");
        if (fetchRequestOpt.isEmpty()) {
            $this.trace((Function0<String>)(Function0 & Serializable)() -> "There are no active partitions. Back off for " + $this.fetchBackOffMs + " ms before sending a fetch request");
            $this.partitionMapCond().await($this.fetchBackOffMs, TimeUnit.MILLISECONDS);
        }
        return fetchRequestOpt;
    }

    public static final /* synthetic */ Tuple2 $anonfun$fetchTruncatingPartitions$1(AbstractFetcherThread $this) {
        scala.collection.mutable.Map partitionsWithEpochs = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        scala.collection.mutable.Set partitionsWithoutEpochs = (scala.collection.mutable.Set)Set$.MODULE$.empty();
        $this.partitionStates().partitionStateMap().forEach((tp, state) -> {
            if (state.isTruncating()) {
                Option option = OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional($this.latestEpoch((TopicPartition)tp)));
                if (option instanceof Some) {
                    Integer epoch = (Integer)((Some)option).value();
                    partitionsWithEpochs.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), (Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(tp.partition()).setCurrentLeaderEpoch(state.currentLeaderEpoch()).setLeaderEpoch(Predef$.MODULE$.Integer2int(epoch))));
                    return;
                }
                partitionsWithoutEpochs.$plus$eq(tp);
                return;
            }
        });
        return new Tuple2((Object)partitionsWithEpochs, (Object)partitionsWithoutEpochs);
    }

    public static final /* synthetic */ boolean $anonfun$truncateToEpochEndOffsets$2(AbstractFetcherThread $this, Map latestEpochsForPartitions$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            PartitionFetchState curPartitionState = (PartitionFetchState)$this.partitionStates().stateValue(tp);
            int leaderEpochInRequest = ((OffsetForLeaderEpochRequestData.OffsetForLeaderPartition)latestEpochsForPartitions$1.getOrElse((Object)tp, (Function0 & Serializable)() -> {
                throw new IllegalStateException("Leader replied with partition " + tp + " not requested in OffsetsForLeaderEpoch request");
            })).currentLeaderEpoch();
            return curPartitionState != null && leaderEpochInRequest == curPartitionState.currentLeaderEpoch();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$truncateToEpochEndOffsets$1(AbstractFetcherThread $this, java.util.Map endOffsets$1, Map latestEpochsForPartitions$1) {
        scala.collection.mutable.Map epochEndOffsets = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(endOffsets$1).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherThread.$anonfun$truncateToEpochEndOffsets$2($this, latestEpochsForPartitions$1, x0$1)));
        ResultWithPartitions<Map<TopicPartition, OffsetTruncationState>> result = $this.maybeTruncateToEpochEndOffsets((Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset>)epochEndOffsets, (Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition>)latestEpochsForPartitions$1);
        $this.handlePartitionsWithErrors((Iterable<TopicPartition>)CollectionConverters$.MODULE$.SetHasAsScala(result.partitionsWithError()).asScala(), "truncateToEpochEndOffsets");
        $this.updateFetchOffsetAndMaybeMarkTruncationComplete((Map<TopicPartition, OffsetTruncationState>)((Map)result.result()));
    }

    public static final /* synthetic */ void $anonfun$truncateOnFetchResponse$1(AbstractFetcherThread $this, Map epochEndOffsets$1) {
        ResultWithPartitions<Map<TopicPartition, OffsetTruncationState>> result = $this.maybeTruncateToEpochEndOffsets((Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset>)epochEndOffsets$1, (Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition>)((Map)scala.collection.Map$.MODULE$.empty()));
        $this.handlePartitionsWithErrors((Iterable<TopicPartition>)CollectionConverters$.MODULE$.SetHasAsScala(result.partitionsWithError()).asScala(), "truncateOnFetchResponse");
        $this.updateFetchOffsetAndMaybeMarkTruncationComplete((Map<TopicPartition, OffsetTruncationState>)((Map)result.result()));
    }

    public static final /* synthetic */ void $anonfun$truncateToHighWatermark$1(AbstractFetcherThread $this, Set partitions$2) {
        HashMap fetchOffsets = HashMap$.MODULE$.empty();
        partitions$2.foreach((Function1 & Serializable)tp -> {
            PartitionFetchState partitionState = (PartitionFetchState)$this.partitionStates().stateValue(tp);
            if (partitionState != null) {
                long highWatermark = partitionState.fetchOffset();
                OffsetTruncationState truncationState = new OffsetTruncationState(highWatermark, true);
                $this.info((Function0<String>)(Function0 & Serializable)() -> "Truncating partition " + tp + " with " + truncationState + " due to local high watermark " + highWatermark);
                if ($this.doTruncate((TopicPartition)tp, truncationState)) {
                    return fetchOffsets.put(tp, (Object)truncationState);
                }
                return BoxedUnit.UNIT;
            }
            return BoxedUnit.UNIT;
        });
        $this.updateFetchOffsetAndMaybeMarkTruncationComplete((Map<TopicPartition, OffsetTruncationState>)fetchOffsets);
    }

    public static final /* synthetic */ boolean $anonfun$onPartitionFenced$2(AbstractFetcherThread $this, Optional requestEpoch$1, TopicPartition tp$4, PartitionFetchState currentFetchState) {
        int currentLeaderEpoch = currentFetchState.currentLeaderEpoch();
        if (requestEpoch$1.isPresent() && BoxesRunTime.equals(requestEpoch$1.get(), (Object)BoxesRunTime.boxToInteger((int)currentLeaderEpoch))) {
            $this.info((Function0<String>)(Function0 & Serializable)() -> "Partition " + tp$4 + " has an older epoch (" + currentLeaderEpoch + ") than the current leader. Will await the new LeaderAndIsr state before resuming fetching.");
            $this.markPartitionFailed(tp$4);
            return false;
        }
        $this.info((Function0<String>)(Function0 & Serializable)() -> "Partition " + tp$4 + " has a newer epoch (" + currentLeaderEpoch + ") than the current leader. Retry the partition later.");
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$onPartitionFenced$1(AbstractFetcherThread $this, TopicPartition tp$4, Optional requestEpoch$1) {
        return Option$.MODULE$.apply($this.partitionStates().stateValue(tp$4)).exists((Function1 & Serializable)currentFetchState -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherThread.$anonfun$onPartitionFenced$2($this, requestEpoch$1, tp$4, currentFetchState)));
    }

    public static final /* synthetic */ scala.collection.mutable.Set $anonfun$processFetchRequest$4(AbstractFetcherThread $this, scala.collection.mutable.Set partitionsWithError$2) {
        return (scala.collection.mutable.Set)partitionsWithError$2.$plus$plus$eq((IterableOnce)CollectionConverters$.MODULE$.SetHasAsScala($this.partitionStates().partitionSet()).asScala());
    }

    public static final /* synthetic */ boolean $anonfun$processFetchRequest$8(PartitionFetchState currentFetchState$1, Integer x$2) {
        return BoxesRunTime.equalsNumObject((Number)x$2, (Object)BoxesRunTime.boxToInteger((int)currentFetchState$1.currentLeaderEpoch()));
    }

    public static final /* synthetic */ void $anonfun$processFetchRequest$9(AbstractFetcherThread $this, PartitionFetchState currentFetchState$1, FetchResponseData.PartitionData partitionData$1, TopicPartition topicPartition$2, LogAppendInfo logAppendInfo) {
        int validBytes = logAppendInfo.validBytes();
        long nextOffset = validBytes > 0 ? logAppendInfo.lastOffset() + 1L : currentFetchState$1.fetchOffset();
        long lag = Math.max(0L, partitionData$1.highWatermark() - nextOffset);
        $this.fetcherLagStats().getAndMaybePut(topicPartition$2).lag_$eq(lag);
        if ((validBytes > 0 || currentFetchState$1.lag().isEmpty()) && $this.partitionStates().contains(topicPartition$2)) {
            Optional lastFetchedEpoch = logAppendInfo.lastLeaderEpoch().isPresent() ? logAppendInfo.lastLeaderEpoch() : currentFetchState$1.lastFetchedEpoch();
            PartitionFetchState newFetchState = new PartitionFetchState(currentFetchState$1.topicId(), nextOffset, Optional.of(Predef$.MODULE$.long2Long(lag)), currentFetchState$1.currentLeaderEpoch(), ReplicaState.FETCHING, lastFetchedEpoch);
            $this.partitionStates().updateAndMoveToEnd(topicPartition$2, (Object)newFetchState);
            if (validBytes > 0) {
                $this.fetcherStats().byteRate().mark((long)validBytes);
                return;
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$processFetchRequest$6(AbstractFetcherThread $this, java.util.Map sessionPartitions$1, scala.collection.mutable.Map divergingEndOffsets$1, scala.collection.mutable.Set partitionsWithError$2, TopicPartition topicPartition, FetchResponseData.PartitionData partitionData) {
        Option$.MODULE$.apply($this.partitionStates().stateValue(topicPartition)).foreach((Function1 & Serializable)currentFetchState -> {
            FetchRequest.PartitionData fetchPartitionData = (FetchRequest.PartitionData)sessionPartitions$1.get(topicPartition);
            if (fetchPartitionData != null && fetchPartitionData.fetchOffset == currentFetchState.fetchOffset() && BoxesRunTime.unboxToBoolean((Object)fetchPartitionData.currentLeaderEpoch.map(x$2 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherThread.$anonfun$processFetchRequest$8(currentFetchState, x$2))).orElse(BoxesRunTime.boxToBoolean((boolean)true))) && currentFetchState.isReadyForFetch()) {
                Errors errors = Errors.forCode((short)partitionData.errorCode());
                if (Errors.NONE.equals(errors)) {
                    Growable growable;
                    try {
                        if (!$this.leader().isTruncationOnFetchSupported() || !FetchResponse.isDivergingEpoch((FetchResponseData.PartitionData)partitionData)) {
                            $this.processPartitionData(topicPartition, currentFetchState.fetchOffset(), currentFetchState.currentLeaderEpoch(), partitionData).foreach((Function1 & Serializable)logAppendInfo -> {
                                AbstractFetcherThread.$anonfun$processFetchRequest$9($this, currentFetchState, partitionData, topicPartition, logAppendInfo);
                                return BoxedUnit.UNIT;
                            });
                            return BoxedUnit.UNIT;
                        }
                        growable = divergingEndOffsets$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(topicPartition.partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(partitionData.divergingEpoch().epoch()).setEndOffset(partitionData.divergingEpoch().endOffset())));
                    }
                    catch (Throwable throwable) {
                        if (throwable instanceof CorruptRecordException ? true : throwable instanceof InvalidRecordException) {
                            $this.error((Function0<String>)(Function0 & Serializable)() -> "Found invalid messages during fetch for partition " + topicPartition + " offset " + currentFetchState.fetchOffset(), (Function0<Throwable>)(Function0 & Serializable)() -> throwable);
                            return partitionsWithError$2.$plus$eq((Object)topicPartition);
                        }
                        if (throwable instanceof KafkaStorageException) {
                            KafkaStorageException kafkaStorageException = (KafkaStorageException)throwable;
                            $this.error((Function0<String>)(Function0 & Serializable)() -> "Error while processing data for partition " + topicPartition + " at offset " + currentFetchState.fetchOffset(), (Function0<Throwable>)(Function0 & Serializable)() -> kafkaStorageException);
                            $this.markPartitionFailed(topicPartition);
                            return BoxedUnit.UNIT;
                        }
                        if (throwable != null) {
                            $this.error((Function0<String>)(Function0 & Serializable)() -> "Unexpected error occurred while processing data for partition " + topicPartition + " at offset " + currentFetchState.fetchOffset(), (Function0<Throwable>)(Function0 & Serializable)() -> throwable);
                            $this.markPartitionFailed(topicPartition);
                            return BoxedUnit.UNIT;
                        }
                        throw null;
                    }
                    return growable;
                }
                if (Errors.OFFSET_OUT_OF_RANGE.equals(errors)) {
                    if (!$this.handleOutOfRangeError(topicPartition, (PartitionFetchState)currentFetchState, fetchPartitionData.currentLeaderEpoch)) {
                        return partitionsWithError$2.$plus$eq((Object)topicPartition);
                    }
                    return BoxedUnit.UNIT;
                }
                if (Errors.UNKNOWN_LEADER_EPOCH.equals(errors)) {
                    $this.debug((Function0<String>)(Function0 & Serializable)() -> "Remote broker has a smaller leader epoch for partition " + topicPartition + " than this replica's current leader epoch of " + currentFetchState.currentLeaderEpoch() + ".");
                    return partitionsWithError$2.$plus$eq((Object)topicPartition);
                }
                if (Errors.FENCED_LEADER_EPOCH.equals(errors)) {
                    if ($this.onPartitionFenced(topicPartition, fetchPartitionData.currentLeaderEpoch)) {
                        return partitionsWithError$2.$plus$eq((Object)topicPartition);
                    }
                    return BoxedUnit.UNIT;
                }
                if (Errors.OFFSET_MOVED_TO_TIERED_STORAGE.equals(errors)) {
                    $this.debug((Function0<String>)(Function0 & Serializable)() -> "Received error " + Errors.OFFSET_MOVED_TO_TIERED_STORAGE + ", at fetch offset: " + currentFetchState.fetchOffset() + ", topic-partition: " + topicPartition);
                    if (!$this.handleOffsetsMovedToTieredStorage(topicPartition, (PartitionFetchState)currentFetchState, fetchPartitionData.currentLeaderEpoch, partitionData)) {
                        return partitionsWithError$2.$plus$eq((Object)topicPartition);
                    }
                    return BoxedUnit.UNIT;
                }
                if (Errors.NOT_LEADER_OR_FOLLOWER.equals(errors)) {
                    $this.debug((Function0<String>)(Function0 & Serializable)() -> "Remote broker is not the leader for partition " + topicPartition + ", which could indicate that the partition is being moved");
                    return partitionsWithError$2.$plus$eq((Object)topicPartition);
                }
                if (Errors.UNKNOWN_TOPIC_OR_PARTITION.equals(errors)) {
                    $this.warn((Function0<String>)(Function0 & Serializable)() -> "Received " + Errors.UNKNOWN_TOPIC_OR_PARTITION + " from the leader for partition " + topicPartition + ". This error may be returned transiently when the partition is being created or deleted, but it is not expected to persist.");
                    return partitionsWithError$2.$plus$eq((Object)topicPartition);
                }
                if (Errors.UNKNOWN_TOPIC_ID.equals(errors)) {
                    $this.warn((Function0<String>)(Function0 & Serializable)() -> "Received " + Errors.UNKNOWN_TOPIC_ID + " from the leader for partition " + topicPartition + ". This error may be returned transiently when the partition is being created or deleted, but it is not expected to persist.");
                    return partitionsWithError$2.$plus$eq((Object)topicPartition);
                }
                if (Errors.INCONSISTENT_TOPIC_ID.equals(errors)) {
                    $this.warn((Function0<String>)(Function0 & Serializable)() -> "Received " + Errors.INCONSISTENT_TOPIC_ID + " from the leader for partition " + topicPartition + ". This error may be returned transiently when the partition is being created or deleted, but it is not expected to persist.");
                    return partitionsWithError$2.$plus$eq((Object)topicPartition);
                }
                $this.error((Function0<String>)(Function0 & Serializable)() -> "Error for partition " + topicPartition + " at offset " + currentFetchState.fetchOffset(), (Function0<Throwable>)(Function0 & Serializable)() -> errors.exception());
                return partitionsWithError$2.$plus$eq((Object)topicPartition);
            }
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$processFetchRequest$5(AbstractFetcherThread $this, ObjectRef responseData$1, java.util.Map sessionPartitions$1, scala.collection.mutable.Map divergingEndOffsets$1, scala.collection.mutable.Set partitionsWithError$2) {
        ((Map)responseData$1.elem).foreachEntry((Function2 & Serializable)(topicPartition, partitionData) -> {
            AbstractFetcherThread.$anonfun$processFetchRequest$6(this, sessionPartitions$1, divergingEndOffsets$1, partitionsWithError$2, topicPartition, partitionData);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$markPartitionsForTruncation$1(AbstractFetcherThread $this, long truncationOffset$1, TopicPartition topicPartition$3, PartitionFetchState state) {
        PartitionFetchState newState = new PartitionFetchState(state.topicId(), package$.MODULE$.min(truncationOffset$1, state.fetchOffset()), state.lag(), state.currentLeaderEpoch(), state.delay(), ReplicaState.TRUNCATING, Optional.empty());
        $this.partitionStates().updateAndMoveToEnd(topicPartition$3, (Object)newState);
        $this.partitionMapCond().signalAll();
    }

    public static final /* synthetic */ void $anonfun$addPartitions$1(AbstractFetcherThread $this, TopicPartition tp, InitialFetchState initialFetchState) {
        PartitionFetchState currentState = (PartitionFetchState)$this.partitionStates().stateValue(tp);
        PartitionFetchState updatedState = $this.partitionFetchState(tp, initialFetchState, currentState);
        $this.partitionStates().updateAndMoveToEnd(tp, (Object)updatedState);
    }

    public static final /* synthetic */ void $anonfun$maybeUpdateTopicIds$1(AbstractFetcherThread $this, Function1 topicIds$1, TopicPartition tp) {
        PartitionFetchState currentState = (PartitionFetchState)$this.partitionStates().stateValue(tp);
        if (currentState != null) {
            PartitionFetchState updatedState = currentState.updateTopicId(OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption((Option)topicIds$1.apply((Object)tp.topic()))));
            $this.partitionStates().update(tp, (Object)updatedState);
            return;
        }
    }

    public static final /* synthetic */ OffsetTruncationState $anonfun$getOffsetTruncationState$1(AbstractFetcherThread $this, OffsetForLeaderEpochResponseData.EpochEndOffset leaderEpochOffset$2, TopicPartition tp$5) {
        if (leaderEpochOffset$2.endOffset() == -1L) {
            $this.warn((Function0<String>)(Function0 & Serializable)() -> "Based on replica's leader epoch, leader replied with an unknown offset in " + tp$5 + ". The initial fetch offset " + ((PartitionFetchState)$this.partitionStates().stateValue(tp$5)).fetchOffset() + " will be used for truncation.");
            return new OffsetTruncationState(((PartitionFetchState)$this.partitionStates().stateValue(tp$5)).fetchOffset(), true);
        }
        if (leaderEpochOffset$2.leaderEpoch() == -1) {
            $this.warn((Function0<String>)(Function0 & Serializable)() -> "Leader or replica is on protocol version where leader epoch is not considered in the OffsetsForLeaderEpoch response. The leader's offset " + leaderEpochOffset$2.endOffset() + " will be used for truncation in " + tp$5 + ".");
            return new OffsetTruncationState(package$.MODULE$.min(leaderEpochOffset$2.endOffset(), $this.logEndOffset(tp$5)), true);
        }
        long replicaEndOffset = $this.logEndOffset(tp$5);
        Optional<OffsetAndEpoch> endOffsetForEpochOpt = $this.endOffsetForEpoch(tp$5, leaderEpochOffset$2.leaderEpoch());
        if (endOffsetForEpochOpt.isPresent()) {
            OffsetAndEpoch offsetAndEpoch = endOffsetForEpochOpt.get();
            long followerEndOffset = offsetAndEpoch.offset();
            if (offsetAndEpoch.epoch() != leaderEpochOffset$2.leaderEpoch()) {
                long intermediateOffsetToTruncateTo = package$.MODULE$.min(followerEndOffset, replicaEndOffset);
                $this.info((Function0<String>)(Function0 & Serializable)() -> "Based on replica's leader epoch, leader replied with epoch " + leaderEpochOffset$2.leaderEpoch() + " unknown to the replica for " + tp$5 + ". Will truncate to " + intermediateOffsetToTruncateTo + " and send another leader epoch request to the leader.");
                return new OffsetTruncationState(intermediateOffsetToTruncateTo, false);
            }
            long offsetToTruncateTo = package$.MODULE$.min(followerEndOffset, leaderEpochOffset$2.endOffset());
            return new OffsetTruncationState(package$.MODULE$.min(offsetToTruncateTo, replicaEndOffset), true);
        }
        $this.warn((Function0<String>)(Function0 & Serializable)() -> "Based on replica's leader epoch, leader replied with epoch " + leaderEpochOffset$2.leaderEpoch() + " below any replica's tracked epochs for " + tp$5 + ". The leader's offset only " + leaderEpochOffset$2.endOffset() + " will be used for truncation.");
        return new OffsetTruncationState(package$.MODULE$.min(leaderEpochOffset$2.endOffset(), replicaEndOffset), true);
    }

    public static final /* synthetic */ void $anonfun$delayPartitions$2(AbstractFetcherThread $this, TopicPartition partition$1, long delay$1, PartitionFetchState currentFetchState) {
        if (!currentFetchState.isDelayed()) {
            $this.partitionStates().updateAndMoveToEnd(partition$1, (Object)new PartitionFetchState(currentFetchState.topicId(), currentFetchState.fetchOffset(), currentFetchState.lag(), currentFetchState.currentLeaderEpoch(), Optional.of(Predef$.MODULE$.long2Long(delay$1)), currentFetchState.state(), currentFetchState.lastFetchedEpoch()));
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$delayPartitions$1(AbstractFetcherThread $this, long delay$1, TopicPartition partition) {
        Option$.MODULE$.apply($this.partitionStates().stateValue(partition)).foreach((Function1 & Serializable)currentFetchState -> {
            AbstractFetcherThread.$anonfun$delayPartitions$2($this, partition, delay$1, currentFetchState);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$removePartitions$2(Tuple2 x$3) {
        return x$3._2() != null;
    }

    public static final /* synthetic */ void $anonfun$removeAllPartitions$1(AbstractFetcherThread $this, TopicPartition tp) {
        $this.partitionStates().remove(tp);
        $this.fetcherLagStats().unregister(tp);
    }

    public AbstractFetcherThread(String name, String clientId, LeaderEndPoint leader, FailedPartitions failedPartitions, TierStateMachine fetchTierStateMachine, int fetchBackOffMs, boolean isInterruptible, BrokerTopicStats brokerTopicStats) {
        this.leader = leader;
        this.failedPartitions = failedPartitions;
        this.fetchTierStateMachine = fetchTierStateMachine;
        this.fetchBackOffMs = fetchBackOffMs;
        this.brokerTopicStats = brokerTopicStats;
        super(name, isInterruptible);
        this.logIdent_$eq(this.logPrefix);
        this.partitionStates = new PartitionStates();
        this.partitionMapLock = new ReentrantLock();
        this.partitionMapCond = this.partitionMapLock().newCondition();
        this.metricId = new ClientIdAndBroker(clientId, leader.brokerEndPoint().host(), leader.brokerEndPoint().port());
        this.fetcherStats = new FetcherStats(this.metricId());
        this.fetcherLagStats = new FetcherLagStats(this.metricId());
    }
}

