/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.streams.processor.internals.AbstractPartitionGroup;
import org.apache.kafka.streams.processor.internals.RecordQueue;
import org.apache.kafka.streams.processor.internals.StampedRecord;

class SynchronizedPartitionGroup
extends AbstractPartitionGroup {
    private final AbstractPartitionGroup wrapped;

    public SynchronizedPartitionGroup(AbstractPartitionGroup wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    synchronized AbstractPartitionGroup.ReadyToProcessResult readyToProcess(long wallClockTime) {
        return this.wrapped.readyToProcess(wallClockTime);
    }

    @Override
    synchronized void updatePartitions(Set<TopicPartition> inputPartitions, Function<TopicPartition, RecordQueue> recordQueueCreator) {
        this.wrapped.updatePartitions(inputPartitions, recordQueueCreator);
    }

    @Override
    synchronized void setPartitionTime(TopicPartition partition, long partitionTime) {
        this.wrapped.setPartitionTime(partition, partitionTime);
    }

    @Override
    synchronized StampedRecord nextRecord(AbstractPartitionGroup.RecordInfo info, long wallClockTime) {
        return this.wrapped.nextRecord(info, wallClockTime);
    }

    @Override
    synchronized int addRawRecords(TopicPartition partition, Iterable<ConsumerRecord<byte[], byte[]>> rawRecords) {
        return this.wrapped.addRawRecords(partition, rawRecords);
    }

    @Override
    synchronized long partitionTimestamp(TopicPartition partition) {
        return this.wrapped.partitionTimestamp(partition);
    }

    @Override
    synchronized long streamTime() {
        return this.wrapped.streamTime();
    }

    @Override
    synchronized Long headRecordOffset(TopicPartition partition) {
        return this.wrapped.headRecordOffset(partition);
    }

    @Override
    Optional<Integer> headRecordLeaderEpoch(TopicPartition partition) {
        return Optional.empty();
    }

    @Override
    synchronized int numBuffered() {
        return this.wrapped.numBuffered();
    }

    @Override
    synchronized int numBuffered(TopicPartition tp) {
        return this.wrapped.numBuffered(tp);
    }

    @Override
    synchronized void clear() {
        this.wrapped.clear();
    }

    @Override
    synchronized void updateLags() {
        this.wrapped.updateLags();
    }

    @Override
    synchronized void close() {
        this.wrapped.close();
    }

    @Override
    synchronized Set<TopicPartition> partitions() {
        return this.wrapped.partitions();
    }
}

