/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.errors;

import java.util.Collections;
import java.util.List;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.Configurable;
import org.apache.kafka.streams.errors.ErrorHandlerContext;

public interface ProductionExceptionHandler
extends Configurable {
    @Deprecated
    default public ProductionExceptionHandlerResponse handle(ProducerRecord<byte[], byte[]> record, Exception exception) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    default public ProductionExceptionHandlerResponse handle(ErrorHandlerContext context, ProducerRecord<byte[], byte[]> record, Exception exception) {
        return this.handle(record, exception);
    }

    default public Response handleError(ErrorHandlerContext context, ProducerRecord<byte[], byte[]> record, Exception exception) {
        return new Response(Result.from(this.handle(context, record, exception)), Collections.emptyList());
    }

    @Deprecated
    default public ProductionExceptionHandlerResponse handleSerializationException(ProducerRecord record, Exception exception) {
        return ProductionExceptionHandlerResponse.FAIL;
    }

    @Deprecated
    default public ProductionExceptionHandlerResponse handleSerializationException(ErrorHandlerContext context, ProducerRecord record, Exception exception, SerializationExceptionOrigin origin) {
        return this.handleSerializationException(record, exception);
    }

    default public Response handleSerializationError(ErrorHandlerContext context, ProducerRecord record, Exception exception, SerializationExceptionOrigin origin) {
        return new Response(Result.from(this.handleSerializationException(context, record, exception, origin)), Collections.emptyList());
    }

    @Deprecated
    public static enum ProductionExceptionHandlerResponse {
        CONTINUE(0, "CONTINUE"),
        FAIL(1, "FAIL"),
        RETRY(2, "RETRY");

        public final String name;
        public final int id;

        private ProductionExceptionHandlerResponse(int id, String name) {
            this.id = id;
            this.name = name;
        }
    }

    public static class Response {
        private final Result result;
        private final List<ProducerRecord<byte[], byte[]>> deadLetterQueueRecords;

        private Response(Result result, List<ProducerRecord<byte[], byte[]>> deadLetterQueueRecords) {
            this.result = result;
            this.deadLetterQueueRecords = deadLetterQueueRecords;
        }

        public static Response fail(List<ProducerRecord<byte[], byte[]>> deadLetterQueueRecords) {
            return new Response(Result.FAIL, deadLetterQueueRecords);
        }

        public static Response fail() {
            return Response.fail(Collections.emptyList());
        }

        public static Response resume(List<ProducerRecord<byte[], byte[]>> deadLetterQueueRecords) {
            return new Response(Result.RESUME, deadLetterQueueRecords);
        }

        public static Response resume() {
            return Response.resume(Collections.emptyList());
        }

        public static Response retry() {
            return new Response(Result.RETRY, Collections.emptyList());
        }

        public Result result() {
            return this.result;
        }

        public List<ProducerRecord<byte[], byte[]>> deadLetterQueueRecords() {
            if (this.deadLetterQueueRecords == null) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(this.deadLetterQueueRecords);
        }
    }

    public static enum Result {
        RESUME(0, "RESUME"),
        FAIL(1, "FAIL"),
        RETRY(2, "RETRY");

        public final String name;
        public final int id;

        private Result(int id, String name) {
            this.id = id;
            this.name = name;
        }

        private static Result from(ProductionExceptionHandlerResponse value) {
            switch (value.ordinal()) {
                case 1: {
                    return FAIL;
                }
                case 0: {
                    return RESUME;
                }
                case 2: {
                    return RETRY;
                }
            }
            throw new IllegalArgumentException("No Result enum found for old value: " + String.valueOf((Object)value));
        }
    }

    public static enum SerializationExceptionOrigin {
        KEY,
        VALUE;

    }
}

