/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Implements pixel-wise generic operation of two images, or of an image
and a constant.


This class is parameterized over the types of the two input images and
the type of the output image. It is also parameterized by the
operation to be applied. A Functor style is used.

The constant must be of the same type than the pixel type of the
corresponding image. It is wrapped in a SimpleDataObjectDecorator so it can be updated through the pipeline. The SetConstant() and
GetConstant() methods are provided as shortcuts to set or get the
constant value without manipulating the decorator.


See:
 BinaryGeneratorImagFilter

 UnaryFunctorImageFilter TernaryFunctorImageFilter

 itk::simple::DivideReal for the procedural interface

 itk::BinaryFunctorImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkDivideRealImageFilter.h
*/
public class DivideRealImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected DivideRealImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.DivideRealImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(DivideRealImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(DivideRealImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::DivideRealImageFilter::~DivideRealImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_DivideRealImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::DivideRealImageFilter::DivideRealImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  DivideRealImageFilter() {
    this(SimpleITKJNI.new_DivideRealImageFilter(), true);
  }

  /**
std::string itk::simple::DivideRealImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.DivideRealImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::DivideRealImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.DivideRealImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::DivideRealImageFilter::Execute(Image &amp;&amp;image1, double constant)
*/
public  Image execute(Image image1, Image image2) {
    return new Image(SimpleITKJNI.DivideRealImageFilter_execute__SWIG_0(swigCPtr, this, Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  /**
Image itk::simple::DivideRealImageFilter::Execute(Image &amp;&amp;image1, double constant)
*/
public  Image execute(Image image1, double constant) {
    return new Image(SimpleITKJNI.DivideRealImageFilter_execute__SWIG_1(swigCPtr, this, Image.getCPtr(image1), image1, constant), true);
  }

  /**
Image itk::simple::DivideRealImageFilter::Execute(Image &amp;&amp;image1, double constant)
*/
public  Image execute(double constant, Image image2) {
    return new Image(SimpleITKJNI.DivideRealImageFilter_execute__SWIG_2(swigCPtr, this, constant, Image.getCPtr(image2), image2), true);
  }

}
