﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/iotdeviceadvisor/IoTDeviceAdvisorRequest.h>
#include <aws/iotdeviceadvisor/IoTDeviceAdvisor_EXPORTS.h>

#include <utility>

namespace Aws {
namespace IoTDeviceAdvisor {
namespace Model {

/**
 */
class GetSuiteRunReportRequest : public IoTDeviceAdvisorRequest {
 public:
  AWS_IOTDEVICEADVISOR_API GetSuiteRunReportRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "GetSuiteRunReport"; }

  AWS_IOTDEVICEADVISOR_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>Suite definition ID of the test suite.</p>
   */
  inline const Aws::String& GetSuiteDefinitionId() const { return m_suiteDefinitionId; }
  inline bool SuiteDefinitionIdHasBeenSet() const { return m_suiteDefinitionIdHasBeenSet; }
  template <typename SuiteDefinitionIdT = Aws::String>
  void SetSuiteDefinitionId(SuiteDefinitionIdT&& value) {
    m_suiteDefinitionIdHasBeenSet = true;
    m_suiteDefinitionId = std::forward<SuiteDefinitionIdT>(value);
  }
  template <typename SuiteDefinitionIdT = Aws::String>
  GetSuiteRunReportRequest& WithSuiteDefinitionId(SuiteDefinitionIdT&& value) {
    SetSuiteDefinitionId(std::forward<SuiteDefinitionIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Suite run ID of the test suite run.</p>
   */
  inline const Aws::String& GetSuiteRunId() const { return m_suiteRunId; }
  inline bool SuiteRunIdHasBeenSet() const { return m_suiteRunIdHasBeenSet; }
  template <typename SuiteRunIdT = Aws::String>
  void SetSuiteRunId(SuiteRunIdT&& value) {
    m_suiteRunIdHasBeenSet = true;
    m_suiteRunId = std::forward<SuiteRunIdT>(value);
  }
  template <typename SuiteRunIdT = Aws::String>
  GetSuiteRunReportRequest& WithSuiteRunId(SuiteRunIdT&& value) {
    SetSuiteRunId(std::forward<SuiteRunIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_suiteDefinitionId;

  Aws::String m_suiteRunId;
  bool m_suiteDefinitionIdHasBeenSet = false;
  bool m_suiteRunIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace IoTDeviceAdvisor
}  // namespace Aws
