/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.editor.annotation;

import java.util.HashMap;
import java.util.Map;
import org.apache.uima.caseditor.editor.AnnotationStyle;
import org.apache.uima.caseditor.editor.annotation.BackgroundDrawingStrategy;
import org.apache.uima.caseditor.editor.annotation.BoxDrawingStrategy;
import org.apache.uima.caseditor.editor.annotation.BracketDrawingStrategy;
import org.apache.uima.caseditor.editor.annotation.TagDrawingStrategy;
import org.apache.uima.caseditor.editor.annotation.TextColorDrawingStrategy;
import org.apache.uima.caseditor.editor.annotation.TokenDrawingStrategy;
import org.apache.uima.caseditor.editor.annotation.UnderlineDrawingStrategy;
import org.eclipse.jface.text.source.AnnotationPainter;

public class DrawingStyle {
    private static Map<AnnotationStyle.Style, AnnotationPainter.IDrawingStrategy> statelessStyles = new HashMap<AnnotationStyle.Style, AnnotationPainter.IDrawingStrategy>();

    private DrawingStyle() {
    }

    public static AnnotationPainter.IDrawingStrategy createStrategy(AnnotationStyle style) {
        AnnotationPainter.IDrawingStrategy strategy = statelessStyles.get((Object)style.getStyle());
        if (strategy == null && AnnotationStyle.Style.TAG.equals((Object)style.getStyle()) && style.getConfiguration() != null) {
            strategy = new TagDrawingStrategy(style.getConfiguration());
        }
        return strategy;
    }

    static {
        statelessStyles.put(AnnotationStyle.Style.BACKGROUND, new BackgroundDrawingStrategy());
        statelessStyles.put(AnnotationStyle.Style.TEXT_COLOR, new TextColorDrawingStrategy());
        statelessStyles.put(AnnotationStyle.Style.TOKEN, new TokenDrawingStrategy());
        statelessStyles.put(AnnotationStyle.Style.SQUIGGLES, (AnnotationPainter.IDrawingStrategy)new AnnotationPainter.SquigglesStrategy());
        statelessStyles.put(AnnotationStyle.Style.BOX, new BoxDrawingStrategy());
        statelessStyles.put(AnnotationStyle.Style.UNDERLINE, new UnderlineDrawingStrategy());
        statelessStyles.put(AnnotationStyle.Style.BRACKET, new BracketDrawingStrategy());
    }
}

