/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.dde.internal.hover;

import java.util.Map;
import java.util.Set;
import org.apache.uima.aae.deployment.AEDeploymentDescription;
import org.apache.uima.aae.deployment.AEDeploymentMetaData;
import org.apache.uima.aae.deployment.AsyncAEErrorConfiguration;
import org.apache.uima.aae.deployment.AsyncAggregateErrorConfiguration;
import org.apache.uima.aae.deployment.CollectionProcessCompleteErrors;
import org.apache.uima.aae.deployment.GetMetadataErrors;
import org.apache.uima.aae.deployment.ProcessCasErrors;
import org.apache.uima.aae.deployment.RemoteAEDeploymentMetaData;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.dde.internal.hover.KeyValuePair;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.widgets.FormText;

public class DDEInformationControl
extends PopupDialog
implements IInformationControl,
IInformationControlExtension2 {
    private Font boldTextFont;
    private static final int INNER_BORDER = 1;
    private FormText formText;
    private FormColors formColors;

    public DDEInformationControl(Shell parent, int shellStyle, int treeStyle) {
        this(parent, shellStyle, treeStyle, null, false);
    }

    public DDEInformationControl(Shell parent, int shellStyle, int treeStyle, String invokingCommandId, boolean showStatusField) {
        super(parent, shellStyle | 0x80000 | 0x4000, false, false, false, false, null, null);
        this.create();
        this.boldTextFont = DDEInformationControl.createBoldFont(this.getShell().getDisplay(), JFaceResources.getTextFont());
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.open();
        } else {
            this.saveDialogBounds(this.getShell());
            this.getShell().setVisible(false);
        }
    }

    public void addDisposeListener(DisposeListener listener) {
    }

    public void addFocusListener(FocusListener listener) {
    }

    public Point computeSizeHint() {
        int widthHint = 400;
        if (this.getShell() != null) {
            Point pt = this.getShell().computeSize(widthHint, -1, true);
            return pt;
        }
        return new Point(200, 100);
    }

    public void dispose() {
        if (this.boldTextFont != null) {
            this.boldTextFont.dispose();
        }
    }

    public boolean isFocusControl() {
        return false;
    }

    public void removeDisposeListener(DisposeListener listener) {
    }

    public void removeFocusListener(FocusListener listener) {
    }

    public void setBackgroundColor(Color background) {
    }

    public void setFocus() {
    }

    public void setForegroundColor(Color foreground) {
    }

    public void setInformation(String information) {
        this.formText.setText(information, true, false);
    }

    public void setLocation(Point location) {
        this.getShell().setLocation(location);
    }

    public void setSize(int width, int height) {
        this.getShell().setSize(width, height);
    }

    public void setSizeConstraints(int maxWidth, int maxHeight) {
    }

    public void setInput(Object input) {
        StringBuffer buf = new StringBuffer();
        if (input != null) {
            if (input instanceof String) {
                this.formText.setColor("header", this.formColors.getColor("org.eclipse.ui.forms.TITLE"));
                this.formText.setFont("header", JFaceResources.getFontRegistry().get("org.eclipse.jface.windowfont"));
                this.formText.setFont("code", JFaceResources.getTextFont());
                this.formText.setText(buf.toString(), true, false);
            } else if (input instanceof TreeItem && ((TreeItem)input).getData() != null) {
                Object obj = ((TreeItem)input).getData();
                String text = null;
                if (obj instanceof AEDeploymentMetaData) {
                    text = this.toStringFromAEDeploymentMetaData((AEDeploymentMetaData)obj);
                } else if (obj instanceof RemoteAEDeploymentMetaData) {
                    text = this.toStringFromRemoteAEDeploymentMetaData((RemoteAEDeploymentMetaData)obj);
                } else if (obj instanceof AEDeploymentDescription) {
                    text = this.toStringFromAEDeploymentDescription((AEDeploymentDescription)obj);
                } else if (obj instanceof KeyValuePair) {
                    AEDeploymentDescription dd = (AEDeploymentDescription)((KeyValuePair)obj).getValue();
                    text = this.toStringFromAEDeploymentDescription(dd);
                }
                if (text != null) {
                    this.formText.setColor("header", this.formColors.getColor("org.eclipse.ui.forms.TITLE"));
                    this.formText.setFont("header", this.boldTextFont);
                    this.formText.setText(text, true, false);
                }
            }
        }
    }

    protected String toStringFromAEDeploymentDescription(AEDeploymentDescription obj) {
        StringBuffer buf = new StringBuffer();
        buf.append("<form><p><span color=\"header\" font=\"header\">");
        buf.append(obj.getName() + "</span>");
        buf.append("</p>");
        if (obj.getDescription().trim().length() > 0) {
            buf.append("<p>" + obj.getDescription());
            buf.append("</p>");
        }
        buf.append("</form>");
        return buf.toString();
    }

    protected String toStringFromAEDeploymentMetaData(AEDeploymentMetaData obj) {
        AnalysisEngineDescription aed;
        StringBuffer buf = new StringBuffer();
        buf.append("<form><p><span color=\"header\" font=\"header\">");
        buf.append(obj.getKey() + "</span>");
        if (obj.isAsync()) {
            buf.append(" - Async Aggregate");
        }
        buf.append("</p>");
        if (obj.isAsync() && obj.getResourceSpecifier() instanceof AnalysisEngineDescription && !(aed = (AnalysisEngineDescription)obj.getResourceSpecifier()).isPrimitive()) {
            buf.append("<p><b>Delegates</b>\n");
            Map map = aed.getDelegateAnalysisEngineSpecifiersWithImports();
            Set keys = map.keySet();
            for (String key : keys) {
                buf.append(" - " + key);
            }
            buf.append("</p>");
        }
        if (!obj.isTopAnalysisEngine()) {
            buf.append("<p>Number of Replicated Instances: " + obj.getNumberOfInstances());
            buf.append("</p>");
        }
        if (obj.isCasMultiplier()) {
            buf.append("<p>CasMultiplierPoolSize: " + obj.getCasMultiplierPoolSize());
            buf.append("</p>");
        }
        this.toStringFromErrorConfig(buf, obj.getAsyncAEErrorConfiguration());
        buf.append("</form>");
        return buf.toString();
    }

    protected String toStringFromRemoteAEDeploymentMetaData(RemoteAEDeploymentMetaData obj) {
        StringBuffer buf = new StringBuffer();
        buf.append("<form><p><span color=\"header\" font=\"header\">");
        buf.append(obj.getKey() + "</span> - Remote Service</p>");
        buf.append("<li><b>Broker URL:</b> " + (obj.getInputQueue() != null ? obj.getInputQueue().getBrokerURL() : "") + "</li>");
        buf.append("<li><b>Queue Name:</b> " + (obj.getInputQueue() != null ? obj.getInputQueue().getEndPoint() : "") + "</li>");
        if (obj.getRemoteReplyQueueScaleout() > 0) {
            buf.append("<li><b>Concurrent Consumers for reply queue:</b> " + obj.getRemoteReplyQueueScaleout() + "</li>");
        }
        this.toStringFromErrorConfig(buf, obj.getAsyncAEErrorConfiguration());
        buf.append("</form>");
        return buf.toString();
    }

    protected void toStringFromErrorConfig(StringBuffer buf, AsyncAEErrorConfiguration obj) {
        CollectionProcessCompleteErrors collProcessCompleteErrors;
        ProcessCasErrors processCasErrors;
        if (obj == null) {
            return;
        }
        boolean isAsyncAggErrorConfig = obj instanceof AsyncAggregateErrorConfiguration;
        GetMetadataErrors getGetMetadataErrors = obj.getGetMetadataErrors();
        if (getGetMetadataErrors != null) {
            buf.append("<li><b>GetMetadataErrors</b></li>");
            buf.append("<li bindent=\"20\">MaxRetries: " + getGetMetadataErrors.getMaxRetries() + " ; Timeout: " + getGetMetadataErrors.getTimeout() + " ; ErrorAction: " + getGetMetadataErrors.getErrorAction() + "</li>");
        }
        if ((processCasErrors = obj.getProcessCasErrors()) != null) {
            buf.append("<li><b>ProcessCasErrors</b></li>");
            if (isAsyncAggErrorConfig) {
                buf.append("<li bindent=\"20\">CAS Max Retries: " + processCasErrors.getMaxRetries() + " ; CAS Timeout: " + processCasErrors.getTimeout() + " ; CAS Continue On Failure: " + processCasErrors.isContinueOnRetryFailure() + "</li>");
                buf.append("<li bindent=\"20\">Delegate Threshold Count: " + processCasErrors.getThresholdCount() + " ; Delegate Threshold Window: " + processCasErrors.getThresholdWindow() + " ; Delegate Threshold Action: " + processCasErrors.getThresholdAction() + "</li>");
            } else {
                buf.append("<li bindent=\"20\">Threshold Count: " + processCasErrors.getThresholdCount() + " ; Threshold Window: " + processCasErrors.getThresholdWindow() + " ; Threshold Action: " + processCasErrors.getThresholdAction() + "</li>");
            }
        }
        if ((collProcessCompleteErrors = obj.getCollectionProcessCompleteErrors()) != null) {
            buf.append("<li><b>CollectionProcessCompleteErrors</b></li>");
            buf.append("<li bindent=\"20\">Timeout: " + collProcessCompleteErrors.getTimeout() + " ; Additional Error Action: " + collProcessCompleteErrors.getAdditionalErrorAction() + "</li>");
        }
    }

    public static Font createBoldFont(Display display, Font regularFont) {
        FontData[] fontDatas = regularFont.getFontData();
        for (int i = 0; i < fontDatas.length; ++i) {
            fontDatas[i].setStyle(fontDatas[i].getStyle() | 1);
        }
        return new Font((Device)display, fontDatas);
    }

    protected Control createDialogArea(Composite parent) {
        this.formColors = new FormColors(parent.getDisplay());
        parent.setLayout((Layout)new GridLayout());
        this.formText = new FormText(parent, 10);
        GridData gd = new GridData(1809);
        gd.horizontalIndent = 1;
        gd.verticalIndent = 1;
        this.formText.setLayoutData((Object)gd);
        this.formText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u001b') {
                    DDEInformationControl.this.close();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        return this.formText;
    }
}

