/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.textruler.core;

import java.util.ArrayList;
import java.util.List;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.cas.CAS;
import org.apache.uima.ruta.textruler.TextRulerPlugin;
import org.apache.uima.ruta.textruler.core.TextRulerToolkit;

public class GlobalCASSource {
    public static int CAS = 0;
    private static List<CAS> free = new ArrayList<CAS>();
    private static List<CAS> inUsage = new ArrayList<CAS>();

    public static synchronized CAS allocCAS(AnalysisEngine ae) {
        if (free.size() > 0) {
            CAS result = free.get(free.size() - 1);
            free.remove(free.size() - 1);
            inUsage.add(result);
            return result;
        }
        try {
            CAS newCas = ae.newCAS();
            System.out.println("####### CAS: " + ++CAS);
            inUsage.add(newCas);
            return newCas;
        }
        catch (Exception e) {
            TextRulerPlugin.error(e);
            return null;
        }
    }

    public static synchronized void releaseCAS(CAS cas) {
        if (inUsage.contains(cas)) {
            cas.reset();
            inUsage.remove(cas);
            free.add(cas);
        } else if (free.contains(cas)) {
            cas.reset();
        } else {
            cas.release();
            TextRulerToolkit.log("[GlobalCASSource.release] Error, tried to release an unknown CAS object!");
        }
    }

    public static void clear() {
        for (CAS each : free) {
            each.release();
            each = null;
        }
        free.clear();
        for (CAS each : inUsage) {
            each.release();
            Object var1_1 = null;
        }
        inUsage.clear();
        CAS = 0;
    }
}

