/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.ui.text;

import org.eclipse.core.resources.IFile;
import org.eclipse.dltk.internal.ui.editor.DLTKEditorMessages;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public class ExternalTypeHyperlink
implements IHyperlink {
    private final IRegion region;
    private final IFile file;
    private final String nodeText;
    private final String tsString;
    private final ITextEditor textEditor;

    public ExternalTypeHyperlink(String nodeText, IRegion region, IFile file, String tsString, ITextEditor textEditor) {
        this.nodeText = nodeText;
        this.region = region;
        this.file = file;
        this.tsString = tsString;
        this.textEditor = textEditor;
    }

    public IRegion getHyperlinkRegion() {
        return this.region;
    }

    public String getHyperlinkText() {
        return this.nodeText + " in " + this.tsString;
    }

    public String getTypeLabel() {
        return DLTKEditorMessages.ModelElementHyperlink_typeLabel;
    }

    public void open() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            page.openEditor((IEditorInput)new FileEditorInput(this.file), "taeconfigurator.editors.MultiPageEditor");
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }
}

