/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.check;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.uima.UIMAFramework;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.impl.XmiCasDeserializer;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.caseditor.ide.TypeSystemLocationPropertyPage;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.metadata.FsIndexDescription;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.ruta.addons.RutaAddonsPlugin;
import org.apache.uima.ruta.check.AnnotationCheckComposite;
import org.apache.uima.ruta.check.AnnotationCheckRootNode;
import org.apache.uima.ruta.check.AnnotationCheckTreeNode;
import org.apache.uima.ruta.check.AnnotationCheckView;
import org.apache.uima.ruta.check.CheckAnnotation;
import org.apache.uima.ruta.check.CheckAnnotationUtils;
import org.apache.uima.ruta.check.CheckDocument;
import org.apache.uima.ruta.check.CheckElement;
import org.apache.uima.ruta.check.IAnnotationCheckTreeNode;
import org.apache.uima.ruta.check.XMLUtils;
import org.apache.uima.util.CasCreationUtils;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.handlers.HandlerUtil;
import org.xml.sax.SAXException;

public class UpdateTaskHandler
implements IHandler {
    public void addHandlerListener(IHandlerListener arg0) {
    }

    public void dispose() {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            AnnotationCheckView acView = (AnnotationCheckView)HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.apache.uima.ruta.check");
            AnnotationCheckComposite composite = acView.getComposite();
            TreeSelection selection = (TreeSelection)composite.getTreeViewer().getSelection();
            AnnotationCheckTreeNode previousSelection = (AnnotationCheckTreeNode)selection.getFirstElement();
            CheckAnnotationUpdateTaskJob job = new CheckAnnotationUpdateTaskJob(composite, previousSelection);
            job.schedule();
        }
        catch (Exception e) {
            RutaAddonsPlugin.error(e);
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isHandled() {
        return true;
    }

    public void removeHandlerListener(IHandlerListener arg0) {
    }

    private class CheckAnnotationUpdateTaskJob
    extends Job {
        private String documentSource;
        private String typeSystem;
        private AnnotationCheckComposite composite;
        private String documentSink;
        private AnnotationCheckTreeNode previousSelection;

        CheckAnnotationUpdateTaskJob(String documentSource, String documentSink, String typeSystem, AnnotationCheckComposite composite, AnnotationCheckTreeNode previousSelection) {
            super("Update annotation check task...");
            this.documentSource = documentSource;
            this.documentSink = documentSink;
            this.typeSystem = typeSystem;
            this.composite = composite;
            this.previousSelection = previousSelection;
        }

        CheckAnnotationUpdateTaskJob(AnnotationCheckComposite composite, AnnotationCheckTreeNode previousSelection) {
            this(composite.getDocumentSource(), composite.getDocumentSink(), composite.getTypeSystem(), composite, previousSelection);
        }

        public IStatus run(IProgressMonitor monitor) {
            CheckElement element;
            TreePath oldPath;
            List<String> selectedTypes = this.composite.getSelectedTypes();
            File dir = new File(this.documentSource);
            File[] listFiles = dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File file, String string) {
                    return string.endsWith(".xmi");
                }
            });
            if (listFiles == null) {
                return Status.CANCEL_STATUS;
            }
            File dataFile = new File(this.documentSink, "data.xml");
            ArrayList<CheckDocument> docs = new ArrayList();
            try {
                docs = XMLUtils.read(dataFile);
            }
            catch (SAXException e) {
                RutaAddonsPlugin.error(e);
            }
            catch (IOException e) {
                RutaAddonsPlugin.error(e);
            }
            this.setDefaultTypeSystem(this.documentSource, this.typeSystem);
            TypeSystemDescription tsd = null;
            try {
                tsd = UIMAFramework.getXMLParser().parseTypeSystemDescription(new XMLInputSource(this.typeSystem));
                tsd.resolveImports();
            }
            catch (InvalidXMLException e) {
                RutaAddonsPlugin.error(e);
            }
            catch (IOException e) {
                RutaAddonsPlugin.error(e);
            }
            CAS cas = null;
            try {
                cas = CasCreationUtils.createCas((TypeSystemDescription)tsd, null, (FsIndexDescription[])new FsIndexDescription[0]);
            }
            catch (ResourceInitializationException e) {
                RutaAddonsPlugin.error(e);
            }
            if (tsd == null || cas == null) {
                return Status.CANCEL_STATUS;
            }
            TreePath treePath = null;
            final AnnotationCheckRootNode root = new AnnotationCheckRootNode();
            for (File file : listFiles) {
                cas.reset();
                try {
                    XmiCasDeserializer.deserialize((InputStream)new FileInputStream(file), (CAS)cas, (boolean)true);
                }
                catch (FileNotFoundException e) {
                    RutaAddonsPlugin.error(e);
                }
                catch (SAXException e) {
                    RutaAddonsPlugin.error(e);
                }
                catch (IOException e) {
                    RutaAddonsPlugin.error(e);
                }
                CheckDocument element2 = this.getCheckDocument(docs, file.getAbsolutePath());
                boolean documentAlreadyDone = this.documentAlreadyDoneforTypes(element2, selectedTypes);
                if (documentAlreadyDone) continue;
                AnnotationCheckTreeNode node = new AnnotationCheckTreeNode(root, element2);
                root.addChild(node);
                AnnotationIndex annotationIndex = cas.getAnnotationIndex();
                for (AnnotationFS each : annotationIndex) {
                    boolean annotationAlreadyDoneforTypes = this.annotationAlreadyDoneforTypes(each, selectedTypes, element2.checkedTypes);
                    if (annotationAlreadyDoneforTypes) continue;
                    CheckAnnotation ac = new CheckAnnotation(each);
                    AnnotationCheckTreeNode anode = new AnnotationCheckTreeNode(node, ac);
                    if (treePath == null) {
                        treePath = new TreePath(new Object[]{root, node, anode});
                    }
                    node.addChild(anode);
                }
                if (treePath != null) continue;
                treePath = new TreePath(new Object[]{root, node});
            }
            if (this.previousSelection != null && (oldPath = this.getPathTo(element = this.previousSelection.getElement(), root)) != null) {
                treePath = oldPath;
            }
            final TreeSelection firstSelection = new TreeSelection(treePath);
            cas.release();
            this.composite.setOldDocs(docs);
            this.composite.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    TreeViewer treeView = CheckAnnotationUpdateTaskJob.this.composite.getTreeViewer();
                    treeView.setInput((Object)root);
                    treeView.setSelection((ISelection)firstSelection, true);
                }
            });
            return Status.OK_STATUS;
        }

        private TreePath getPathTo(CheckElement element, IAnnotationCheckTreeNode root) {
            AnnotationCheckTreeNode[] children;
            for (AnnotationCheckTreeNode eachDocNode : children = root.getChildren()) {
                if (element instanceof CheckAnnotation) {
                    AnnotationCheckTreeNode[] children2;
                    for (AnnotationCheckTreeNode eachANode : children2 = eachDocNode.getChildren()) {
                        if (!this.isSameElement(eachANode.getElement(), element)) continue;
                        return new TreePath(new Object[]{root, eachDocNode, eachANode});
                    }
                    continue;
                }
                if (!this.isSameElement(eachDocNode.getElement(), element)) continue;
                return new TreePath(new Object[]{root, eachDocNode});
            }
            return null;
        }

        private boolean isSameElement(CheckElement e1, CheckElement e2) {
            if (e1 == null || e2 == null) {
                return false;
            }
            if (e1 instanceof CheckAnnotation && e2 instanceof CheckAnnotation) {
                CheckAnnotation ca1 = (CheckAnnotation)e1;
                CheckAnnotation ca2 = (CheckAnnotation)e2;
                return ca1.begin == ca2.begin && ca1.end == ca2.end && ca1.type.equals(ca2.type);
            }
            if (e1 instanceof CheckDocument && e2 instanceof CheckDocument) {
                CheckDocument cd1 = (CheckDocument)e1;
                CheckDocument cd2 = (CheckDocument)e2;
                return cd1.source.equals(cd2.source);
            }
            return false;
        }

        private boolean documentAlreadyDoneforTypes(CheckDocument element, List<String> selectedTypes) {
            if (element.checkedTypes.isEmpty() && !selectedTypes.isEmpty()) {
                return false;
            }
            boolean allCovered = true;
            for (String each : selectedTypes) {
                allCovered &= element.checkedTypes.contains(each);
            }
            return allCovered;
        }

        private boolean annotationAlreadyDoneforTypes(AnnotationFS each, Collection<String> selectedTypes, Collection<String> alreadyDone) {
            String name = each.getType().getName();
            if (alreadyDone.contains(name)) {
                return true;
            }
            return !selectedTypes.contains(name);
        }

        private CheckDocument getCheckDocument(List<CheckDocument> docs, String absolutePath) {
            for (CheckDocument checkDocument : docs) {
                if (!checkDocument.source.equals(absolutePath)) continue;
                return checkDocument;
            }
            return new CheckDocument(absolutePath);
        }

        public void setDefaultTypeSystem(String documentSource, String typeSystemLocation) {
            IFile dsFile = CheckAnnotationUtils.getIFile(documentSource);
            IFile tsFile = CheckAnnotationUtils.getIFile(typeSystemLocation);
            IProject project = dsFile.getProject();
            String portableString = tsFile.getFullPath().toPortableString();
            TypeSystemLocationPropertyPage.setTypeSystemLocation((IProject)project, (String)portableString);
        }
    }
}

