/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.validator;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.uima.ruta.ide.parser.ast.RutaAction;
import org.apache.uima.ruta.ide.parser.ast.RutaImportStatement;
import org.apache.uima.ruta.ide.validator.RutaCheckerProblemFactory;
import org.apache.uima.ruta.ide.validator.RutaCheckerUtils;
import org.apache.uima.util.InvalidXMLException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.builder.IBuildContext;
import org.eclipse.dltk.core.builder.IBuildParticipant;
import org.eclipse.dltk.core.builder.IBuildParticipantExtension;
import org.eclipse.dltk.core.builder.ISourceLineTracker;

public class RutaEngineAndCallChecker
implements IBuildParticipant,
IBuildParticipantExtension {
    private IScriptProject project;

    public RutaEngineAndCallChecker(IScriptProject project) throws CoreException {
        this.project = project;
    }

    public boolean beginBuild(int buildType) {
        return true;
    }

    public void endBuild(IProgressMonitor monitor) {
    }

    public void build(IBuildContext context) throws CoreException {
        Object mdObj = context.get(IBuildContext.ATTR_MODULE_DECLARATION);
        if (!(mdObj instanceof ModuleDeclaration)) {
            return;
        }
        ModuleDeclaration md = (ModuleDeclaration)mdObj;
        IProblemReporter problemReporter = context.getProblemReporter();
        ISourceModule smod = context.getSourceModule();
        ISourceLineTracker linetracker = context.getLineTracker();
        String fileName = smod.getElementName();
        try {
            EngineAndCallCheckerVisitor visitor = new EngineAndCallCheckerVisitor(problemReporter, linetracker, fileName);
            md.traverse((ASTVisitor)visitor);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class EngineAndCallCheckerVisitor
    extends ASTVisitor {
        private IProblemReporter rep;
        private RutaCheckerProblemFactory problemFactory;
        private Set<String> engines;
        private Set<String> scripts;
        private String curFile;
        private HashSet<String> scriptsInnerBlocks;

        public EngineAndCallCheckerVisitor(IProblemReporter rep, ISourceLineTracker linetracker, String curFile) {
            this.problemFactory = new RutaCheckerProblemFactory(curFile, linetracker);
            this.rep = rep;
            this.engines = new HashSet<String>();
            this.scripts = new HashSet<String>();
            this.scriptsInnerBlocks = new HashSet();
            this.curFile = curFile;
            if (curFile != null && curFile.endsWith(".ruta")) {
                this.scripts.add(curFile.substring(0, curFile.length() - 5));
            }
            try {
                String fnwe = curFile.substring(0, curFile.length() - 5);
                this.scriptsInnerBlocks.addAll(RutaCheckerUtils.importScript(fnwe, 9, RutaEngineAndCallChecker.this.project));
            }
            catch (InvalidXMLException e) {
            }
            catch (IOException e) {
            }
            catch (ModelException e) {
                // empty catch block
            }
        }

        public boolean visit(Statement s) throws Exception {
            if (s instanceof RutaImportStatement) {
                if (((RutaImportStatement)s).getType() == 9) {
                    SimpleReference sRef = (SimpleReference)((RutaImportStatement)s).getExpression();
                    if (RutaCheckerUtils.checkEngineImport(sRef.getName(), RutaEngineAndCallChecker.this.project)) {
                        this.importEngine(sRef.getName());
                    } else {
                        IProblem problem = this.problemFactory.createFileNotFoundProblem((ASTNode)sRef);
                        this.rep.reportProblem(problem);
                    }
                }
                if (((RutaImportStatement)s).getType() == 5) {
                    SimpleReference stRef = (SimpleReference)((RutaImportStatement)s).getExpression();
                    String sRefName = stRef.getName();
                    try {
                        Set<String> blocks = RutaCheckerUtils.importScript(sRefName, 9, RutaEngineAndCallChecker.this.project);
                        this.scripts.add(sRefName);
                        if (!blocks.isEmpty()) {
                            this.scriptsInnerBlocks.addAll(blocks);
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                return false;
            }
            return true;
        }

        private void importEngine(String name) {
            String lastPart;
            this.engines.add(name);
            int i = name.lastIndexOf(46);
            if (i > 1 && (lastPart = name.substring(i + 1)) != null && lastPart.length() != 0) {
                this.engines.add(lastPart);
            }
        }

        public boolean visit(Expression s) throws Exception {
            if (s instanceof RutaAction) {
                RutaAction action = (RutaAction)s;
                if (action.getKind() == 10047) {
                    SimpleReference ref;
                    if (action.getChilds().size() > 0 && (ref = (SimpleReference)action.getChilds().get(0)) != null && !this.engines.contains(ref.getName())) {
                        String required = ref.getName();
                        for (String script : this.scripts) {
                            boolean a = script.endsWith(required);
                            if (!a) continue;
                            return false;
                        }
                        for (String block : this.scriptsInnerBlocks) {
                            boolean b = block.equals(required);
                            if (!b) continue;
                            return false;
                        }
                        IProblem problem = this.problemFactory.createFileNotFoundProblem((ASTNode)ref);
                        this.rep.reportProblem(problem);
                    }
                    return false;
                }
                return true;
            }
            return true;
        }

        public boolean visit(MethodDeclaration s) throws Exception {
            return true;
        }

        public boolean visit(TypeDeclaration s) throws Exception {
            return false;
        }
    }
}

