/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.launching;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.impl.XmiCasDeserializer;
import org.apache.uima.cas.impl.XmiCasSerializer;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.ruta.engine.Ruta;
import org.apache.uima.util.FileUtils;
import org.apache.uima.util.ProcessTrace;
import org.apache.uima.util.XMLSerializer;
import org.apache.uima.util.impl.ProcessTrace_impl;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RutaLauncher {
    private static File descriptor;
    private static File inputFolder;
    private static File outputFolder;
    private static boolean inputRecursive;
    private static String inputEncoding;
    private static String launchMode;
    private static String view;

    private static boolean parseCmdLineArgs(String[] args) {
        int index = 0;
        int count = 0;
        while (index < args.length) {
            String each;
            if ("-inputFolder".equals(each = args[index++])) {
                if (index >= args.length) {
                    return false;
                }
                ++count;
                inputFolder = new File(args[index++]);
                continue;
            }
            if ("-outputFolder".equals(each)) {
                if (index >= args.length) {
                    return false;
                }
                outputFolder = new File(args[index++]);
                continue;
            }
            if ("-descriptor".equals(each)) {
                if (index >= args.length) {
                    return false;
                }
                ++count;
                descriptor = new File(args[index++]);
                continue;
            }
            if ("-inputRecursive".equals(each)) {
                if (index >= args.length) {
                    return false;
                }
                inputRecursive = Boolean.parseBoolean(args[index++]);
                continue;
            }
            if ("-inputRecursive".equals(each)) {
                if (index >= args.length) {
                    return false;
                }
                inputEncoding = args[index++];
                continue;
            }
            if ("-mode".equals(each)) {
                if (index >= args.length) {
                    return false;
                }
                launchMode = args[index++];
                continue;
            }
            if (!"-view".equals(each)) continue;
            if (index >= args.length) {
                return false;
            }
            view = args[index++];
        }
        return count == 2;
    }

    public static void main(String[] args) throws Exception {
        if (!RutaLauncher.parseCmdLineArgs(args)) {
            throw new IllegalArgumentException("Passed arguments are invalid!");
        }
        AnalysisEngine ae = Ruta.wrapAnalysisEngine((URL)descriptor.toURL(), (String)view, (boolean)true, (String)inputEncoding);
        RutaLauncher.configure(ae);
        CAS cas = ae.newCAS();
        List<File> inputFiles = RutaLauncher.getFiles(inputFolder, inputRecursive);
        for (File file : inputFiles) {
            RutaLauncher.processFile(file, ae, cas);
        }
        ae.collectionProcessComplete((ProcessTrace)new ProcessTrace_impl());
        cas.release();
        ae.destroy();
    }

    private static void processFile(File file, AnalysisEngine ae, CAS cas) throws IOException, AnalysisEngineProcessException, SAXException {
        if (view != null) {
            boolean found = false;
            Iterator viewIterator = cas.getViewIterator();
            while (viewIterator.hasNext()) {
                CAS each = (CAS)viewIterator.next();
                String viewName = each.getViewName();
                if (!viewName.equals(view)) continue;
                cas = cas.getView(view);
                found = true;
                break;
            }
            if (!found) {
                cas = cas.createView(view);
            }
        }
        if (file.getName().endsWith(".xmi")) {
            XmiCasDeserializer.deserialize((InputStream)new FileInputStream(file), (CAS)cas, (boolean)true);
        } else {
            String document = FileUtils.file2String((File)file, (String)inputEncoding);
            cas.setDocumentText(document);
        }
        ae.process(cas);
        if (outputFolder != null) {
            File outputFile = RutaLauncher.getOutputFile(file, inputFolder, outputFolder);
            RutaLauncher.writeXmi(cas, outputFile);
        }
        cas.reset();
    }

    private static void configure(AnalysisEngine ae) throws ResourceConfigurationException {
        if ("debug".equals(launchMode)) {
            ae.setConfigParameterValue("debug", (Object)true);
            ae.setConfigParameterValue("debugWithMatches", (Object)true);
            ae.setConfigParameterValue("profile", (Object)true);
            ae.setConfigParameterValue("statistics", (Object)true);
            ae.setConfigParameterValue("createdBy", (Object)true);
        }
        ae.reconfigure();
    }

    private static List<File> getFiles(File dir, boolean recusive) {
        ArrayList<File> result = new ArrayList<File>();
        for (File each : dir.listFiles()) {
            if (each.isHidden()) continue;
            if (each.isFile()) {
                result.add(each);
                continue;
            }
            if (!each.isDirectory() || !recusive) continue;
            result.addAll(RutaLauncher.getFiles(each, recusive));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeXmi(CAS cas, File file) throws IOException, SAXException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            XmiCasSerializer ser = new XmiCasSerializer(cas.getTypeSystem());
            XMLSerializer xmlSer = new XMLSerializer((OutputStream)out, false);
            ser.serialize(cas, xmlSer.getContentHandler());
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private static File getOutputFile(File inputFile, File inputFolder, File outputFolder) {
        URI relativize = inputFolder.toURI().relativize(inputFile.toURI());
        String path = relativize.getPath();
        if (!path.endsWith(".xmi")) {
            path = path + ".xmi";
        }
        File result = new File(outputFolder, path);
        result.getParentFile().mkdirs();
        return result;
    }

    static {
        outputFolder = null;
        inputRecursive = false;
        inputEncoding = Charset.defaultCharset().name();
        launchMode = "run";
        view = null;
    }
}

