/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.rule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.uima.cas.ConstraintFactory;
import org.apache.uima.cas.FSMatchConstraint;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaBlock;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.constraint.BasicTypeConstraint;
import org.apache.uima.ruta.expression.RutaExpression;
import org.apache.uima.ruta.expression.type.TypeExpression;
import org.apache.uima.ruta.rule.AnnotationComparator;
import org.apache.uima.ruta.rule.RutaMatcher;
import org.apache.uima.ruta.rule.RutaRuleElement;
import org.apache.uima.ruta.type.RutaBasic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RutaTypeMatcher
implements RutaMatcher {
    private final TypeExpression expression;
    private AnnotationComparator comparator;

    public RutaTypeMatcher(TypeExpression expression) {
        this.expression = expression;
        this.comparator = new AnnotationComparator();
    }

    @Override
    public Collection<AnnotationFS> getMatchingAnnotations(RutaStream stream, RutaBlock parent) {
        TreeSet<AnnotationFS> result = new TreeSet<AnnotationFS>(this.comparator);
        List<Type> types = this.getTypes(parent, stream);
        for (Type type : types) {
            if (type == null) continue;
            String name = type.getName();
            RutaBasic firstBasicOfAll = stream.getFirstBasicOfAll();
            if ("uima.tcas.DocumentAnnotation".equals(name) || "org.apache.uima.ruta.type.Document".equals(name) || stream.getDocumentAnnotationType().getName().equals(name) && firstBasicOfAll != null && firstBasicOfAll.beginsWith(type)) {
                result.add(stream.getDocumentAnnotation());
                continue;
            }
            stream.moveToFirst();
            while (stream.isValid()) {
                RutaBasic nextBasic = (RutaBasic)stream.get();
                List allTypes = stream.getCas().getTypeSystem().getProperlySubsumedTypes(type);
                allTypes.add(type);
                for (Type eachType : allTypes) {
                    Set<AnnotationFS> beginAnchors = nextBasic.getBeginAnchors(eachType);
                    if (beginAnchors == null) continue;
                    for (AnnotationFS afs : beginAnchors) {
                        if (afs.getEnd() > stream.getDocumentAnnotation().getEnd()) continue;
                        result.add(afs);
                    }
                }
                stream.moveToNext();
            }
        }
        return result;
    }

    @Override
    public Collection<AnnotationFS> getAnnotationsAfter(RutaRuleElement ruleElement, AnnotationFS annotation, RutaStream stream, RutaBlock parent) {
        RutaBasic lastBasic = stream.getEndAnchor(annotation.getEnd());
        if (lastBasic == null) {
            return Collections.emptyList();
        }
        stream.moveTo((FeatureStructure)lastBasic);
        if (stream.isVisible((AnnotationFS)lastBasic)) {
            stream.moveToNext();
        }
        if (stream.isValid()) {
            RutaBasic nextBasic = (RutaBasic)stream.get();
            List<Type> reTypes = this.getTypes(parent, stream);
            TreeSet<AnnotationFS> anchors = new TreeSet<AnnotationFS>(this.comparator);
            for (Type eachMatchType : reTypes) {
                List types = stream.getCas().getTypeSystem().getProperlySubsumedTypes(eachMatchType);
                types.add(eachMatchType);
                for (Type eachType : types) {
                    Set<AnnotationFS> beginAnchors = nextBasic.getBeginAnchors(eachType);
                    if (beginAnchors == null) continue;
                    for (AnnotationFS afs : beginAnchors) {
                        if (afs.getEnd() > stream.getDocumentAnnotation().getEnd()) continue;
                        anchors.add(afs);
                    }
                }
            }
            return anchors;
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<AnnotationFS> getAnnotationsBefore(RutaRuleElement ruleElement, AnnotationFS annotation, RutaStream stream, RutaBlock parent) {
        RutaBasic firstBasic = stream.getBeginAnchor(annotation.getBegin());
        if (firstBasic == null) {
            return Collections.emptyList();
        }
        stream.moveTo((FeatureStructure)firstBasic);
        if (stream.isVisible((AnnotationFS)firstBasic)) {
            stream.moveToPrevious();
        }
        if (stream.isValid()) {
            RutaBasic nextBasic = (RutaBasic)stream.get();
            List<Type> reTypes = this.getTypes(parent, stream);
            TreeSet<AnnotationFS> anchors = new TreeSet<AnnotationFS>(this.comparator);
            for (Type eachMatchType : reTypes) {
                List types = stream.getCas().getTypeSystem().getProperlySubsumedTypes(eachMatchType);
                types.add(eachMatchType);
                for (Type eachType : types) {
                    Set<AnnotationFS> endAnchors = nextBasic.getEndAnchors(eachType);
                    if (endAnchors == null) continue;
                    for (AnnotationFS afs : endAnchors) {
                        if (afs.getBegin() < stream.getDocumentAnnotation().getBegin()) continue;
                        anchors.add(afs);
                    }
                }
            }
            return anchors;
        }
        return Collections.emptyList();
    }

    public FSMatchConstraint createAnchorConstraints(RutaBlock block, RutaStream stream) {
        ConstraintFactory cf = stream.getCas().getConstraintFactory();
        List<Type> types = this.getTypes(block, stream);
        BasicTypeConstraint result = null;
        for (Type eachType : types) {
            BasicTypeConstraint anchorConstraint = new BasicTypeConstraint(cf.createTypeConstraint(), eachType);
            anchorConstraint.add(eachType);
            if (result != null) {
                result = cf.or((FSMatchConstraint)result, (FSMatchConstraint)anchorConstraint);
                continue;
            }
            result = anchorConstraint;
        }
        return result;
    }

    @Override
    public boolean match(AnnotationFS annotation, RutaStream stream, RutaBlock parent) {
        if (annotation == null) {
            return false;
        }
        List<Type> types = this.getTypes(parent, stream);
        for (Type type : types) {
            String name = type.getName();
            if ("uima.tcas.DocumentAnnotation".equals(name) || stream.getDocumentAnnotationType().getName().equals(name)) {
                return true;
            }
            boolean b = stream.getJCas().getTypeSystem().subsumes(type, annotation.getType());
            if (!b) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.expression.toString();
    }

    @Override
    public RutaExpression getExpression() {
        return this.expression;
    }

    protected Type getType(TypeExpression expression, RutaBlock parent, RutaStream stream) {
        Type type = expression.getType(parent);
        if (type != null && "uima.tcas.DocumentAnnotation".equals(type.getName())) {
            return stream.getDocumentAnnotationType();
        }
        return type;
    }

    @Override
    public int estimateAnchors(RutaBlock parent, RutaStream stream) {
        return stream.getHistogram(this.getType(this.expression, parent, stream));
    }

    @Override
    public List<Type> getTypes(RutaBlock parent, RutaStream stream) {
        ArrayList<Type> result = new ArrayList<Type>(1);
        Type type = this.getType(this.expression, parent, stream);
        result.add(type);
        return result;
    }
}

