/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;

public class TCCLObjectInputStream
extends ObjectInputStream {
    private static final BlacklistClassResolver BLACKLIST_CLASSES = new BlacklistClassResolver(TCCLObjectInputStream.toArray(System.getProperty("batchee.serialization.class.blacklist", "org.codehaus.groovy.runtime.,org.apache.commons.collections.functors.,org.apache.xalan")), TCCLObjectInputStream.toArray(System.getProperty("batchee.serialization.class.whitelist")));
    private final ClassLoader tccl = Thread.currentThread().getContextClassLoader();

    public TCCLObjectInputStream(InputStream in) throws IOException {
        super(in);
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws ClassNotFoundException {
        return Class.forName(BLACKLIST_CLASSES.check(desc.getName()), false, this.tccl);
    }

    protected Class resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        Class[] cinterfaces = new Class[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            cinterfaces[i] = Class.forName(interfaces[i], false, this.tccl);
        }
        try {
            return Proxy.getProxyClass(this.tccl, cinterfaces);
        }
        catch (IllegalArgumentException e) {
            throw new ClassNotFoundException(null, e);
        }
    }

    private static String[] toArray(String property) {
        return property == null ? null : property.split(" *, *");
    }

    private static class BlacklistClassResolver {
        private final String[] blacklist;
        private final String[] whitelist;

        protected BlacklistClassResolver(String[] blacklist, String[] whitelist) {
            this.whitelist = whitelist;
            this.blacklist = blacklist;
        }

        protected boolean isBlacklisted(String name) {
            return this.whitelist != null && !BlacklistClassResolver.contains(this.whitelist, name) || BlacklistClassResolver.contains(this.blacklist, name);
        }

        public final String check(String name) {
            if (this.isBlacklisted(name)) {
                throw new SecurityException(name + " is not whitelisted as deserialisable, prevented before loading.");
            }
            return name;
        }

        private static String[] toArray(String property) {
            return property == null ? null : property.split(" *, *");
        }

        private static boolean contains(String[] list, String name) {
            if (list != null) {
                for (String white : list) {
                    if (!name.startsWith(white)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

