/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.api.ExponentialBackoff;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import io.smallrye.faulttolerance.config.ExponentialBackoffConfig;
import java.lang.annotation.Annotation;
import java.time.temporal.ChronoUnit;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public final class ExponentialBackoffConfigImpl
implements ExponentialBackoffConfig {
    private final Class<?> beanClass;
    private final MethodDescriptor method;
    private final ExponentialBackoff instance;
    private final boolean onMethod;
    private Integer _factor;
    private Long _maxDelay;
    private ChronoUnit _maxDelayUnit;

    private ExponentialBackoffConfigImpl(FaultToleranceMethod method) {
        this.beanClass = method.beanClass;
        this.method = method.method;
        this.instance = method.exponentialBackoff;
        this.onMethod = method.annotationsPresentDirectly.contains(ExponentialBackoff.class);
    }

    public static ExponentialBackoffConfigImpl create(FaultToleranceMethod method) {
        if (method.exponentialBackoff == null) {
            return null;
        }
        if (!io.smallrye.faulttolerance.autoconfig.Config.isEnabled(ExponentialBackoff.class, (MethodDescriptor)method.method)) {
            return null;
        }
        return new ExponentialBackoffConfigImpl(method);
    }

    public Class<?> beanClass() {
        return this.beanClass;
    }

    public MethodDescriptor method() {
        return this.method;
    }

    public Class<? extends Annotation> annotationType() {
        return ExponentialBackoff.class;
    }

    public boolean isOnMethod() {
        return this.onMethod;
    }

    public int factor() {
        if (this._factor == null) {
            Config config = ConfigProvider.getConfig();
            if (this.onMethod) {
                String key = this.method.declaringClass.getName() + "/" + this.method.name + "/ExponentialBackoff/factor";
                this._factor = config.getOptionalValue(key, Integer.TYPE).orElse(null);
            } else {
                String key = this.method.declaringClass.getName() + "/ExponentialBackoff/factor";
                this._factor = config.getOptionalValue(key, Integer.TYPE).orElse(null);
            }
            if (this._factor == null) {
                this._factor = config.getOptionalValue("ExponentialBackoff/factor", Integer.TYPE).orElse(null);
            }
            if (this._factor == null) {
                this._factor = this.instance.factor();
            }
        }
        return this._factor;
    }

    public long maxDelay() {
        if (this._maxDelay == null) {
            Config config = ConfigProvider.getConfig();
            if (this.onMethod) {
                String key = this.method.declaringClass.getName() + "/" + this.method.name + "/ExponentialBackoff/maxDelay";
                this._maxDelay = config.getOptionalValue(key, Long.TYPE).orElse(null);
            } else {
                String key = this.method.declaringClass.getName() + "/ExponentialBackoff/maxDelay";
                this._maxDelay = config.getOptionalValue(key, Long.TYPE).orElse(null);
            }
            if (this._maxDelay == null) {
                this._maxDelay = config.getOptionalValue("ExponentialBackoff/maxDelay", Long.TYPE).orElse(null);
            }
            if (this._maxDelay == null) {
                this._maxDelay = this.instance.maxDelay();
            }
        }
        return this._maxDelay;
    }

    public ChronoUnit maxDelayUnit() {
        if (this._maxDelayUnit == null) {
            Config config = ConfigProvider.getConfig();
            if (this.onMethod) {
                String key = this.method.declaringClass.getName() + "/" + this.method.name + "/ExponentialBackoff/maxDelayUnit";
                this._maxDelayUnit = config.getOptionalValue(key, ChronoUnit.class).orElse(null);
            } else {
                String key = this.method.declaringClass.getName() + "/ExponentialBackoff/maxDelayUnit";
                this._maxDelayUnit = config.getOptionalValue(key, ChronoUnit.class).orElse(null);
            }
            if (this._maxDelayUnit == null) {
                this._maxDelayUnit = config.getOptionalValue("ExponentialBackoff/maxDelayUnit", ChronoUnit.class).orElse(null);
            }
            if (this._maxDelayUnit == null) {
                this._maxDelayUnit = this.instance.maxDelayUnit();
            }
        }
        return this._maxDelayUnit;
    }

    public void materialize() {
        this.factor();
        this.maxDelay();
        this.maxDelayUnit();
    }
}

