/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.api.RateLimit;
import io.smallrye.faulttolerance.autoconfig.Config;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

public interface RateLimitConfig
extends RateLimit,
Config {
    default public void validate() {
        String INVALID_RATE_LIMIT_ON = "Invalid @RateLimit on ";
        if (this.value() < 1) {
            throw new FaultToleranceDefinitionException("Invalid @RateLimit on " + String.valueOf(this.method()) + ": value shouldn't be lower than 1");
        }
        if (this.window() < 1L) {
            throw new FaultToleranceDefinitionException("Invalid @RateLimit on " + String.valueOf(this.method()) + ": window shouldn't be lower than 1");
        }
        if (this.minSpacing() < 0L) {
            throw new FaultToleranceDefinitionException("Invalid @RateLimit on " + String.valueOf(this.method()) + ": minSpacing shouldn't be lower than 0");
        }
    }
}

