/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.GValue;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ScalarMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.util.ListFunction;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalUtil;

public final class MergeStep<S, E>
extends ScalarMapStep<S, E>
implements TraversalParent,
ListFunction {
    private Traversal.Admin<S, E> valueTraversal;
    private GValue<Object> parameterItems;

    public MergeStep(Traversal.Admin traversal, Object values) {
        super(traversal);
        if (values instanceof Traversal) {
            this.valueTraversal = this.integrateChild(((Traversal)values).asAdmin());
        } else {
            this.parameterItems = values instanceof GValue ? (GValue<Object>)values : GValue.of(null, values);
        }
    }

    public Traversal.Admin<S, E> getValueTraversal() {
        return this.valueTraversal;
    }

    public Object getParameterItems() {
        return this.parameterItems;
    }

    public GValue<Object> getParameterItemsGValue() {
        return this.parameterItems;
    }

    @Override
    public String getStepName() {
        return "merge";
    }

    @Override
    protected E map(Traverser.Admin<S> traverser) {
        Map mapA;
        Object incoming = traverser.get();
        Map map = mapA = incoming instanceof Map ? (Map)incoming : null;
        if (mapA != null) {
            Object mapB;
            Object object = mapB = this.valueTraversal != null ? TraversalUtil.apply(traverser, this.valueTraversal) : this.parameterItems.get();
            if (!(mapB instanceof Map)) {
                throw new IllegalArgumentException(String.format("%s step expected provided argument to evaluate to a Map, encountered %s", this.getStepName(), mapB.getClass()));
            }
            HashMap mergedMap = new HashMap(mapA);
            mergedMap.putAll((Map)mapB);
            return (E)mergedMap;
        }
        Collection listA = this.convertTraverserToCollection(traverser);
        if (this.parameterItems != null && this.parameterItems.get() instanceof Map) {
            throw new IllegalArgumentException(this.getStepName() + " step type mismatch: expected argument to be Iterable but got Map");
        }
        Collection listB = null != this.valueTraversal ? this.convertTraversalToCollection(traverser, this.valueTraversal) : this.convertArgumentToCollection(this.parameterItems.get());
        HashSet elements = new HashSet();
        elements.addAll(listA);
        elements.addAll(listB);
        return (E)elements;
    }

    @Override
    public List<Traversal.Admin<S, E>> getLocalChildren() {
        return null == this.valueTraversal ? Collections.emptyList() : Collections.singletonList(this.valueTraversal);
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return this.getSelfAndChildRequirements(new TraverserRequirement[0]);
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        if (this.valueTraversal != null) {
            this.integrateChild(this.valueTraversal);
        }
    }

    @Override
    public MergeStep<S, E> clone() {
        MergeStep clone = (MergeStep)super.clone();
        if (null != this.valueTraversal) {
            clone.valueTraversal = this.valueTraversal.clone();
        } else {
            clone.parameterItems = this.parameterItems;
        }
        return clone;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return Objects.hash(result, this.valueTraversal, this.parameterItems);
    }
}

