/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.step.GValue;
import org.apache.tinkerpop.gremlin.process.traversal.step.GValueHolder;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;

public interface HasContainerHolder<S, E>
extends GValueHolder<S, E> {
    public List<HasContainer> getHasContainers();

    public void addHasContainer(HasContainer var1);

    default public void removeHasContainer(HasContainer hasContainer) {
        throw new UnsupportedOperationException("The holder does not support container removal: " + this.getClass().getCanonicalName());
    }

    default public Collection<P<?>> getPredicates() {
        Collection<P<?>> predicates = this.getPredicatesGValueSafe();
        for (P<?> predicate : predicates) {
            if (!predicate.isParameterized()) continue;
            this.getTraversal().getGValueManager().pinGValues((Collection<GValue<?>>)predicate.getGValues());
        }
        return predicates;
    }

    default public Collection<P<?>> getPredicatesGValueSafe() {
        return this.getHasContainers().stream().map(p -> p.getPredicate()).collect(Collectors.toList());
    }

    @Override
    default public HasContainerHolder<S, E> asConcreteStep() {
        return this;
    }

    @Override
    default public boolean isParameterized() {
        return this.getPredicatesGValueSafe().stream().anyMatch(P::isParameterized);
    }

    @Override
    default public void updateVariable(String name, Object value) {
        this.getPredicatesGValueSafe().forEach(p -> p.updateVariable(name, value));
    }

    @Override
    default public Collection<GValue<?>> getGValues() {
        HashSet allGValues = new HashSet();
        for (P<?> p : this.getPredicatesGValueSafe()) {
            allGValues.addAll(p.getGValues());
        }
        return allGValues;
    }
}

