/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.corelib.components;

import java.util.List;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.RequestParameter;
import org.apache.tapestry5.dom.Element;
import org.apache.tapestry5.func.F;
import org.apache.tapestry5.func.Flow;
import org.apache.tapestry5.func.Worker;
import org.apache.tapestry5.http.Link;
import org.apache.tapestry5.internal.util.CaptureResultCallback;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.runtime.RenderCommand;
import org.apache.tapestry5.runtime.RenderQueue;
import org.apache.tapestry5.services.Heartbeat;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;
import org.apache.tapestry5.tree.DefaultTreeExpansionModel;
import org.apache.tapestry5.tree.TreeExpansionModel;
import org.apache.tapestry5.tree.TreeModel;
import org.apache.tapestry5.tree.TreeNode;
import org.apache.tapestry5.tree.TreeSelectionModel;

@Import(module={"t5/core/tree"})
public class Tree {
    @Parameter(required=true, autoconnect=true)
    private TreeModel model;
    @Parameter(name="class", defaultPrefix="literal")
    private String className;
    @Property
    @Parameter
    private TreeNode node;
    @Parameter(allowNull=false, value="defaultTreeExpansionModel")
    private TreeExpansionModel expansionModel;
    @Parameter
    private TreeSelectionModel selectionModel;
    @Parameter
    private Object value;
    @Property
    @Parameter(value="block:defaultRenderTreeNodeLabel")
    private RenderCommand label;
    @Environmental
    private JavaScriptSupport jss;
    @Inject
    private ComponentResources resources;
    @Persist
    private TreeExpansionModel defaultTreeExpansionModel;
    private static RenderCommand RENDER_CLOSE_TAG = new RenderCommand(){

        @Override
        public void render(MarkupWriter writer, RenderQueue queue) {
            writer.end();
        }
    };
    private static RenderCommand RENDER_LABEL_SPAN = new RenderCommand(){

        @Override
        public void render(MarkupWriter writer, RenderQueue queue) {
            writer.element("span", "class", "tree-label");
        }
    };
    private static RenderCommand MARK_SELECTED = new RenderCommand(){

        @Override
        public void render(MarkupWriter writer, RenderQueue queue) {
            writer.getElement().attribute("class", "selected-leaf-node");
        }
    };
    @Environmental
    private Heartbeat heartbeat;

    private RenderCommand toRenderCommand(final TreeNode node, final boolean isLast) {
        return new RenderCommand(){

            @Override
            public void render(MarkupWriter writer, RenderQueue queue) {
                Tree.this.node = node;
                Tree.this.value = node.getValue();
                boolean isLeaf = node.isLeaf();
                writer.element("li", new Object[0]);
                if (isLast) {
                    writer.attributes("class", "last");
                }
                if (isLeaf) {
                    writer.getElement().attribute("class", "leaf-node");
                }
                Element e = writer.element("span", "class", "tree-icon");
                if (!isLeaf && !node.getHasChildren()) {
                    e.addClassName("empty-node");
                }
                boolean hasChildren = !isLeaf && node.getHasChildren();
                boolean expanded = hasChildren && Tree.this.expansionModel.isExpanded(node);
                writer.attributes("data-node-id", node.getId());
                if (expanded) {
                    e.addClassName("tree-expanded");
                }
                writer.end();
                queue.push(RENDER_CLOSE_TAG);
                if (expanded) {
                    queue.push(new RenderNodes(node.getChildren()));
                }
                queue.push(RENDER_CLOSE_TAG);
                RenderCommand startHeartbeat = new RenderCommand(){

                    @Override
                    public void render(MarkupWriter writer, RenderQueue queue) {
                        Tree.this.heartbeat.begin();
                    }
                };
                RenderCommand endHeartbeat = new RenderCommand(){

                    @Override
                    public void render(MarkupWriter writer, RenderQueue queue) {
                        Tree.this.heartbeat.end();
                    }
                };
                queue.push(endHeartbeat);
                queue.push(Tree.this.label);
                queue.push(startHeartbeat);
                if (isLeaf && Tree.this.selectionModel != null && Tree.this.selectionModel.isSelected(node)) {
                    queue.push(MARK_SELECTED);
                }
                queue.push(RENDER_LABEL_SPAN);
            }
        };
    }

    public String getContainerClass() {
        return this.className == null ? "tree-container" : "tree-container " + this.className;
    }

    public Link getTreeActionLink() {
        return this.resources.createEventLink("treeAction", new Object[0]);
    }

    Object onTreeAction(@RequestParameter(value="t:nodeid") String nodeId, @RequestParameter(value="t:action") String action) {
        if (action.equalsIgnoreCase("expand")) {
            return this.doExpandChildren(nodeId);
        }
        if (action.equalsIgnoreCase("markExpanded")) {
            return this.doMarkExpanded(nodeId);
        }
        if (action.equalsIgnoreCase("markCollapsed")) {
            return this.doMarkCollapsed(nodeId);
        }
        if (action.equalsIgnoreCase("select")) {
            return this.doUpdateSelected(nodeId, true);
        }
        if (action.equalsIgnoreCase("deselect")) {
            return this.doUpdateSelected(nodeId, false);
        }
        throw new IllegalArgumentException(String.format("Unexpected action: '%s' for Tree component.", action));
    }

    Object doExpandChildren(String nodeId) {
        TreeNode container = this.model.getById(nodeId);
        this.expansionModel.markExpanded(container);
        return new RenderNodes(container.getChildren());
    }

    Object doMarkExpanded(String nodeId) {
        this.expansionModel.markExpanded(this.model.getById(nodeId));
        return new JSONObject();
    }

    Object doMarkCollapsed(String nodeId) {
        this.expansionModel.markCollapsed(this.model.getById(nodeId));
        return new JSONObject();
    }

    Object doUpdateSelected(String nodeId, boolean selected) {
        String event;
        TreeNode node = this.model.getById(nodeId);
        if (selected) {
            this.selectionModel.select(node);
            event = "nodeSelected";
        } else {
            this.selectionModel.unselect(node);
            event = "nodeUnselected";
        }
        CaptureResultCallback callback = CaptureResultCallback.create();
        this.resources.triggerEvent(event, new Object[]{nodeId}, callback);
        Object result = callback.getResult();
        if (result != null) {
            return result;
        }
        return new JSONObject();
    }

    public TreeExpansionModel getDefaultTreeExpansionModel() {
        if (this.defaultTreeExpansionModel == null) {
            this.defaultTreeExpansionModel = new DefaultTreeExpansionModel();
        }
        return this.defaultTreeExpansionModel;
    }

    public TreeExpansionModel getExpansionModel() {
        return this.expansionModel;
    }

    public TreeSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public Object getRenderRootNodes() {
        return new RenderNodes(this.model.getRootNodes());
    }

    public void clearExpansions() {
        this.expansionModel.clear();
    }

    public Boolean getSelectionEnabled() {
        return this.selectionModel != null ? Boolean.valueOf(true) : null;
    }

    private class RenderNodes
    implements RenderCommand {
        private final Flow<TreeNode> nodes;

        public RenderNodes(List<TreeNode> nodes) {
            this.nodes = (Flow)F.flow(nodes).reverse();
        }

        @Override
        public void render(MarkupWriter writer, final RenderQueue queue) {
            writer.element("ul", new Object[0]);
            queue.push(RENDER_CLOSE_TAG);
            if (this.nodes.isEmpty()) {
                return;
            }
            queue.push(Tree.this.toRenderCommand((TreeNode)this.nodes.first(), true));
            ((Flow)this.nodes.rest()).each((Worker)new Worker<TreeNode>(){

                public void work(TreeNode element) {
                    queue.push(Tree.this.toRenderCommand(element, false));
                }
            });
        }
    }
}

