/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.services;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.services.SymbolProvider;
import org.apache.tapestry5.ioc.services.SymbolSource;

public class SymbolSourceImpl
implements SymbolSource {
    private final List<SymbolProvider> providers;
    private final Map<String, String> cache = CollectionFactory.newConcurrentMap();

    public SymbolSourceImpl(List<SymbolProvider> providers) {
        this.providers = providers;
    }

    @Override
    public String expandSymbols(String input) {
        return new SymbolExpansion().expandSymbols(input);
    }

    @Override
    public String valueForSymbol(String symbolName) {
        String value = this.cache.get(symbolName);
        return value != null ? value : new SymbolExpansion().valueForSymbol(symbolName);
    }

    private class SymbolExpansion {
        private final LinkedList<String> expandingSymbols = CollectionFactory.newLinkedList();

        private SymbolExpansion() {
        }

        String expandSymbols(String input) {
            StringBuilder builder = null;
            int startx = 0;
            while (true) {
                int symbolx = input.indexOf("${", startx);
                if (startx == 0 && symbolx < 0) {
                    return input;
                }
                if (builder == null) {
                    builder = new StringBuilder();
                }
                if (symbolx < 0) break;
                builder.append(input.substring(startx, symbolx));
                int endx = input.indexOf("}", symbolx);
                if (endx < 0) {
                    String message = this.expandingSymbols.isEmpty() ? String.format("Input string '%s' is missing a symbol closing brace.", input) : String.format("Input string '%s' is missing a symbol closing brace (in %s).", input, this.path());
                    throw new RuntimeException(message);
                }
                String symbolName = input.substring(symbolx + 2, endx);
                builder.append(this.valueForSymbol(symbolName));
                startx = endx + 1;
            }
            builder.append(input.substring(startx));
            return builder.toString();
        }

        String valueForSymbol(String symbolName) {
            String value = (String)SymbolSourceImpl.this.cache.get(symbolName);
            if (value == null) {
                value = this.expandSymbol(symbolName);
                SymbolSourceImpl.this.cache.put(symbolName, value);
            }
            return value;
        }

        String expandSymbol(String symbolName) {
            SymbolProvider provider;
            if (this.expandingSymbols.contains(symbolName)) {
                this.expandingSymbols.add(symbolName);
                throw new RuntimeException(String.format("Symbol '%s' is defined in terms of itself (%s).", symbolName, this.pathFrom(symbolName)));
            }
            this.expandingSymbols.addLast(symbolName);
            String value = null;
            Iterator iterator = SymbolSourceImpl.this.providers.iterator();
            while (iterator.hasNext() && (value = (provider = (SymbolProvider)iterator.next()).valueForSymbol(symbolName)) == null) {
            }
            if (value == null) {
                String message = this.expandingSymbols.size() == 1 ? String.format("Symbol '%s' is not defined.", symbolName) : String.format("Symbol '%s' is not defined (in %s).", symbolName, this.path());
                throw new RuntimeException(message);
            }
            String result = this.expandSymbols(value);
            this.expandingSymbols.removeLast();
            return result;
        }

        String path() {
            StringBuilder builder = new StringBuilder();
            boolean first = true;
            for (String symbolName : this.expandingSymbols) {
                if (!first) {
                    builder.append(" --> ");
                }
                builder.append(symbolName);
                first = false;
            }
            return builder.toString();
        }

        String pathFrom(String startSymbolName) {
            StringBuilder builder = new StringBuilder();
            boolean first = true;
            boolean match = false;
            for (String symbolName : this.expandingSymbols) {
                if (!match) {
                    if (!symbolName.equals(startSymbolName)) continue;
                    match = true;
                }
                if (!first) {
                    builder.append(" --> ");
                }
                builder.append(symbolName);
                first = false;
            }
            return builder.toString();
        }
    }
}

