/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.tree;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.tapestry5.ValueEncoder;
import org.apache.tapestry5.func.F;
import org.apache.tapestry5.func.Mapper;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.tree.TreeModel;
import org.apache.tapestry5.tree.TreeModelAdapter;
import org.apache.tapestry5.tree.TreeNode;

public class DefaultTreeModel<T>
implements TreeModel<T> {
    private final ValueEncoder<T> encoder;
    private final TreeModelAdapter<T> adapter;
    private final List<TreeNode<T>> roots;
    private final Map<String, TreeNode<T>> cache = CollectionFactory.newMap();
    private final Mapper<T, TreeNode<T>> toTreeNode = new Mapper<T, TreeNode<T>>(){

        public TreeNode<T> map(T value) {
            return new DefaultTreeNode(value);
        }
    };

    public DefaultTreeModel(ValueEncoder<T> encoder, TreeModelAdapter<T> adapter, T root) {
        this(encoder, adapter, Collections.singletonList(root));
    }

    public DefaultTreeModel(ValueEncoder<T> encoder, TreeModelAdapter<T> adapter, List<T> roots) {
        assert (encoder != null);
        assert (adapter != null);
        assert (roots != null);
        assert (!roots.isEmpty());
        this.encoder = encoder;
        this.adapter = adapter;
        this.roots = F.flow(roots).map(this.toTreeNode).toList();
    }

    @Override
    public List<TreeNode<T>> getRootNodes() {
        return this.roots;
    }

    @Override
    public TreeNode<T> getById(String id) {
        assert (id != null);
        TreeNode<T> result = this.findById(id);
        if (result == null) {
            throw new IllegalArgumentException(String.format("Could not locate TreeNode '%s'.", id));
        }
        return result;
    }

    private TreeNode<T> findById(String id) {
        TreeNode<T> result = this.cache.get(id);
        if (result != null) {
            return result;
        }
        LinkedList<TreeNode<T>> queue = new LinkedList<TreeNode<T>>(this.roots);
        while (!queue.isEmpty()) {
            TreeNode<T> node = queue.removeFirst();
            String nodeId = node.getId();
            this.cache.put(nodeId, node);
            if (nodeId.equals(id)) {
                return node;
            }
            if (node.isLeaf() || !node.getHasChildren()) continue;
            for (TreeNode<T> child : node.getChildren()) {
                queue.addFirst(child);
            }
        }
        return null;
    }

    @Override
    public TreeNode<T> find(T element) {
        return this.findById(this.encoder.toClient(element));
    }

    private class DefaultTreeNode
    implements TreeNode<T> {
        private final T value;
        private List<TreeNode<T>> children;

        DefaultTreeNode(T value) {
            this.value = value;
        }

        @Override
        public String getId() {
            return DefaultTreeModel.this.encoder.toClient(this.value);
        }

        @Override
        public T getValue() {
            return this.value;
        }

        @Override
        public boolean isLeaf() {
            return DefaultTreeModel.this.adapter.isLeaf(this.value);
        }

        @Override
        public boolean getHasChildren() {
            return DefaultTreeModel.this.adapter.hasChildren(this.value);
        }

        @Override
        public List<TreeNode<T>> getChildren() {
            if (this.children == null) {
                List childValues = DefaultTreeModel.this.adapter.getChildren(this.value);
                boolean empty = childValues == null || childValues.isEmpty();
                this.children = empty ? this.emptyTreeNodeList() : F.flow(childValues).map(DefaultTreeModel.this.toTreeNode).toList();
            }
            return this.children;
        }

        @Override
        public String getLabel() {
            return DefaultTreeModel.this.adapter.getLabel(this.value);
        }

        private List<TreeNode<T>> emptyTreeNodeList() {
            return Collections.emptyList();
        }
    }
}

