/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.services;

import java.util.Map;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;

public final class TransformUtils {
    private static final Map<String, PrimitiveTypeInfo> nameToInfo = CollectionFactory.newMap();
    private static final Map<Class, PrimitiveTypeInfo> classToInfo = CollectionFactory.newMap();

    private TransformUtils() {
    }

    private static void add(Class primitiveType, Class wrapperType, String unwrapperMethodName, String defaultValue) {
        PrimitiveTypeInfo info = new PrimitiveTypeInfo(wrapperType, unwrapperMethodName, defaultValue);
        classToInfo.put(primitiveType, info);
        nameToInfo.put(primitiveType.getName(), info);
    }

    public static boolean isPrimitive(String type) {
        return nameToInfo.containsKey(type);
    }

    public static String getWrapperTypeName(String type) {
        PrimitiveTypeInfo info = nameToInfo.get(type);
        return info == null ? type : info.wrapperType.getName();
    }

    public static String getUnwrapperMethodName(String type) {
        PrimitiveTypeInfo info = nameToInfo.get(type);
        return info == null ? null : info.unwrapperMethodName;
    }

    public static Class getWrapperType(Class type) {
        PrimitiveTypeInfo info = classToInfo.get(type);
        return info == null ? type : info.wrapperType;
    }

    public static String getDefaultValue(String type) {
        PrimitiveTypeInfo info = nameToInfo.get(type);
        return info == null ? "null" : info.defaultValue;
    }

    static {
        TransformUtils.add(Boolean.TYPE, Boolean.class, "booleanValue", "false");
        TransformUtils.add(Byte.TYPE, Byte.class, "byteValue", "0");
        TransformUtils.add(Character.TYPE, Character.class, "charValue", "0");
        TransformUtils.add(Short.TYPE, Short.class, "shortValue", "0");
        TransformUtils.add(Integer.TYPE, Integer.class, "intValue", "0");
        TransformUtils.add(Long.TYPE, Long.class, "longValue", "0L");
        TransformUtils.add(Float.TYPE, Float.class, "floatValue", "0.0f");
        TransformUtils.add(Double.TYPE, Double.class, "doubleValue", "0.0d");
    }

    static class PrimitiveTypeInfo {
        private final Class wrapperType;
        private final String unwrapperMethodName;
        private final String defaultValue;

        public PrimitiveTypeInfo(Class wrapperType, String unwrapperMethodName, String defaultValue) {
            this.wrapperType = wrapperType;
            this.unwrapperMethodName = unwrapperMethodName;
            this.defaultValue = defaultValue;
        }
    }
}

