/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.tapestry5.func.F;
import org.apache.tapestry5.func.Mapper;
import org.apache.tapestry5.ioc.util.AvailableValues;
import org.apache.tapestry5.ioc.util.UnknownValueException;
import org.apache.tapestry5.plastic.PlasticUtils;
import org.apache.tapestry5.services.ComponentEventResultProcessor;

public class ObjectComponentEventResultProcessor
implements ComponentEventResultProcessor<Object> {
    private final Collection<Class> configuredClasses;

    public ObjectComponentEventResultProcessor(Collection<Class> configuredClasses) {
        this.configuredClasses = configuredClasses;
    }

    @Override
    public void processResultValue(Object value) throws IOException {
        List names = F.flow(this.configuredClasses).map((Mapper)new Mapper<Class, String>(){

            public String map(Class input) {
                return PlasticUtils.toTypeName((Class)input);
            }
        }).toList();
        String message = String.format("A component event handler method returned the value %s. Return type %s can not be handled.", value, PlasticUtils.toTypeName(value.getClass()));
        throw new UnknownValueException(message, new AvailableValues("Configured return types", (Collection)names));
    }
}

