/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.tapestry5.ioc.annotations.Marker;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.annotations.UsesMappedConfiguration;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.services.AssetRequestDispatcher;
import org.apache.tapestry5.services.Dispatcher;
import org.apache.tapestry5.services.PathConstructor;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.Response;
import org.apache.tapestry5.services.assets.AssetRequestHandler;

@Marker(value={AssetRequestDispatcher.class})
@UsesMappedConfiguration(value=AssetRequestHandler.class)
public class AssetDispatcher
implements Dispatcher {
    private final Map<String, AssetRequestHandler> pathToHandler = CollectionFactory.newMap();
    private final List<String> assetPaths = CollectionFactory.newList();
    private final String requestPathPrefix;

    public AssetDispatcher(Map<String, AssetRequestHandler> configuration, PathConstructor pathConstructor, @Symbol(value="tapestry.asset-path-prefix") String assetPathPrefix) {
        this.requestPathPrefix = pathConstructor.constructDispatchPath(assetPathPrefix, "");
        for (String path : configuration.keySet()) {
            AssetRequestHandler handler = configuration.get(path);
            this.addPath(this.requestPathPrefix, path, handler);
        }
        Collections.sort(this.assetPaths, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o2.length() - o1.length();
            }
        });
    }

    private void addPath(String prefix, String path, AssetRequestHandler handler) {
        String extendedPath = this.buildPath(prefix, path);
        this.pathToHandler.put(extendedPath, handler);
        this.assetPaths.add(extendedPath);
    }

    private String buildPath(String prefix, String path) {
        return path.length() == 0 ? prefix : prefix + path + "/";
    }

    @Override
    public boolean dispatch(Request request, Response response) throws IOException {
        String path = request.getPath();
        if (!path.startsWith(this.requestPathPrefix)) {
            return false;
        }
        for (String extendedPath : this.assetPaths) {
            String extraPath;
            AssetRequestHandler handler;
            boolean handled;
            if (!path.startsWith(extendedPath) || !(handled = (handler = this.pathToHandler.get(extendedPath)).handleAssetRequest(request, response, extraPath = path.substring(extendedPath.length())))) continue;
            return true;
        }
        response.sendError(404, path);
        return true;
    }
}

