/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.io.IOException;
import java.io.PrintWriter;
import org.apache.tapestry5.ContentType;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.internal.services.AjaxPartialResponseRenderer;
import org.apache.tapestry5.ioc.IOOperation;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.MarkupWriterFactory;
import org.apache.tapestry5.services.PartialMarkupRenderer;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.Response;

public class AjaxPartialResponseRendererImpl
implements AjaxPartialResponseRenderer {
    private final MarkupWriterFactory factory;
    private final Request request;
    private final Response response;
    private final PartialMarkupRenderer partialMarkupRenderer;
    private final boolean compactJSON;
    private final ContentType contentType;

    public AjaxPartialResponseRendererImpl(MarkupWriterFactory factory, Request request, Response response, PartialMarkupRenderer partialMarkupRenderer, @Inject @Symbol(value="tapestry.charset") String outputEncoding, @Symbol(value="tapestry.compact-json") boolean compactJSON) {
        this.factory = factory;
        this.request = request;
        this.response = response;
        this.partialMarkupRenderer = partialMarkupRenderer;
        this.compactJSON = compactJSON;
        this.contentType = new ContentType("application/json").withCharset(outputEncoding);
    }

    @Override
    public void renderPartialPageMarkup(final JSONObject reply) throws IOException {
        assert (reply != null);
        this.request.setAttribute("tapestry.response-renderer", new IOOperation<Void>(){

            public Void perform() throws IOException {
                String pageName = (String)AjaxPartialResponseRendererImpl.this.request.getAttribute("page-name");
                if (pageName == null) {
                    throw new IllegalStateException("The active page name has not been specified.");
                }
                MarkupWriter writer = AjaxPartialResponseRendererImpl.this.factory.newPartialMarkupWriter(pageName);
                AjaxPartialResponseRendererImpl.this.partialMarkupRenderer.renderMarkup(writer, reply);
                PrintWriter pw = AjaxPartialResponseRendererImpl.this.response.getPrintWriter(AjaxPartialResponseRendererImpl.this.contentType.toString());
                reply.print(pw, AjaxPartialResponseRendererImpl.this.compactJSON);
                pw.close();
                return null;
            }
        });
    }

    @Override
    public void renderPartialPageMarkup() throws IOException {
        this.renderPartialPageMarkup(new JSONObject());
    }
}

