/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.tapestry5.internal.services.PersistentFieldChangeImpl;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.services.PersistentFieldChange;
import org.apache.tapestry5.services.PersistentFieldStrategy;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.Session;

public abstract class AbstractSessionPersistentFieldStrategy
implements PersistentFieldStrategy {
    private final String prefix;
    private final Request request;

    protected AbstractSessionPersistentFieldStrategy(String prefix, Request request) {
        this.prefix = prefix;
        this.request = request;
    }

    @Override
    public final Collection<PersistentFieldChange> gatherFieldChanges(String pageName) {
        Session session = this.request.getSession(false);
        if (session == null) {
            return Collections.emptyList();
        }
        List result = CollectionFactory.newList();
        String fullPrefix = this.prefix + pageName + ":";
        for (String name : session.getAttributeNames(fullPrefix)) {
            Object persistedValue = session.getAttribute(name);
            Object applicationValue = persistedValue == null ? null : this.convertPersistedToApplicationValue(persistedValue);
            PersistentFieldChange change = this.buildChange(name, applicationValue);
            result.add(change);
            this.didReadChange(session, name);
        }
        return result;
    }

    @Override
    public void discardChanges(String pageName) {
        Session session = this.request.getSession(false);
        if (session == null) {
            return;
        }
        String fullPrefix = this.prefix + pageName + ":";
        for (String name : session.getAttributeNames(fullPrefix)) {
            session.setAttribute(name, null);
        }
    }

    protected void didReadChange(Session session, String attributeName) {
    }

    private PersistentFieldChange buildChange(String name, Object newValue) {
        String[] chunks = name.split(":");
        String componentId = chunks[2];
        String fieldName = chunks[3];
        return new PersistentFieldChangeImpl(componentId, fieldName, newValue);
    }

    @Override
    public final void postChange(String pageName, String componentId, String fieldName, Object newValue) {
        assert (InternalUtils.isNonBlank((String)pageName));
        assert (InternalUtils.isNonBlank((String)fieldName));
        Object persistedValue = newValue == null ? null : this.convertApplicationValueToPersisted(newValue);
        StringBuilder builder = new StringBuilder(this.prefix);
        builder.append(pageName);
        builder.append(':');
        if (componentId != null) {
            builder.append(componentId);
        }
        builder.append(':');
        builder.append(fieldName);
        Session session = this.request.getSession(persistedValue != null);
        if (session != null) {
            session.setAttribute(builder.toString(), persistedValue);
        }
    }

    protected Object convertApplicationValueToPersisted(Object newValue) {
        return newValue;
    }

    protected Object convertPersistedToApplicationValue(Object persistedValue) {
        return persistedValue;
    }
}

