/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.model;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tapestry5.internal.model.MutableEmbeddedComponentModelImpl;
import org.apache.tapestry5.internal.model.ParameterModelImpl;
import org.apache.tapestry5.ioc.Location;
import org.apache.tapestry5.ioc.Resource;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.util.IdAllocator;
import org.apache.tapestry5.model.ComponentModel;
import org.apache.tapestry5.model.EmbeddedComponentModel;
import org.apache.tapestry5.model.MutableComponentModel;
import org.apache.tapestry5.model.MutableEmbeddedComponentModel;
import org.apache.tapestry5.model.ParameterModel;
import org.slf4j.Logger;

public final class MutableComponentModelImpl
implements MutableComponentModel {
    private final ComponentModel parentModel;
    private final Resource baseResource;
    private final String componentClassName;
    private final IdAllocator persistentFieldNameAllocator = new IdAllocator();
    private final Logger logger;
    private final boolean pageClass;
    private Map<String, ParameterModel> parameters;
    private Map<String, EmbeddedComponentModel> embeddedComponents;
    private Map<String, String> persistentFields;
    private List<String> mixinClassNames;
    private Map<String, String[]> mixinOrders;
    private boolean informalParametersSupported;
    private boolean mixinAfter;
    private Map<String, String> metaData;
    private Set<Class> handledRenderPhases;
    private Map<String, Boolean> handledEvents;
    private final String libraryName;
    private boolean handleActivationEventContext;

    public MutableComponentModelImpl(String componentClassName, Logger logger, Resource baseResource, ComponentModel parentModel, boolean pageClass, String libraryName) {
        this.componentClassName = componentClassName;
        this.logger = logger;
        this.baseResource = baseResource;
        this.parentModel = parentModel;
        this.pageClass = pageClass;
        this.libraryName = libraryName;
        this.handleActivationEventContext = false;
        if (this.parentModel != null) {
            for (String name : this.parentModel.getPersistentFieldNames()) {
                this.persistentFieldNameAllocator.allocateId(name);
            }
        }
    }

    @Override
    public String getLibraryName() {
        return this.libraryName;
    }

    public String toString() {
        return String.format("ComponentModel[%s]", this.componentClassName);
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public Resource getBaseResource() {
        return this.baseResource;
    }

    @Override
    public String getComponentClassName() {
        return this.componentClassName;
    }

    @Override
    public void addParameter(String name, boolean required, boolean allowNull, String defaultBindingPrefix, boolean cached) {
        assert (InternalUtils.isNonBlank((String)name));
        assert (InternalUtils.isNonBlank((String)defaultBindingPrefix));
        if (this.parameters == null) {
            this.parameters = CollectionFactory.newCaseInsensitiveMap();
        }
        if (this.parameters.containsKey(name)) {
            throw new IllegalArgumentException(String.format("Parameter '%s' of component class %s is already defined.", name, this.componentClassName));
        }
        ParameterModel existingModel = this.getParameterModel(name);
        if (existingModel != null) {
            throw new IllegalArgumentException(String.format("Parameter '%s' of component class %s conflicts with the parameter defined by the %s base class.", name, this.componentClassName, existingModel.getComponentModel().getComponentClassName()));
        }
        this.parameters.put(name, new ParameterModelImpl(this, name, required, allowNull, defaultBindingPrefix, cached));
    }

    @Override
    public void addParameter(String name, boolean required, boolean allowNull, String defaultBindingPrefix) {
        this.addParameter(name, required, allowNull, defaultBindingPrefix, false);
    }

    @Override
    public ParameterModel getParameterModel(String parameterName) {
        ParameterModel result = (ParameterModel)InternalUtils.get(this.parameters, (Object)parameterName);
        if (result == null && this.parentModel != null) {
            result = this.parentModel.getParameterModel(parameterName);
        }
        return result;
    }

    @Override
    public boolean isFormalParameter(String parameterName) {
        return this.getParameterModel(parameterName) != null;
    }

    @Override
    public List<String> getParameterNames() {
        List names = CollectionFactory.newList();
        if (this.parameters != null) {
            names.addAll(this.parameters.keySet());
        }
        if (this.parentModel != null) {
            names.addAll(this.parentModel.getParameterNames());
        }
        Collections.sort(names);
        return names;
    }

    @Override
    public List<String> getDeclaredParameterNames() {
        return InternalUtils.sortedKeys(this.parameters);
    }

    @Override
    public MutableEmbeddedComponentModel addEmbeddedComponent(String id, String type, String componentClassName, boolean inheritInformalParameters, Location location) {
        if (this.embeddedComponents == null) {
            this.embeddedComponents = CollectionFactory.newCaseInsensitiveMap();
        } else if (this.embeddedComponents.containsKey(id)) {
            throw new IllegalArgumentException(String.format("Embedded component '%s' has already been defined for component class %s.", id, this.componentClassName));
        }
        MutableEmbeddedComponentModelImpl embedded = new MutableEmbeddedComponentModelImpl(id, type, componentClassName, this.componentClassName, inheritInformalParameters, location);
        this.embeddedComponents.put(id, embedded);
        return embedded;
    }

    @Override
    public List<String> getEmbeddedComponentIds() {
        List result = CollectionFactory.newList();
        if (this.embeddedComponents != null) {
            result.addAll(this.embeddedComponents.keySet());
        }
        if (this.parentModel != null) {
            result.addAll(this.parentModel.getEmbeddedComponentIds());
        }
        Collections.sort(result);
        return result;
    }

    @Override
    public EmbeddedComponentModel getEmbeddedComponentModel(String componentId) {
        EmbeddedComponentModel result = (EmbeddedComponentModel)InternalUtils.get(this.embeddedComponents, (Object)componentId);
        if (result == null && this.parentModel != null) {
            result = this.parentModel.getEmbeddedComponentModel(componentId);
        }
        return result;
    }

    @Override
    public String getFieldPersistenceStrategy(String fieldName) {
        String result = (String)InternalUtils.get(this.persistentFields, (Object)fieldName);
        if (result == null && this.parentModel != null) {
            result = this.parentModel.getFieldPersistenceStrategy(fieldName);
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("No field persistence strategy has been defined for field '%s'.", fieldName));
        }
        return result;
    }

    @Override
    public List<String> getPersistentFieldNames() {
        return this.persistentFieldNameAllocator.getAllocatedIds();
    }

    @Override
    public String setFieldPersistenceStrategy(String fieldName, String strategy) {
        String logicalFieldName = this.persistentFieldNameAllocator.allocateId(fieldName);
        if (this.persistentFields == null) {
            this.persistentFields = CollectionFactory.newMap();
        }
        this.persistentFields.put(logicalFieldName, strategy);
        return logicalFieldName;
    }

    @Override
    public boolean isRootClass() {
        return this.parentModel == null;
    }

    @Override
    public void addMixinClassName(String mixinClassName, String ... order) {
        if (this.mixinClassNames == null) {
            this.mixinClassNames = CollectionFactory.newList();
        }
        this.mixinClassNames.add(mixinClassName);
        if (order != null && order.length > 0) {
            if (this.mixinOrders == null) {
                this.mixinOrders = CollectionFactory.newCaseInsensitiveMap();
            }
            this.mixinOrders.put(mixinClassName, order);
        }
    }

    @Override
    public List<String> getMixinClassNames() {
        List result = CollectionFactory.newList();
        if (this.mixinClassNames != null) {
            result.addAll(this.mixinClassNames);
        }
        if (this.parentModel != null) {
            result.addAll(this.parentModel.getMixinClassNames());
        }
        Collections.sort(result);
        return result;
    }

    @Override
    public void enableSupportsInformalParameters() {
        this.informalParametersSupported = true;
    }

    @Override
    public boolean getSupportsInformalParameters() {
        return this.informalParametersSupported;
    }

    @Override
    public ComponentModel getParentModel() {
        return this.parentModel;
    }

    @Override
    public boolean isMixinAfter() {
        return this.mixinAfter;
    }

    @Override
    public void setMixinAfter(boolean mixinAfter) {
        this.mixinAfter = mixinAfter;
    }

    @Override
    public void setMeta(String key, String value) {
        assert (InternalUtils.isNonBlank((String)key));
        assert (InternalUtils.isNonBlank((String)value));
        if (this.metaData == null) {
            this.metaData = CollectionFactory.newCaseInsensitiveMap();
        }
        this.metaData.put(key, value);
    }

    @Override
    public void addRenderPhase(Class renderPhase) {
        assert (renderPhase != null);
        if (this.handledRenderPhases == null) {
            this.handledRenderPhases = CollectionFactory.newSet();
        }
        this.handledRenderPhases.add(renderPhase);
    }

    @Override
    public void addEventHandler(String eventType) {
        if (this.handledEvents == null) {
            this.handledEvents = CollectionFactory.newCaseInsensitiveMap();
        }
        this.handledEvents.put(eventType, true);
    }

    @Override
    public String getMeta(String key) {
        String result = (String)InternalUtils.get(this.metaData, (Object)key);
        if (result == null && this.parentModel != null) {
            result = this.parentModel.getMeta(key);
        }
        return result;
    }

    @Override
    public Set<Class> getHandledRenderPhases() {
        Set result = CollectionFactory.newSet();
        if (this.parentModel != null) {
            result.addAll(this.parentModel.getHandledRenderPhases());
        }
        if (this.handledRenderPhases != null) {
            result.addAll(this.handledRenderPhases);
        }
        return result;
    }

    @Override
    public boolean handlesEvent(String eventType) {
        if (InternalUtils.get(this.handledEvents, (Object)eventType) != null) {
            return true;
        }
        return this.parentModel == null ? false : this.parentModel.handlesEvent(eventType);
    }

    @Override
    public String[] getOrderForMixin(String mixinClassName) {
        String[] orders = (String[])InternalUtils.get(this.mixinOrders, (Object)mixinClassName);
        if (orders == null && this.parentModel != null) {
            return this.parentModel.getOrderForMixin(mixinClassName);
        }
        return orders;
    }

    @Override
    public boolean isPage() {
        return this.pageClass;
    }

    @Override
    public void doHandleActivationEventContext() {
        this.handleActivationEventContext = true;
    }

    @Override
    public boolean handleActivationEventContext() {
        return this.handleActivationEventContext;
    }
}

