/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.beaneditor;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.tapestry5.internal.beaneditor.EnvironmentMessages;
import org.apache.tapestry5.ioc.AnnotationProvider;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.services.Environment;
import org.apache.tapestry5.services.ValidationConstraintGenerator;

public class MessagesConstraintGenerator
implements ValidationConstraintGenerator {
    private final Environment environment;
    private final Pattern splitPattern;

    public MessagesConstraintGenerator(Environment environment) {
        this.environment = environment;
        this.splitPattern = Pattern.compile("(?<!\\\\)\\s*,\\s*(?!([0-9]*\\}))");
    }

    public List<String> buildConstraints(Class propertyType, AnnotationProvider annotationProvider) {
        EnvironmentMessages environmentMessages = this.environment.peek(EnvironmentMessages.class);
        if (environmentMessages == null) {
            return null;
        }
        String key = environmentMessages.getOverrideId() + "-validate";
        Messages m = environmentMessages.getMessages();
        if (!m.contains(key)) {
            return null;
        }
        String result = m.get(key);
        if (InternalUtils.isBlank((String)result)) {
            return null;
        }
        return Arrays.asList(this.splitPattern.split(result));
    }
}

