/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.corelib.components;

import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.alerts.AlertManager;
import org.apache.tapestry5.annotations.Component;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.corelib.components.Zone;
import org.apache.tapestry5.internal.services.ReloadHelper;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.Session;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;

public class DevTool {
    @Parameter
    private boolean enabled;
    @Parameter
    private boolean navbar;
    @Parameter(name="class", defaultPrefix="literal")
    private String className;
    @Property
    @Inject
    @Symbol(value="tapestry.production-mode")
    private boolean productionMode;
    @Component(inheritInformalParameters=true, parameters={"class=zoneClass", "elementName=${zoneElement}"})
    private Zone devmodezone;
    @Inject
    private AlertManager alertManager;
    @Inject
    private Request request;
    @Environmental
    private JavaScriptSupport javaScriptSupport;
    @Inject
    private ComponentResources resources;
    @Inject
    private ReloadHelper reloadHelper;

    public String getZoneElement() {
        return this.navbar ? "li" : "div";
    }

    public String getZoneClass() {
        return "dropdown" + (this.className == null ? "" : " " + this.className);
    }

    public String getTriggerClass() {
        return "dropdown-toggle" + (this.navbar ? "" : " btn btn-default btn-xs");
    }

    boolean defaultEnabled() {
        return !this.productionMode;
    }

    boolean beginRender() {
        if (this.enabled) {
            this.javaScriptSupport.importStack("core").require("bootstrap/dropdown");
        }
        return this.enabled;
    }

    Object onActionFromReset() {
        if (!this.productionMode) {
            this.resources.discardPersistentFieldChanges();
            this.alertManager.info("Page state discarded.");
        }
        return this.devmodezone.getBody();
    }

    Object onActionFromKill() {
        if (!this.productionMode) {
            Session session = this.request.getSession(false);
            if (session == null) {
                this.alertManager.info("No server-side session currently exist.");
            } else {
                session.invalidate();
                this.alertManager.info("Server-side session invalidated.");
            }
        }
        return this.devmodezone.getBody();
    }

    Object onActionFromReload() {
        this.reloadHelper.forceReload();
        return this.devmodezone.getBody();
    }
}

