/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.beanvalidator;

import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.MessageInterpolator;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import org.apache.tapestry5.Field;
import org.apache.tapestry5.FieldValidator;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.ValidationException;
import org.apache.tapestry5.beanvalidator.BeanValidatorGroupSource;
import org.apache.tapestry5.beanvalidator.ClientConstraintDescriptor;
import org.apache.tapestry5.beanvalidator.ClientConstraintDescriptorSource;
import org.apache.tapestry5.internal.BeanValidationContext;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.services.Environment;
import org.apache.tapestry5.services.FormSupport;

public class BeanFieldValidator
implements FieldValidator {
    private final Field field;
    private final ValidatorFactory validatorFactory;
    private final BeanValidatorGroupSource beanValidationGroupSource;
    private final ClientConstraintDescriptorSource clientValidatorSource;
    private final FormSupport formSupport;
    private final Environment environment;

    public BeanFieldValidator(Field field, ValidatorFactory validatorFactory, BeanValidatorGroupSource beanValidationGroupSource, ClientConstraintDescriptorSource clientValidatorSource, FormSupport formSupport, Environment environment) {
        this.field = field;
        this.validatorFactory = validatorFactory;
        this.beanValidationGroupSource = beanValidationGroupSource;
        this.clientValidatorSource = clientValidatorSource;
        this.formSupport = formSupport;
        this.environment = environment;
    }

    public boolean isRequired() {
        return false;
    }

    public void render(MarkupWriter writer) {
        BeanValidationContext beanValidationContext = (BeanValidationContext)this.environment.peek(BeanValidationContext.class);
        if (beanValidationContext == null) {
            return;
        }
        Validator validator = this.validatorFactory.getValidator();
        String currentProperty = beanValidationContext.getCurrentProperty();
        if (currentProperty == null) {
            return;
        }
        ValidationInfo validationInfo = BeanFieldValidator.getValidationInfo(beanValidationContext, currentProperty, validator);
        PropertyDescriptor propertyDescriptor = validationInfo.getPropertyDescriptor();
        if (propertyDescriptor == null) {
            return;
        }
        for (ConstraintDescriptor descriptor : propertyDescriptor.getConstraintDescriptors()) {
            Class<? extends Annotation> annotationType = descriptor.getAnnotation().annotationType();
            ClientConstraintDescriptor clientConstraintDescriptor = this.clientValidatorSource.getConstraintDescriptor(annotationType);
            if (clientConstraintDescriptor == null) continue;
            String message = String.format("%s %s", this.field.getLabel(), this.interpolateMessage(descriptor));
            Map attributes = CollectionFactory.newMap();
            for (String attribute : clientConstraintDescriptor.getAttributes()) {
                Object object = descriptor.getAttributes().get(attribute);
                if (object == null) {
                    throw new NullPointerException(String.format("Attribute '%s' of %s is null but is required to apply client-side validation.", attribute, descriptor));
                }
                attributes.put(attribute, object);
            }
            clientConstraintDescriptor.applyClientValidation(writer, message, attributes);
        }
    }

    public void validate(Object value) throws ValidationException {
        BeanValidationContext beanValidationContext = (BeanValidationContext)this.environment.peek(BeanValidationContext.class);
        if (beanValidationContext == null) {
            return;
        }
        Validator validator = this.validatorFactory.getValidator();
        String currentProperty = beanValidationContext.getCurrentProperty();
        if (currentProperty == null) {
            return;
        }
        ValidationInfo validationInfo = BeanFieldValidator.getValidationInfo(beanValidationContext, currentProperty, validator);
        PropertyDescriptor propertyDescriptor = validationInfo.getPropertyDescriptor();
        if (propertyDescriptor == null) {
            return;
        }
        Set violations = validator.validateValue(validationInfo.getBeanType(), validationInfo.getPropertyName(), value, (Class[])this.beanValidationGroupSource.get());
        if (violations.isEmpty()) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        Iterator iterator = violations.iterator();
        while (iterator.hasNext()) {
            ConstraintViolation violation = (ConstraintViolation)iterator.next();
            builder.append(String.format("%s %s", this.field.getLabel(), violation.getMessage()));
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        throw new ValidationException(builder.toString());
    }

    private static final Class<?> getConstrainedPropertyClass(BeanDescriptor beanDescriptor, String propertyName) {
        Class clasz = null;
        for (PropertyDescriptor descriptor : beanDescriptor.getConstrainedProperties()) {
            if (!descriptor.getPropertyName().equals(propertyName)) continue;
            clasz = descriptor.getElementClass();
            break;
        }
        return clasz;
    }

    private String interpolateMessage(final ConstraintDescriptor<?> descriptor) {
        String messageTemplate = (String)descriptor.getAttributes().get("message");
        MessageInterpolator messageInterpolator = this.validatorFactory.getMessageInterpolator();
        return messageInterpolator.interpolate(messageTemplate, new MessageInterpolator.Context(){

            public ConstraintDescriptor<?> getConstraintDescriptor() {
                return descriptor;
            }

            public Object getValidatedValue() {
                return null;
            }
        });
    }

    private static final ValidationInfo getValidationInfo(BeanValidationContext beanValidationContext, String currentProperty, Validator validator) {
        Class<?> beanType = beanValidationContext.getBeanType();
        String[] path = currentProperty.split("\\.");
        BeanDescriptor beanDescriptor = validator.getConstraintsForClass((Class)beanType);
        for (int i = 1; i < path.length - 1; ++i) {
            Class<?> constrainedPropertyClass = BeanFieldValidator.getConstrainedPropertyClass(beanDescriptor, path[i]);
            if (constrainedPropertyClass == null) continue;
            beanType = constrainedPropertyClass;
            beanDescriptor = validator.getConstraintsForClass(beanType);
        }
        String propertyName = path[path.length - 1];
        PropertyDescriptor propertyDescriptor = beanDescriptor.getConstraintsForProperty(propertyName);
        return new ValidationInfo(beanType, propertyName, propertyDescriptor);
    }

    private static final class ValidationInfo {
        private final Class<?> beanType;
        private final String propertyName;
        private final PropertyDescriptor propertyDescriptor;

        public ValidationInfo(Class<?> beanType, String propertyName, PropertyDescriptor propertyDescriptor) {
            this.beanType = beanType;
            this.propertyName = propertyName;
            this.propertyDescriptor = propertyDescriptor;
        }

        public Class<?> getBeanType() {
            return this.beanType;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public PropertyDescriptor getPropertyDescriptor() {
            return this.propertyDescriptor;
        }
    }
}

