/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.hibernate;

import java.io.Serializable;
import org.apache.tapestry5.internal.hibernate.PersistedEntity;
import org.apache.tapestry5.internal.hibernate.PersistedTransientEntity;
import org.apache.tapestry5.internal.hibernate.SessionRestorable;
import org.apache.tapestry5.internal.services.AbstractSessionPersistentFieldStrategy;
import org.apache.tapestry5.services.Request;
import org.hibernate.HibernateException;
import org.hibernate.Session;

public class EntityPersistentFieldStrategy
extends AbstractSessionPersistentFieldStrategy {
    private final Session session;

    public EntityPersistentFieldStrategy(Session session, Request request) {
        super("entity:", request);
        this.session = session;
    }

    protected Object convertApplicationValueToPersisted(Object newValue) {
        assert (newValue != null);
        if (!this.session.contains(newValue)) {
            return new PersistedTransientEntity(newValue);
        }
        try {
            String entityName = this.session.getEntityName(newValue);
            Serializable id = this.session.getIdentifier(newValue);
            return new PersistedEntity(entityName, id);
        }
        catch (HibernateException ex) {
            throw new IllegalArgumentException(String.format("Failed persisting an entity in the session. entity: %s", newValue), ex);
        }
    }

    protected Object convertPersistedToApplicationValue(Object persistedValue) {
        assert (persistedValue != null);
        SessionRestorable persisted = (SessionRestorable)persistedValue;
        return persisted.restoreWithSession(this.session);
    }
}

