/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.plastic;

import org.apache.tapestry5.internal.plastic.ClassLoaderDelegate;

public class PlasticClassLoader
extends ClassLoader {
    private final ClassLoaderDelegate delegate;

    public PlasticClassLoader(ClassLoader parent, ClassLoaderDelegate delegate) {
        super(parent);
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> loadedClass = this.findLoadedClass(name);
            if (loadedClass != null) {
                return loadedClass;
            }
            if (this.delegate.shouldInterceptClassLoading(name)) {
                Class<?> c = this.delegate.loadAndTransformClass(name);
                if (resolve) {
                    this.resolveClass(c);
                }
                return c;
            }
            return super.loadClass(name, resolve);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Class<?> defineClassWithBytecode(String className, byte[] bytecode) {
        Object object = this.getClassLoadingLock(className);
        synchronized (object) {
            return this.defineClass(className, bytecode, 0, bytecode.length);
        }
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

