# -------------------------------------------------------------
#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
#
# -------------------------------------------------------------

# Autogenerated By   : src/main/python/generator/generator.py
# Autogenerated From : scripts/builtin/hyperband.dml

from typing import Dict, Iterable

from systemds.operator import OperationNode, Matrix, Frame, List, MultiReturn, Scalar
from systemds.script_building.dag import OutputType
from systemds.utils.consts import VALID_INPUT_TYPES


def hyperband(X_train: Matrix,
              y_train: Matrix,
              X_val: Matrix,
              y_val: Matrix,
              params: List,
              paramRanges: Matrix,
              **kwargs: Dict[str, VALID_INPUT_TYPES]):
    """
     The hyperband-function is used for hyper parameter optimization and is based on multi-armed bandits and early
     elimination. Through multiple parallel brackets and consecutive trials it will return the hyper parameter combination
     which performed best on a validation dataset. A set of hyper parameter combinations is drawn from uniform distributions
     with given ranges; Those make up the candidates for hyperband. Notes:
     hyperband is hard-coded for lmCG, and uses lmPredict for validation
     hyperband is hard-coded to use the number of iterations as a resource
     hyperband can only optimize continuous hyperparameters
    
    
    
    :param X_train: Input Matrix of training vectors
    :param y_train: Labels for training vectors
    :param X_val: Input Matrix of validation vectors
    :param y_val: Labels for validation vectors
    :param params: List of parameters to optimize
    :param paramRanges: The min and max values for the uniform distributions to draw from.
        One row per hyper parameter, first column specifies min, second column max value.
    :param R: Controls number of candidates evaluated
    :param eta: Determines fraction of candidates to keep after each trial
    :param verbose: If TRUE print messages are activated
    :return: 1-column matrix of weights of best performing candidate
    :return: hyper parameters of best performing candidate
    """

    params_dict = {'X_train': X_train, 'y_train': y_train, 'X_val': X_val, 'y_val': y_val, 'params': params, 'paramRanges': paramRanges}
    params_dict.update(kwargs)
    
    vX_0 = Matrix(X_train.sds_context, '')
    vX_1 = Frame(X_train.sds_context, '')
    output_nodes = [vX_0, vX_1, ]

    op = MultiReturn(X_train.sds_context, 'hyperband', output_nodes, named_input_nodes=params_dict)

    vX_0._unnamed_input_nodes = [op]
    vX_1._unnamed_input_nodes = [op]

    return op
