/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.lib;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.sysds.runtime.compress.CompressedMatrixBlock;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.ColGroupConst;
import org.apache.sysds.runtime.compress.colgroup.ColGroupEmpty;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDC;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCSingle;
import org.apache.sysds.runtime.compress.colgroup.dictionary.Dictionary;

public final class CLALibUtils {
    protected static boolean containsSDC(List<AColGroup> groups) {
        for (AColGroup g : groups) {
            if (!(g instanceof ColGroupSDC) && !(g instanceof ColGroupSDCSingle)) continue;
            return true;
        }
        return false;
    }

    protected static boolean containsSDCOrConst(List<AColGroup> groups) {
        for (AColGroup g : groups) {
            if (!(g instanceof ColGroupSDC) && !(g instanceof ColGroupSDCSingle) && !(g instanceof ColGroupConst)) continue;
            return true;
        }
        return false;
    }

    protected static List<AColGroup> filterSDCGroups(List<AColGroup> groups, double[] constV) {
        if (constV != null) {
            ArrayList<AColGroup> filteredGroups = new ArrayList<AColGroup>();
            for (AColGroup g : groups) {
                if (g instanceof ColGroupSDC) {
                    filteredGroups.add(((ColGroupSDC)g).extractCommon(constV));
                    continue;
                }
                if (g instanceof ColGroupSDCSingle) {
                    filteredGroups.add(((ColGroupSDCSingle)g).extractCommon(constV));
                    continue;
                }
                filteredGroups.add(g);
            }
            return CLALibUtils.returnGroupIfFiniteNumbers(groups, filteredGroups, constV);
        }
        return groups;
    }

    protected static List<AColGroup> filterGroups(List<AColGroup> groups, double[] constV) {
        if (constV != null) {
            ArrayList<AColGroup> filteredGroups = new ArrayList<AColGroup>();
            for (AColGroup g : groups) {
                if (g instanceof ColGroupSDC) {
                    filteredGroups.add(((ColGroupSDC)g).extractCommon(constV));
                    continue;
                }
                if (g instanceof ColGroupSDCSingle) {
                    filteredGroups.add(((ColGroupSDCSingle)g).extractCommon(constV));
                    continue;
                }
                if (g instanceof ColGroupEmpty) continue;
                if (g instanceof ColGroupConst) {
                    ((ColGroupConst)g).addToCommon(constV);
                    continue;
                }
                filteredGroups.add(g);
            }
            return CLALibUtils.returnGroupIfFiniteNumbers(groups, filteredGroups, constV);
        }
        return groups;
    }

    private static List<AColGroup> returnGroupIfFiniteNumbers(List<AColGroup> groups, List<AColGroup> filteredGroups, double[] constV) {
        for (double v : constV) {
            if (Double.isFinite(v)) continue;
            return groups;
        }
        return filteredGroups;
    }

    public static void combineConstColumns(CompressedMatrixBlock in) {
        ArrayList<AColGroup> e = new ArrayList<AColGroup>();
        ArrayList<AColGroup> c = new ArrayList<AColGroup>();
        ArrayList<AColGroup> o = new ArrayList<AColGroup>();
        for (AColGroup g : in.getColGroups()) {
            if (g instanceof ColGroupEmpty) {
                e.add(g);
                continue;
            }
            if (g instanceof ColGroupConst) {
                c.add(g);
                continue;
            }
            o.add(g);
        }
        if (e.size() < 1 && c.size() < 1) {
            return;
        }
        if (e.size() == 1) {
            o.add((AColGroup)e.get(0));
        } else if (e.size() > 1) {
            o.add(CLALibUtils.combineEmpty(e));
        }
        if (c.size() == 1) {
            o.add((AColGroup)c.get(0));
        } else if (c.size() > 1) {
            o.add(CLALibUtils.combineConst(c));
        }
        in.allocateColGroupList(o);
    }

    private static AColGroup combineEmpty(List<AColGroup> e) {
        return new ColGroupEmpty(CLALibUtils.combineColIndexes(e));
    }

    private static AColGroup combineConst(List<AColGroup> c) {
        int[] resCols = CLALibUtils.combineColIndexes(c);
        double[] values = new double[resCols.length];
        for (AColGroup g : c) {
            ColGroupConst cg = (ColGroupConst)g;
            int[] colIdx = cg.getColIndices();
            double[] colVals = cg.getValues();
            for (int i = 0; i < colIdx.length; ++i) {
                int outId = Arrays.binarySearch(resCols, colIdx[i]);
                values[outId] = colVals[i];
            }
        }
        Dictionary dict = new Dictionary(values);
        return new ColGroupConst(resCols, dict);
    }

    private static int[] combineColIndexes(List<AColGroup> gs) {
        int numCols = 0;
        for (AColGroup g : gs) {
            numCols += g.getNumCols();
        }
        int[] resCols = new int[numCols];
        int index = 0;
        for (AColGroup g : gs) {
            for (int c : g.getColIndices()) {
                resCols[index++] = c;
            }
        }
        Arrays.sort(resCols);
        return resCols;
    }
}

