/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.spark;

import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.storage.StorageLevel;
import org.apache.sysds.common.Types;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.hops.recompile.Recompiler;
import org.apache.sysds.lops.Checkpoint;
import org.apache.sysds.runtime.controlprogram.caching.CacheableData;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.BooleanObject;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.spark.SPInstruction;
import org.apache.sysds.runtime.instructions.spark.UnarySPInstruction;
import org.apache.sysds.runtime.instructions.spark.data.RDDObject;
import org.apache.sysds.runtime.instructions.spark.functions.CopyFrameBlockFunction;
import org.apache.sysds.runtime.instructions.spark.functions.CreateSparseBlockFunction;
import org.apache.sysds.runtime.instructions.spark.utils.SparkUtils;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.MatrixIndexes;
import org.apache.sysds.runtime.matrix.operators.Operator;
import org.apache.sysds.runtime.meta.DataCharacteristics;
import org.apache.sysds.runtime.util.UtilFunctions;
import org.apache.sysds.utils.Statistics;

public class CheckpointSPInstruction
extends UnarySPInstruction {
    private StorageLevel _level = null;

    private CheckpointSPInstruction(Operator op, CPOperand in, CPOperand out, StorageLevel level, String opcode, String istr) {
        super(SPInstruction.SPType.Checkpoint, op, in, out, opcode, istr);
        this._level = level;
    }

    public static CheckpointSPInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        InstructionUtils.checkNumFields(parts, 3);
        String opcode = parts[0];
        CPOperand in = new CPOperand(parts[1]);
        CPOperand out = new CPOperand(parts[2]);
        StorageLevel level = StorageLevel.fromString((String)parts[3]);
        return new CheckpointSPInstruction(null, in, out, level, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        SparkExecutionContext sec = (SparkExecutionContext)ec;
        if (sec.getVariable(this.input1.getName()) == null || sec.getVariable(this.input1.getName()) instanceof BooleanObject) {
            sec.setVariable(this.input1.getName(), new BooleanObject(false));
            sec.setVariable(this.output.getName(), new BooleanObject(false));
            return;
        }
        CacheableData<?> obj = sec.getCacheableData(this.input1.getName());
        DataCharacteristics mcIn = sec.getDataCharacteristics(this.input1.getName());
        if (obj.isCached(true) || Recompiler.checkCPCheckpoint(mcIn) || sec.getCacheableData(this.input1.getName()) instanceof MatrixObject && sec.getMatrixObject(this.input1.getName()).isFederated()) {
            sec.setVariable(this.output.getName(), obj);
            Statistics.decrementNoOfExecutedSPInst();
            return;
        }
        JavaPairRDD in = sec.getRDDHandleForVariable(this.input1.getName(), Types.FileFormat.BINARY, -1, true);
        JavaPairRDD out = null;
        if (!in.getStorageLevel().equals((Object)this._level)) {
            boolean mcsr2csr;
            int numPartitions = SparkUtils.getNumPreferredPartitions(mcIn, in);
            boolean coalesce = 1.4 * (double)numPartitions < (double)in.getNumPartitions() && !SparkUtils.isHashPartitioned(in) && in.getNumPartitions() > SparkExecutionContext.getDefaultParallelism(true);
            boolean repartition = mcIn.dimsKnown(true) && mcIn.isUltraSparse() && (double)numPartitions > 1.4 * (double)in.getNumPartitions();
            boolean bl = mcsr2csr = this.input1.getDataType() == Types.DataType.MATRIX && OptimizerUtils.checkSparseBlockCSRConversion(mcIn) && !this._level.equals((Object)Checkpoint.SER_STORAGE_LEVEL);
            if (coalesce) {
                out = in.coalesce(numPartitions);
            } else if (repartition) {
                out = in.repartition(UtilFunctions.roundToNext(numPartitions, SparkExecutionContext.getDefaultParallelism(true)));
            } else if (!mcsr2csr) {
                if (this.input1.getDataType() == Types.DataType.MATRIX) {
                    out = SparkUtils.copyBinaryBlockMatrix((JavaPairRDD<MatrixIndexes, MatrixBlock>)in, false);
                } else if (this.input1.getDataType() == Types.DataType.FRAME) {
                    out = in.mapValues((Function)new CopyFrameBlockFunction(false));
                }
            } else {
                out = in;
            }
            if (mcsr2csr) {
                out = out.mapValues((Function)new CreateSparseBlockFunction(SparseBlock.Type.CSR));
            }
            out = out.persist(this._level);
            if (this.input1.isMatrix() && mcIn.dimsKnown() && !mcIn.dimsKnown(true)) {
                mcIn.setNonZeros(SparkUtils.getNonZeros((JavaPairRDD<MatrixIndexes, MatrixBlock>)out));
            }
        } else {
            out = in;
        }
        CacheableData<?> cd = sec.getCacheableData(this.input1.getName());
        if (out != in) {
            RDDObject inro = cd.getRDDHandle();
            RDDObject outro = new RDDObject(out);
            outro.setCheckpointRDD(true);
            outro.addLineageChild(inro);
            cd.setRDDHandle(outro);
        }
        sec.setVariable(this.output.getName(), cd);
    }
}

