/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.lang.NotImplementedException;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.ColGroupCompressed;
import org.apache.sysds.runtime.compress.colgroup.ColGroupDDC;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCSingle;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCSingleZeros;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCZeros;
import org.apache.sysds.runtime.compress.colgroup.ColGroupValue;
import org.apache.sysds.runtime.compress.colgroup.dictionary.ADictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.Dictionary;
import org.apache.sysds.runtime.compress.colgroup.mapping.AMapToData;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToFactory;
import org.apache.sysds.runtime.compress.colgroup.offset.AIterator;
import org.apache.sysds.runtime.compress.colgroup.offset.AOffset;
import org.apache.sysds.runtime.compress.colgroup.offset.OffsetFactory;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.ScalarOperator;

public class ColGroupSDC
extends ColGroupValue {
    private static final long serialVersionUID = -12043916423465004L;
    protected AOffset _indexes;
    protected AMapToData _data;

    protected ColGroupSDC(int numRows) {
        super(numRows);
    }

    protected ColGroupSDC(int[] colIndices, int numRows, ADictionary dict, int[] indexes, AMapToData data, int[] cachedCounts) {
        super(colIndices, numRows, dict, cachedCounts);
        this._indexes = OffsetFactory.create(indexes, numRows);
        this._data = data;
        this._zeros = false;
    }

    protected ColGroupSDC(int[] colIndices, int numRows, ADictionary dict, AOffset offsets, AMapToData data, int[] cachedCounts) {
        super(colIndices, numRows, dict, cachedCounts);
        this._indexes = offsets;
        this._data = data;
        this._zeros = false;
    }

    @Override
    public AColGroup.CompressionType getCompType() {
        return AColGroup.CompressionType.SDC;
    }

    @Override
    public AColGroup.ColGroupType getColGroupType() {
        return AColGroup.ColGroupType.SDC;
    }

    @Override
    protected void decompressToBlockUnSafeDenseDictionary(MatrixBlock target, int rl, int ru, int offT, double[] values) {
        int j;
        int nCol = this._colIndexes.length;
        int tCol = target.getNumColumns();
        int offsetToDefault = values.length - nCol;
        double[] c = target.getDenseBlockValues();
        offT *= tCol;
        int i = rl;
        AIterator it = this._indexes.getIterator(rl);
        while (i < ru && it.hasNext()) {
            if (it.value() == i) {
                int offset = this._data.getIndex(it.getDataIndexAndIncrement()) * nCol;
                for (int j2 = 0; j2 < nCol; ++j2) {
                    int n = offT + this._colIndexes[j2];
                    c[n] = c[n] + values[offset + j2];
                }
            } else {
                for (j = 0; j < nCol; ++j) {
                    int n = offT + this._colIndexes[j];
                    c[n] = c[n] + values[offsetToDefault + j];
                }
            }
            ++i;
            offT += tCol;
        }
        while (i < ru) {
            for (j = 0; j < nCol; ++j) {
                int n = offT + this._colIndexes[j];
                c[n] = c[n] + values[offsetToDefault + j];
            }
            ++i;
            offT += tCol;
        }
    }

    @Override
    protected void decompressToBlockUnSafeSparseDictionary(MatrixBlock target, int rl, int ru, int offT, SparseBlock sb) {
        int j;
        int tCol = target.getNumColumns();
        int offsetToDefault = sb.numRows() - 1;
        if (sb.isEmpty(offsetToDefault)) {
            throw new NotImplementedException("Implement a SDCZeros decompress if this is the case");
        }
        int defApos = sb.pos(offsetToDefault);
        int defAlen = sb.size(offsetToDefault) + defApos;
        double[] defAvals = sb.values(offsetToDefault);
        int[] defAix = sb.indexes(offsetToDefault);
        double[] c = target.getDenseBlockValues();
        offT *= tCol;
        int i = rl;
        AIterator it = this._indexes.getIterator(rl);
        while (i < ru && it.hasNext()) {
            if (it.value() == i) {
                int dictIndex = this._data.getIndex(it.getDataIndexAndIncrement());
                if (!sb.isEmpty(dictIndex)) {
                    int apos = sb.pos(dictIndex);
                    int alen = sb.size(dictIndex) + apos;
                    double[] avals = sb.values(dictIndex);
                    int[] aix = sb.indexes(dictIndex);
                    for (int j2 = apos; j2 < alen; ++j2) {
                        int n = offT + this._colIndexes[aix[j2]];
                        c[n] = c[n] + avals[j2];
                    }
                }
            } else {
                for (j = defApos; j < defAlen; ++j) {
                    int n = offT + this._colIndexes[defAix[j]];
                    c[n] = c[n] + defAvals[j];
                }
            }
            ++i;
            offT += tCol;
        }
        while (i < ru) {
            for (j = defApos; j < defAlen; ++j) {
                int n = offT + this._colIndexes[defAix[j]];
                c[n] = c[n] + defAvals[j];
            }
            ++i;
            offT += tCol;
        }
    }

    @Override
    public double get(int r, int c) {
        int ix = Arrays.binarySearch(this._colIndexes, c);
        if (ix < 0) {
            throw new RuntimeException("Column index " + c + " not in group.");
        }
        AIterator it = this._indexes.getIterator(r);
        int nCol = this._colIndexes.length;
        if (it.value() == r) {
            return this._dict.getValue(this._data.getIndex(it.getDataIndex()) * nCol + ix);
        }
        return this._dict.getValue(this.getNumValues() * nCol - nCol + ix);
    }

    @Override
    public void countNonZerosPerRow(int[] rnnz, int rl, int ru) {
        throw new NotImplementedException("Not Implemented");
    }

    @Override
    protected void computeRowSums(double[] c, boolean square, int rl, int ru) {
        int rix;
        int numVals = this.getNumValues();
        double[] vals = this._dict.sumAllRowsToDouble(square, this._colIndexes.length);
        AIterator it = this._indexes.getIterator(rl);
        for (rix = rl; rix < ru && it.hasNext(); ++rix) {
            if (it.value() != rix) {
                int n = rix;
                c[n] = c[n] + vals[numVals - 1];
                continue;
            }
            int n = rix;
            c[n] = c[n] + vals[this._data.getIndex(it.getDataIndexAndIncrement())];
        }
        while (rix < ru) {
            int n = rix++;
            c[n] = c[n] + vals[numVals - 1];
        }
    }

    @Override
    protected void computeRowMxx(double[] c, Builtin builtin, int rl, int ru) {
        int rix;
        int numVals = this.getNumValues();
        double[] vals = this._dict.aggregateTuples(builtin, this._colIndexes.length);
        AIterator it = this._indexes.getIterator(rl);
        for (rix = rl; rix < ru && it.hasNext(); ++rix) {
            c[rix] = it.value() != rix ? builtin.execute(c[rix], vals[numVals - 1]) : builtin.execute(c[rix], vals[this._data.getIndex(it.getDataIndexAndIncrement())]);
        }
        while (rix < ru) {
            c[rix] = builtin.execute(c[rix], vals[numVals - 1]);
            ++rix;
        }
    }

    @Override
    public int[] getCounts(int[] counts) {
        return this.getCounts(0, this._numRows, counts);
    }

    @Override
    public int[] getCounts(int rl, int ru, int[] counts) {
        int i;
        int def = counts.length - 1;
        AIterator it = this._indexes.getIterator(rl);
        for (i = rl; i < ru && it.hasNext(); ++i) {
            if (i == it.value()) {
                int n = this._data.getIndex(it.getDataIndexAndIncrement());
                counts[n] = counts[n] + 1;
                continue;
            }
            int n = def;
            counts[n] = counts[n] + 1;
        }
        if (i < ru) {
            int n = def;
            counts[n] = counts[n] + (ru - i);
        }
        return counts;
    }

    public int getIndex(int r) {
        return this._data.getIndex(r);
    }

    @Override
    public void preAggregate(MatrixBlock m, MatrixBlock preAgg, int rl, int ru) {
        if (m.isInSparseFormat()) {
            this.preAggregateSparse(m.getSparseBlock(), preAgg, rl, ru);
        } else {
            this.preAggregateDense(m, preAgg, rl, ru);
        }
    }

    private void preAggregateDense(MatrixBlock m, MatrixBlock preAgg, int rl, int ru) {
        double[] preAV = preAgg.getDenseBlockValues();
        double[] mV = m.getDenseBlockValues();
        int numVals = this.getNumValues();
        int rowLeft = rl;
        int offOut = 0;
        while (rowLeft < ru) {
            int def = offOut + numVals - 1;
            AIterator it = this._indexes.getIterator();
            int rc = 0;
            int offLeft = rowLeft * this._numRows;
            while (rc < this._numRows && it.hasNext()) {
                if (it.value() == rc) {
                    int n = offOut + this._data.getIndex(it.getDataIndexAndIncrement());
                    preAV[n] = preAV[n] + mV[offLeft];
                } else {
                    int n = def;
                    preAV[n] = preAV[n] + mV[offLeft];
                }
                ++rc;
                ++offLeft;
            }
            while (rc < this._numRows) {
                int n = def;
                preAV[n] = preAV[n] + mV[offLeft];
                ++rc;
                ++offLeft;
            }
            ++rowLeft;
            offOut += numVals;
        }
    }

    private void preAggregateSparse(SparseBlock sb, MatrixBlock preAgg, int rl, int ru) {
        double[] preAV = preAgg.getDenseBlockValues();
        int numVals = this.getNumValues();
        int rowLeft = rl;
        int offOut = 0;
        while (rowLeft < ru) {
            if (!sb.isEmpty(rowLeft)) {
                int j;
                AIterator it = this._indexes.getIterator();
                int def = offOut + numVals - 1;
                int apos = sb.pos(rowLeft);
                int alen = sb.size(rowLeft) + apos;
                int[] aix = sb.indexes(rowLeft);
                double[] avals = sb.values(rowLeft);
                for (j = apos; j < alen && it.hasNext(); ++j) {
                    int index = aix[j];
                    it.skipTo(index);
                    if (it.value() == index) {
                        int n = offOut + this._data.getIndex(it.getDataIndexAndIncrement());
                        preAV[n] = preAV[n] + avals[j];
                        continue;
                    }
                    int n = def;
                    preAV[n] = preAV[n] + avals[j];
                }
                while (j < alen) {
                    int n = def;
                    preAV[n] = preAV[n] + avals[j];
                    ++j;
                }
            }
            ++rowLeft;
            offOut += numVals;
        }
    }

    @Override
    public long estimateInMemorySize() {
        long size = super.estimateInMemorySize();
        size += this._indexes.getInMemorySize();
        return size += this._data.getInMemorySize();
    }

    @Override
    public AColGroup scalarOperation(ScalarOperator op) {
        return new ColGroupSDC(this._colIndexes, this._numRows, this.applyScalarOp(op), this._indexes, this._data, this.getCachedCounts());
    }

    @Override
    public AColGroup binaryRowOp(BinaryOperator op, double[] v, boolean sparseSafe, boolean left) {
        return new ColGroupSDC(this._colIndexes, this._numRows, this.applyBinaryRowOp(op, v, true, left), this._indexes, this._data, this.getCachedCounts());
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        this._indexes.write(out);
        this._data.write(out);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this._indexes = OffsetFactory.readIn(in);
        this._data = MapToFactory.readIn(in);
    }

    @Override
    public long getExactSizeOnDisk() {
        long ret = super.getExactSizeOnDisk();
        ret += this._data.getExactSizeOnDisk();
        return ret += this._indexes.getExactSizeOnDisk();
    }

    @Override
    public boolean sameIndexStructure(ColGroupCompressed that) {
        return that instanceof ColGroupSDC && ((ColGroupSDC)that)._indexes == this._indexes && ((ColGroupSDC)that)._data == this._data;
    }

    @Override
    public int getIndexStructureHash() {
        return this._data.hashCode() + this._indexes.hashCode();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(String.format("\n%15s ", "Indexes: "));
        sb.append(this._indexes.toString());
        sb.append(String.format("\n%15s ", "Data: "));
        sb.append(this._data.toString());
        return sb.toString();
    }

    @Override
    public Dictionary preAggregateThatDDCStructure(ColGroupDDC that, Dictionary ret) {
        int i;
        AIterator it = this._indexes.getIterator();
        int offsetToDefault = this.getNumValues() - 1;
        int nCol = that._colIndexes.length;
        for (i = 0; i < this._numRows && it.hasNext(); ++i) {
            int to = it.value() == i ? this.getIndex(it.getDataIndexAndIncrement()) : offsetToDefault;
            that._dict.addToEntry(ret, that._data.getIndex(i), to, nCol);
        }
        while (i < this._numRows) {
            that._dict.addToEntry(ret, that._data.getIndex(i), offsetToDefault, nCol);
            ++i;
        }
        return ret;
    }

    @Override
    public Dictionary preAggregateThatSDCStructure(ColGroupSDC that, Dictionary ret, boolean preModified) {
        AIterator itThat = that._indexes.getIterator();
        AIterator itThis = this._indexes.getIterator();
        int nCol = that._colIndexes.length;
        int offsetToDefaultThat = that.getNumValues() - 1;
        int offsetToDefaultThis = this.getNumValues() - 1;
        if (preModified) {
            int fr;
            while (itThat.hasNext() && itThis.hasNext()) {
                if (itThat.value() == itThis.value()) {
                    fr = that.getIndex(itThat.getDataIndexAndIncrement());
                    int to = this.getIndex(itThis.getDataIndexAndIncrement());
                    that._dict.addToEntry(ret, fr, to, nCol);
                    continue;
                }
                if (itThat.value() < itThis.value()) {
                    fr = that.getIndex(itThat.getDataIndexAndIncrement());
                    that._dict.addToEntry(ret, fr, offsetToDefaultThis, nCol);
                    continue;
                }
                itThis.next();
            }
            while (itThat.hasNext()) {
                fr = that.getIndex(itThat.getDataIndexAndIncrement());
                that._dict.addToEntry(ret, fr, offsetToDefaultThis, nCol);
            }
        } else {
            int to;
            int i;
            for (i = 0; i < this._numRows && itThat.hasNext() && itThis.hasNext(); ++i) {
                to = itThis.value() == i ? this.getIndex(itThis.getDataIndexAndIncrement()) : offsetToDefaultThis;
                int fr = itThat.value() == i ? that.getIndex(itThat.getDataIndexAndIncrement()) : offsetToDefaultThat;
                that._dict.addToEntry(ret, fr, to, nCol);
            }
            if (itThat.hasNext()) {
                while (i < this._numRows && itThat.hasNext()) {
                    int fr = itThat.value() == i ? that.getIndex(itThat.getDataIndexAndIncrement()) : offsetToDefaultThat;
                    that._dict.addToEntry(ret, fr, offsetToDefaultThis, nCol);
                    ++i;
                }
            }
            if (itThis.hasNext()) {
                while (i < this._numRows && itThis.hasNext()) {
                    to = itThis.value() == i ? this.getIndex(itThis.getDataIndexAndIncrement()) : offsetToDefaultThis;
                    that._dict.addToEntry(ret, offsetToDefaultThat, to, nCol);
                    ++i;
                }
            }
            while (i < this._numRows) {
                that._dict.addToEntry(ret, offsetToDefaultThat, offsetToDefaultThis, nCol);
                ++i;
            }
        }
        return ret;
    }

    @Override
    public Dictionary preAggregateThatSDCZerosStructure(ColGroupSDCZeros that, Dictionary ret) {
        int fr;
        AIterator itThat = that._indexes.getIterator();
        AIterator itThis = this._indexes.getIterator();
        int nCol = that._colIndexes.length;
        int defThis = this.getNumValues() * nCol - nCol;
        while (itThat.hasNext() && itThis.hasNext()) {
            if (itThat.value() == itThis.value()) {
                fr = that.getIndex(itThat.getDataIndexAndIncrement());
                int to = this.getIndex(itThis.getDataIndexAndIncrement());
                that._dict.addToEntry(ret, fr, to, nCol);
                continue;
            }
            if (itThat.value() < itThis.value()) {
                fr = that.getIndex(itThat.getDataIndexAndIncrement());
                that._dict.addToEntry(ret, fr, defThis, nCol);
                continue;
            }
            itThis.next();
        }
        while (itThat.hasNext()) {
            fr = that.getIndex(itThat.getDataIndexAndIncrement());
            that._dict.addToEntry(ret, fr, defThis, nCol);
        }
        return ret;
    }

    @Override
    public Dictionary preAggregateThatSDCSingleZerosStructure(ColGroupSDCSingleZeros that, Dictionary ret) {
        throw new NotImplementedException();
    }

    @Override
    public Dictionary preAggregateThatSDCSingleStructure(ColGroupSDCSingle that, Dictionary ret, boolean preModified) {
        AIterator itThat = that._indexes.getIterator();
        AIterator itThis = this._indexes.getIterator();
        int nCol = that._colIndexes.length;
        int defThis = this.getNumValues() * nCol - nCol;
        if (preModified) {
            while (itThat.hasNext() && itThis.hasNext()) {
                if (itThat.value() == itThis.value()) {
                    itThat.next();
                    int to = this.getIndex(itThis.getDataIndexAndIncrement());
                    that._dict.addToEntry(ret, 0, to, nCol);
                    continue;
                }
                if (itThat.value() < itThis.value()) {
                    itThat.next();
                    that._dict.addToEntry(ret, 0, defThis, nCol);
                    continue;
                }
                itThis.next();
            }
        } else {
            throw new NotImplementedException();
        }
        return ret;
    }
}

