/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.scripts.nn.layers;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.sysml.api.mlcontext.MLResults;
import org.apache.sysml.api.mlcontext.Matrix;
import org.apache.sysml.api.mlcontext.Script;

public class Cross_entropy_loss2d
extends Script {
    public Cross_entropy_loss2d() {
        String string = "scripts/nn/layers/cross_entropy_loss2d.dml";
        InputStream inputStream = Script.class.getResourceAsStream(new StringBuffer().append("/").append(string).toString());
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        char[] cArray = new char[1024];
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n;
            while ((n = inputStreamReader.read(cArray)) > 0) {
                stringBuilder.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.setScriptString(stringBuilder.toString());
    }

    public double forward(Object object, Object object2, Object object3) {
        String string = "source('scripts/nn/layers/cross_entropy_loss2d.dml') as mlcontextns;loss = mlcontextns::forward(pred, y, C);";
        Script script = new Script(string);
        script.in("pred", object).in("y", object2).in("C", object3).out("loss");
        MLResults mLResults = script.execute();
        double d = mLResults.getDouble("loss");
        return d;
    }

    public String forward__docs() {
        String string = "forward = function(matrix[double] pred, matrix[double] y, int C)\n    return (double loss) {\n  /*\n   * Computes the forward pass for a 2D cross-entropy loss function. The\n   * inputs consist of N examples, each of shape (C, Hin, Win), where\n   * each pixel has C dimensions corresponding to normalized\n   * probabilities of C classes. The loss is applied to each pixel\n   * location, and then averaged over all pixels and all examples.\n   *\n   *   ```\n   *   L_ijk = -y_ijk^T * log(pred_ijk)\n   *   L = (1/N*H*W) sum(L_ijk) for i=1 to N, j=1 to H, k=1 to W.\n   *   ```\n   *\n   * In these equations, `L` is the total loss, `L_ijk` is the loss for\n   * the pixel `j, k` in the example 'i', `y_ijk` is the C-dimensional\n   * vector of target class probabilities, `pred_ijk` is C-dimensional\n   * vector of predicted class probabilities, and `N` is the number of\n   * examples.\n   *\n   * For each pixel location, this can be interpreted as the negative\n   * log-likelihood assuming a Bernoulli distribution generalized to C\n   * dimensions, or a Multinomial with one observation.\n   *\n   * Inputs:\n   *  - pred: Predictions, of shape (N, C*Win*Hin).\n   *  - y: Targets, of shape (N, C*Win*Hin).\n   *  - C: Number of input channels (dimensionality of input depth).\n   *\n   * Outputs:\n   *  - loss: Average loss.\n   */\n";
        return string;
    }

    public String forward__source() {
        String string = "forward = function(matrix[double] pred, matrix[double] y, int C)\n    return (double loss) {\n  /*\n   * Computes the forward pass for a 2D cross-entropy loss function. The\n   * inputs consist of N examples, each of shape (C, Hin, Win), where\n   * each pixel has C dimensions corresponding to normalized\n   * probabilities of C classes. The loss is applied to each pixel\n   * location, and then averaged over all pixels and all examples.\n   *\n   *   ```\n   *   L_ijk = -y_ijk^T * log(pred_ijk)\n   *   L = (1/N*H*W) sum(L_ijk) for i=1 to N, j=1 to H, k=1 to W.\n   *   ```\n   *\n   * In these equations, `L` is the total loss, `L_ijk` is the loss for\n   * the pixel `j, k` in the example 'i', `y_ijk` is the C-dimensional\n   * vector of target class probabilities, `pred_ijk` is C-dimensional\n   * vector of predicted class probabilities, and `N` is the number of\n   * examples.\n   *\n   * For each pixel location, this can be interpreted as the negative\n   * log-likelihood assuming a Bernoulli distribution generalized to C\n   * dimensions, or a Multinomial with one observation.\n   *\n   * Inputs:\n   *  - pred: Predictions, of shape (N, C*Win*Hin).\n   *  - y: Targets, of shape (N, C*Win*Hin).\n   *  - C: Number of input channels (dimensionality of input depth).\n   *\n   * Outputs:\n   *  - loss: Average loss.\n   */\n  N = nrow(y)\n\n  #Transpose the matrix from (N, C*H*W) to (N*H*W, C)\n  pred_C_NHW = util::transpose_NCHW_to_CNHW(pred, C)\n  pred_NHW_C = t(pred_C_NHW)\n\n  #Transpose the matrix from (N, C*H*W) to (N*H*W, C)\n  y_C_NHW = util::transpose_NCHW_to_CNHW(y, C)\n  y_NHW_C = t(y_C_NHW)\n\n  loss = cross_entropy_loss::forward(pred_NHW_C, y_NHW_C)\n}\n";
        return string;
    }

    public Matrix backward(Object object, Object object2, Object object3) {
        String string = "source('scripts/nn/layers/cross_entropy_loss2d.dml') as mlcontextns;dpred = mlcontextns::backward(pred, y, C);";
        Script script = new Script(string);
        script.in("pred", object).in("y", object2).in("C", object3).out("dpred");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("dpred");
        return matrix;
    }

    public String backward__docs() {
        String string = "backward = function(matrix[double] pred, matrix[double] y, int C)\n    return (matrix[double] dpred) {\n  /*\n   * Computes the backward pass of a 2D cross-entropy loss function.  The\n   * inputs consist of N examples with a shape (Hin, Win), each pixel in\n   * the 2d-example with C dimensions corresponding to normalized\n   * probabilities of C classes.\n   *\n   * Inputs:\n   *  - pred: Predictions, of shape (N, C*Win*Hin).\n   *  - y: Targets, of shape (N, C*Win*Hin).\n   *  - C: Number of input channels (dimensionality of input depth).\n   *\n   * Outputs:\n   *  - dpred: Gradient wrt `pred`, of shape (N, C*Win*Hin).\n   */\n";
        return string;
    }

    public String backward__source() {
        String string = "backward = function(matrix[double] pred, matrix[double] y, int C)\n    return (matrix[double] dpred) {\n  /*\n   * Computes the backward pass of a 2D cross-entropy loss function.  The\n   * inputs consist of N examples with a shape (Hin, Win), each pixel in\n   * the 2d-example with C dimensions corresponding to normalized\n   * probabilities of C classes.\n   *\n   * Inputs:\n   *  - pred: Predictions, of shape (N, C*Win*Hin).\n   *  - y: Targets, of shape (N, C*Win*Hin).\n   *  - C: Number of input channels (dimensionality of input depth).\n   *\n   * Outputs:\n   *  - dpred: Gradient wrt `pred`, of shape (N, C*Win*Hin).\n   */\n  N = nrow(y)\n\n  #Transpose the matrix from (N, C*H*W) to (N*H*W, C)\n  pred_C_NHW = util::transpose_NCHW_to_CNHW(pred, C)\n  pred_NHW_C = t(pred_C_NHW)\n\n  #Transpose the matrix from (N, C*H*W) to (N*H*W, C)\n  y_C_NHW = util::transpose_NCHW_to_CNHW(y, C)\n  y_NHW_C = t(y_C_NHW)\n\n  dpred_NHW_C = cross_entropy_loss::backward(pred_NHW_C, y_NHW_C)\n\n  #Transpose the matrix from (N*H*W, C) to (N, C*H*W)\n  dpred_C_NHW = t(dpred_NHW_C)\n  dpred = util::transpose_NCHW_to_CNHW(dpred_C_NHW, N)\n}\n";
        return string;
    }
}

