/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.container.docker;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.storm.container.cgroup.core.MemoryCore;
import org.apache.storm.container.docker.DockerPsCommand;
import org.apache.storm.container.docker.DockerRmCommand;
import org.apache.storm.container.docker.DockerRunCommand;
import org.apache.storm.container.docker.DockerStopCommand;
import org.apache.storm.container.docker.DockerWaitCommand;
import org.apache.storm.container.oci.OciContainerManager;
import org.apache.storm.daemon.supervisor.ClientSupervisorUtils;
import org.apache.storm.daemon.supervisor.ExitCodeCallback;
import org.apache.storm.shade.com.google.common.io.Files;
import org.apache.storm.utils.ConfigUtils;
import org.apache.storm.utils.ServerUtils;
import org.apache.storm.utils.ShellCommandRunnerImpl;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerManager
extends OciContainerManager {
    private static final Logger LOG = LoggerFactory.getLogger(DockerManager.class);
    private final Map<String, String> workerToCid = new ConcurrentHashMap<String, String>();

    @Override
    public void prepare(Map<String, Object> conf) throws IOException {
        super.prepare(conf);
    }

    private String[] getGroupIdInfo(String userName) throws IOException {
        String[] groupIds;
        try {
            String output = new ShellCommandRunnerImpl().execCommand(new String[]{"id", "--groups", userName});
            groupIds = output.trim().split(" ");
        }
        catch (IOException e) {
            LOG.error("Can't get group IDs of the user {}", (Object)userName);
            throw new IOException(e);
        }
        return groupIds;
    }

    private String getUserIdInfo(String userName) throws IOException {
        String uid = "";
        try {
            uid = new ShellCommandRunnerImpl().execCommand(new String[]{"id", "--user", userName}).trim();
        }
        catch (IOException e) {
            LOG.error("Can't get uid of the user {}", (Object)userName);
            throw e;
        }
        return uid;
    }

    @Override
    public void launchWorkerProcess(final String user, String topologyId, Map<String, Object> topoConf, int port, final String workerId, List<String> command, Map<String, String> env, final String logPrefix, final ExitCodeCallback processExitCallback, final File targetDir) throws IOException {
        String dockerImage = this.getImageName(topoConf);
        if (dockerImage == null) {
            LOG.error("Image name for {} is not configured properly; will not continue to launch the worker", (Object)topologyId);
            return;
        }
        String workerDir = targetDir.getAbsolutePath();
        String uid = this.getUserIdInfo(user);
        String[] groups = this.getGroupIdInfo(user);
        String gid = groups[0];
        String dockerUser = uid + ":" + gid;
        DockerRunCommand dockerRunCommand = new DockerRunCommand(workerId, dockerUser, dockerImage);
        String workerRootDir = ConfigUtils.workerRoot((Map)this.conf, (String)workerId);
        String workerArtifactsRoot = ConfigUtils.workerArtifactsRoot((Map)this.conf, (String)topologyId, (Integer)port);
        String workerUserFile = ConfigUtils.workerUserFile((Map)this.conf, (String)workerId);
        String sharedByTopologyDir = ConfigUtils.sharedByTopologyDir((Map)this.conf, (String)topologyId);
        String supervisorLocalDir = ConfigUtils.supervisorLocalDir((Map)this.conf);
        String workerTmpRoot = ConfigUtils.workerTmpRoot((Map)this.conf, (String)workerId);
        dockerRunCommand.detachOnRun().setNetworkType("host").setReadonly().addReadOnlyMountLocation(this.cgroupRootPath, this.cgroupRootPath, false).addReadOnlyMountLocation(this.stormHome, this.stormHome, false).addReadOnlyMountLocation(supervisorLocalDir, supervisorLocalDir, false).addReadWriteMountLocation(workerRootDir, workerRootDir, false).addReadWriteMountLocation(workerArtifactsRoot, workerArtifactsRoot, false).addReadWriteMountLocation(workerUserFile, workerUserFile, false).addReadWriteMountLocation(this.nscdPath, this.nscdPath, false).addReadWriteMountLocation(sharedByTopologyDir, sharedByTopologyDir, false).addReadWriteMountLocation(workerTmpRoot, TMP_DIR, false).addAllReadOnlyMountLocations(this.readonlyBindmounts, false).addAllReadWriteMountLocations(this.readwriteBindmounts, false);
        if (this.workerToCores.containsKey(workerId)) {
            dockerRunCommand.addCpuSetBindings((List)this.workerToCores.get(workerId), (String)this.workerToMemoryZone.get(workerId));
        }
        dockerRunCommand.setCGroupParent(this.cgroupParent).groupAdd(groups).setContainerWorkDir(workerDir).setCidFile(this.dockerCidFilePath(workerId)).setCapabilities(Collections.emptySet()).setNoNewPrivileges();
        if (this.seccompJsonFile != null) {
            dockerRunCommand.setSeccompProfile(this.seccompJsonFile);
        }
        if (this.workerToCpu.containsKey(workerId)) {
            dockerRunCommand.setCpus((double)((Integer)this.workerToCpu.get(workerId)).intValue() / 100.0);
        }
        if (this.workerToMemoryMb.containsKey(workerId)) {
            dockerRunCommand.setMemoryMb((Integer)this.workerToMemoryMb.get(workerId));
        }
        dockerRunCommand.setOverrideCommandWithArgs(Arrays.asList("bash", ServerUtils.writeScript(workerDir, command, env, "0027")));
        this.runDockerCommandWaitFor(this.conf, user, OciContainerManager.CmdType.LAUNCH_DOCKER_CONTAINER, dockerRunCommand.getCommandWithArguments(), null, logPrefix, null, targetDir, "docker-run");
        String threadName = "DockerWait_SLOT_" + port;
        Utils.asyncLoop((Callable)new Callable<Long>(){

            @Override
            public Long call() throws IOException {
                DockerWaitCommand dockerWaitCommand = new DockerWaitCommand(workerId);
                try {
                    DockerManager.this.runDockerCommandWaitFor(DockerManager.this.conf, user, OciContainerManager.CmdType.RUN_DOCKER_CMD, dockerWaitCommand.getCommandWithArguments(), null, logPrefix, processExitCallback, targetDir, "docker-wait");
                }
                catch (IOException e) {
                    LOG.error("IOException on running docker wait command:", (Throwable)e);
                    throw e;
                }
                return null;
            }
        }, (String)threadName, null);
    }

    private String getContainerId(String workerId) throws IOException {
        String cid = this.workerToCid.get(workerId);
        if (cid == null) {
            File cidFile = new File(this.dockerCidFilePath(workerId));
            if (cidFile.exists()) {
                List lines = Files.readLines((File)cidFile, (Charset)Charset.defaultCharset());
                if (lines.isEmpty()) {
                    LOG.error("cid file {} is empty.", (Object)cidFile);
                } else {
                    cid = (String)lines.get(0);
                }
            } else {
                LOG.error("cid file {} doesn't exist.", (Object)cidFile);
            }
            if (cid == null) {
                LOG.error("Couldn't get container id of the worker {}", (Object)workerId);
                throw new IOException("Couldn't get container id of the worker " + workerId);
            }
            this.workerToCid.put(workerId, cid);
        }
        return cid;
    }

    @Override
    public long getMemoryUsage(String user, String workerId, int port) throws IOException {
        String memoryCgroupPath = this.memoryCgroupRootPath + File.separator + this.getContainerId(workerId);
        MemoryCore memoryCore = new MemoryCore(memoryCgroupPath);
        return memoryCore.getPhysicalUsage();
    }

    @Override
    public void kill(String user, String workerId) throws IOException {
        String workerDir = ConfigUtils.workerRoot((Map)this.conf, (String)workerId);
        DockerStopCommand dockerStopCommand = new DockerStopCommand(workerId);
        this.runDockerCommandWaitFor(this.conf, user, OciContainerManager.CmdType.RUN_DOCKER_CMD, dockerStopCommand.getCommandWithArguments(), null, null, null, new File(workerDir), "docker-stop");
        DockerRmCommand dockerRmCommand = new DockerRmCommand(workerId);
        this.runDockerCommandWaitFor(this.conf, user, OciContainerManager.CmdType.RUN_DOCKER_CMD, dockerRmCommand.getCommandWithArguments(), null, null, null, new File(workerDir), "docker-rm");
    }

    @Override
    public void forceKill(String user, String workerId) throws IOException {
        String workerDir = ConfigUtils.workerRoot((Map)this.conf, (String)workerId);
        DockerRmCommand dockerRmCommand = new DockerRmCommand(workerId);
        dockerRmCommand.withForce();
        this.runDockerCommandWaitFor(this.conf, user, OciContainerManager.CmdType.RUN_DOCKER_CMD, dockerRmCommand.getCommandWithArguments(), null, null, null, new File(workerDir), "docker-force-rm");
    }

    @Override
    public boolean areAllProcessesDead(String user, String workerId) throws IOException {
        String workerDir = ConfigUtils.workerRoot((Map)this.conf, (String)workerId);
        DockerPsCommand dockerPsCommand = new DockerPsCommand();
        dockerPsCommand.withNameFilter(workerId);
        dockerPsCommand.withQuietOption();
        String command = dockerPsCommand.getCommandWithArguments();
        Process p = this.runDockerCommand(this.conf, user, OciContainerManager.CmdType.RUN_DOCKER_CMD, command, null, null, null, new File(workerDir), "docker-ps");
        try {
            p.waitFor();
        }
        catch (InterruptedException e) {
            LOG.error("running docker command is interrupted", (Throwable)e);
        }
        if (p.exitValue() != 0) {
            String errorMessage = "The exitValue of the docker command [" + command + "] is non-zero: " + p.exitValue();
            LOG.error(errorMessage);
            throw new IOException(errorMessage);
        }
        String output = IOUtils.toString((InputStream)p.getInputStream(), (Charset)Charset.forName("UTF-8"));
        LOG.debug("The output of the docker command [{}] is: [{}]; the exitValue is {}", new Object[]{command, output, p.exitValue()});
        output = output.trim();
        String[] lines = output.split("\n");
        if (lines.length == 0) {
            return true;
        }
        String lastLine = lines[lines.length - 1].trim();
        if (lastLine.isEmpty()) {
            return true;
        }
        try {
            String containerId = this.getContainerId(workerId);
            return !containerId.startsWith(lastLine);
        }
        catch (IOException e) {
            LOG.error("Failed to find Container ID for {}, assuming dead", (Object)workerId, (Object)e);
            return true;
        }
    }

    @Override
    public boolean runProfilingCommand(String user, String workerId, List<String> command, Map<String, String> env, String logPrefix, File targetDir) throws IOException, InterruptedException {
        String workerDir = targetDir.getAbsolutePath();
        String profilingArgs = StringUtils.join(command, (String)" ");
        String nsenterScriptPath = this.writeToCommandFile(workerDir, profilingArgs, "profile");
        List<String> args = Arrays.asList(OciContainerManager.CmdType.PROFILE_DOCKER_CONTAINER.toString(), workerId, nsenterScriptPath);
        Process process = ClientSupervisorUtils.processLauncher((Map)this.conf, (String)user, null, args, env, (String)logPrefix, null, (File)targetDir);
        process.waitFor();
        int exitCode = process.exitValue();
        LOG.debug("WorkerId {} : exitCode from {}: {}", new Object[]{workerId, OciContainerManager.CmdType.PROFILE_DOCKER_CONTAINER.toString(), exitCode});
        return exitCode == 0;
    }

    @Override
    public void cleanup(String user, String workerId, int port) throws IOException {
        super.cleanup(user, workerId, port);
        this.workerToCid.remove(workerId);
    }

    private String dockerCidFilePath(String workerId) {
        return ConfigUtils.workerRoot((Map)this.conf, (String)workerId) + File.separator + "container.cid";
    }

    @Override
    public boolean isResourceManaged() {
        return true;
    }

    private Process runDockerCommand(Map<String, Object> conf, String user, OciContainerManager.CmdType cmdType, String dockerCommand, Map<String, String> environment, String logPrefix, ExitCodeCallback exitCodeCallback, File targetDir, String commandTag) throws IOException {
        String workerDir = targetDir.getAbsolutePath();
        String dockerScriptPath = this.writeToCommandFile(workerDir, dockerCommand, commandTag);
        List<String> args = Arrays.asList(cmdType.toString(), workerDir, dockerScriptPath);
        return ClientSupervisorUtils.processLauncher(conf, (String)user, null, args, environment, (String)logPrefix, (ExitCodeCallback)exitCodeCallback, (File)targetDir);
    }

    private int runDockerCommandWaitFor(Map<String, Object> conf, String user, OciContainerManager.CmdType cmdType, String dockerCommand, Map<String, String> environment, String logPrefix, ExitCodeCallback exitCodeCallback, File targetDir, String commandTag) throws IOException {
        Process p = this.runDockerCommand(conf, user, cmdType, dockerCommand, environment, logPrefix, exitCodeCallback, targetDir, commandTag);
        try {
            p.waitFor();
        }
        catch (InterruptedException e) {
            LOG.error("running docker command is interrupted", (Throwable)e);
        }
        return p.exitValue();
    }
}

