/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.caconfig.impl;

import java.util.Map;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.caconfig.management.multiplexer.ConfigurationInjectResourceDetectionStrategyMultiplexer;
import org.apache.sling.caconfig.spi.ConfigurationInjectResourceDetectionStrategy;
import org.apache.sling.commons.osgi.Order;
import org.apache.sling.commons.osgi.RankedServices;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={ConfigurationInjectResourceDetectionStrategyMultiplexer.class}, reference={@Reference(name="configurationBindingsResourceDetectionStrategy", service=ConfigurationInjectResourceDetectionStrategy.class, bind="bindConfigurationInjectResourceDetectionStrategy", unbind="unbindConfigurationInjectResourceDetectionStrategy", cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)})
public class ConfigurationInjectResourceDetectionStrategyMultiplexerImpl
implements ConfigurationInjectResourceDetectionStrategyMultiplexer {
    private RankedServices<ConfigurationInjectResourceDetectionStrategy> resourceDetectionStrategies = new RankedServices(Order.DESCENDING);

    protected void bindConfigurationInjectResourceDetectionStrategy(ConfigurationInjectResourceDetectionStrategy item, Map<String, Object> props) {
        this.resourceDetectionStrategies.bind((Object)item, props);
    }

    protected void unbindConfigurationInjectResourceDetectionStrategy(ConfigurationInjectResourceDetectionStrategy item, Map<String, Object> props) {
        this.resourceDetectionStrategies.unbind((Object)item, props);
    }

    @Nullable
    public Resource detectResource(@NotNull SlingHttpServletRequest request) {
        for (ConfigurationInjectResourceDetectionStrategy resourceDetectionStrategy : this.resourceDetectionStrategies) {
            Resource resource = resourceDetectionStrategy.detectResource(request);
            if (resource == null) continue;
            return resource;
        }
        return null;
    }
}

