/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import org.apache.sis.feature.AbstractAssociation;
import org.apache.sis.feature.AbstractAttribute;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.Property;
import org.apache.sis.feature.Validator;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.internal.shared.CloneAccess;
import org.apache.sis.util.internal.shared.Cloner;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.metadata.quality.DataQuality;

final class DenseFeature
extends AbstractFeature
implements CloneAccess {
    private static final long serialVersionUID = -2041120433733230588L;
    private final Map<String, Integer> indices;
    private Object[] properties;

    public DenseFeature(DefaultFeatureType type) {
        super(type);
        this.indices = type.indices();
    }

    private int getIndex(String name) throws IllegalArgumentException {
        Integer index = this.indices.get(name);
        if (index != null) {
            return index;
        }
        ArgumentChecks.ensureNonNull((String)"name", (Object)name);
        throw new IllegalArgumentException(DenseFeature.propertyNotFound(this.type, this.getName(), name));
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        Property property;
        int index = this.getIndex(name);
        if (index < 0) {
            return this.getOperationResult(name);
        }
        if (!(this.properties instanceof Property[])) {
            this.wrapValuesInProperties();
        }
        if ((property = ((Property[])this.properties)[index]) == null) {
            property = this.createProperty(name);
            this.properties[index] = property;
        }
        return property;
    }

    @Override
    public void setProperty(Object property) throws IllegalArgumentException {
        String name = ((Property)property).getName().toString();
        this.verifyPropertyType(name, (Property)property);
        if (!(this.properties instanceof Property[])) {
            this.wrapValuesInProperties();
        }
        this.properties[this.indices.get((Object)name).intValue()] = property;
    }

    private void wrapValuesInProperties() {
        Property[] c = new Property[this.indices.size()];
        if (this.properties != null) {
            assert (c.length == this.properties.length);
            for (Map.Entry<String, Integer> entry : this.indices.entrySet()) {
                Object value;
                int index = entry.getValue();
                if (index < 0 || (value = this.properties[index]) == null) continue;
                c[index] = this.createProperty(entry.getKey(), value);
            }
        }
        this.properties = c;
    }

    @Override
    @Deprecated(since="1.5", forRemoval=true)
    public final Object getValueOrFallback(String name, Object missingPropertyFallback) {
        Object element;
        ArgumentChecks.ensureNonNull((String)"name", (Object)name);
        Integer index = this.indices.get(name);
        if (index == null) {
            return missingPropertyFallback;
        }
        if (index < 0) {
            return this.getOperationValue(name);
        }
        if (this.properties != null && (element = this.properties[index]) != null) {
            if (!(this.properties instanceof Property[])) {
                return element;
            }
            if (element instanceof AbstractAttribute) {
                return DenseFeature.getAttributeValue((AbstractAttribute)element);
            }
            if (element instanceof AbstractAssociation) {
                return DenseFeature.getAssociationValue((AbstractAssociation)element);
            }
            throw new IllegalArgumentException(DenseFeature.unsupportedPropertyType(((Property)element).getName()));
        }
        return this.getDefaultValue(name);
    }

    @Override
    public void setPropertyValue(String name, Object value) throws IllegalArgumentException {
        Property property;
        int index = this.getIndex(name);
        if (index < 0) {
            this.setOperationValue(name, value);
            return;
        }
        if (this.properties == null) {
            int n = this.indices.size();
            Object[] objectArray = this.properties = value != null ? new Object[n] : new Property[n];
        }
        if (!(this.properties instanceof Property[])) {
            if (value != null) {
                if (!DenseFeature.canSkipVerification(this.properties[index], value)) {
                    value = this.verifyPropertyValue(name, value);
                }
                this.properties[index] = value;
                return;
            }
            this.wrapValuesInProperties();
        }
        if ((property = ((Property[])this.properties)[index]) == null) {
            property = this.createProperty(name);
            this.properties[index] = property;
        }
        DenseFeature.setPropertyValue(property, value);
    }

    @Override
    public Optional<?> getCharacteristicValue(String property, String characteristic) throws IllegalArgumentException {
        if (this.properties instanceof Property[]) {
            return super.getCharacteristicValue(property, characteristic);
        }
        return this.getDefaultCharacteristicValue(property, characteristic);
    }

    @Override
    public DataQuality quality() {
        if (this.properties != null && !(this.properties instanceof Property[])) {
            Validator validator = new Validator(ScopeCode.FEATURE);
            for (Map.Entry<String, Integer> entry : this.indices.entrySet()) {
                validator.validateAny(this.type.getProperty(entry.getKey()), this.properties[entry.getValue()]);
            }
            return validator.quality;
        }
        return super.quality();
    }

    public DenseFeature clone() throws CloneNotSupportedException {
        DenseFeature clone = (DenseFeature)super.clone();
        clone.properties = (Object[])clone.properties.clone();
        if (clone.properties instanceof Property[]) {
            Property[] p = (Property[])clone.properties;
            Cloner cloner = new Cloner();
            for (int i = 0; i < p.length; ++i) {
                Property property = p[i];
                if (!(property instanceof Cloneable)) continue;
                p[i] = (Property)cloner.clone((Object)property);
            }
        }
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        int code = 1;
        if (this.properties != null && this.comparisonStart()) {
            try {
                if (this.properties instanceof Property[]) {
                    for (Property p : (Property[])this.properties) {
                        Object value;
                        code = 31 * code;
                        if (p instanceof AbstractAttribute) {
                            value = DenseFeature.getAttributeValue((AbstractAttribute)p);
                        } else {
                            if (!(p instanceof AbstractAssociation)) continue;
                            value = DenseFeature.getAssociationValue((AbstractAssociation)p);
                        }
                        if (value == null) continue;
                        code += value.hashCode();
                    }
                } else {
                    code = Arrays.hashCode(this.properties);
                }
            }
            finally {
                this.comparisonEnd();
            }
        }
        return this.type.hashCode() + code;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof DenseFeature) {
            DenseFeature that = (DenseFeature)obj;
            if (this.type.equals(that.type)) {
                boolean asProperties = this.properties instanceof Property[];
                if (asProperties != that.properties instanceof Property[]) {
                    if (asProperties) {
                        that.wrapValuesInProperties();
                    } else {
                        this.wrapValuesInProperties();
                    }
                }
                if (this.comparisonStart()) {
                    try {
                        boolean bl = Arrays.equals(this.properties, that.properties);
                        return bl;
                    }
                    finally {
                        this.comparisonEnd();
                    }
                }
                return true;
            }
        }
        return false;
    }
}

