/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.Serializable;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform1D;
import org.apache.sis.referencing.operation.transform.ConcatenatedTransformDirect1D;
import org.apache.sis.referencing.operation.transform.ExponentialTransform1D;
import org.apache.sis.referencing.operation.transform.LinearTransform1D;
import org.apache.sis.referencing.operation.transform.TransformJoiner;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.internal.shared.Numerics;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.util.FactoryException;

class LogarithmicTransform1D
extends AbstractMathTransform1D
implements Serializable {
    private static final long serialVersionUID = 1535101265352133948L;
    private static final LogarithmicTransform1D NATURAL = new LogarithmicTransform1D();
    private MathTransform1D inverse;

    LogarithmicTransform1D() {
    }

    public static MathTransform1D create(double base, double offset) {
        ArgumentChecks.ensureStrictlyPositive((String)"base", (double)base);
        if (base == 10.0) {
            return Base10.create(offset);
        }
        return NATURAL.concatenate(1.0 / Math.log(base), offset);
    }

    static MathTransform1D create(ExponentialTransform1D inverse) {
        if (inverse.base == 10.0) {
            return Base10.create(-Math.log10(inverse.scale));
        }
        return NATURAL.concatenate(1.0 / inverse.lnBase, -Math.log(inverse.scale) / inverse.lnBase);
    }

    private MathTransform1D concatenate(double scale, double offset) {
        LinearTransform1D t = LinearTransform1D.create(scale, offset);
        return t.isIdentity() ? this : new ConcatenatedTransformDirect1D(this, t);
    }

    @Override
    protected void tryConcatenate(TransformJoiner context) throws FactoryException {
        int relativeIndex = 1;
        do {
            MathTransform concatenation;
            MathTransform other;
            if ((other = (MathTransform)context.getTransform(relativeIndex).orElse(null)) instanceof LinearTransform1D) {
                LinearTransform1D linear = (LinearTransform1D)other;
                if (relativeIndex >= 0 || linear.offset != 0.0 || !(linear.scale > 0.0)) continue;
                concatenation = LogarithmicTransform1D.create(this.base(), this.transform(linear.scale));
            } else {
                if (!(other instanceof ExponentialTransform1D)) continue;
                concatenation = ((ExponentialTransform1D)other).concatenateLog(this, -relativeIndex);
            }
            if (!context.replace(relativeIndex, concatenation)) continue;
            return;
        } while ((relativeIndex = -relativeIndex) < 0);
        super.tryConcatenate(context);
    }

    @Override
    public synchronized MathTransform1D inverse() {
        if (this.inverse == null) {
            this.inverse = new ExponentialTransform1D(this);
        }
        return this.inverse;
    }

    double base() {
        return Math.E;
    }

    double lnBase() {
        return 1.0;
    }

    double offset() {
        return 0.0;
    }

    @Override
    public double derivative(double value) {
        return 1.0 / value;
    }

    double pow(double value) {
        return Math.exp(value);
    }

    double log(double value) {
        return Math.log(value);
    }

    @Override
    public double transform(double value) {
        return Math.log(value);
    }

    @Override
    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        if (srcPts != dstPts || srcOff >= dstOff) {
            while (--numPts >= 0) {
                dstPts[dstOff++] = Math.log(srcPts[srcOff++]);
            }
        } else {
            srcOff += numPts;
            dstOff += numPts;
            while (--numPts >= 0) {
                dstPts[--dstOff] = Math.log(srcPts[--srcOff]);
            }
        }
    }

    @Override
    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        if (srcPts != dstPts || srcOff >= dstOff) {
            while (--numPts >= 0) {
                dstPts[dstOff++] = (float)Math.log(srcPts[srcOff++]);
            }
        } else {
            srcOff += numPts;
            dstOff += numPts;
            while (--numPts >= 0) {
                dstPts[--dstOff] = (float)Math.log(srcPts[--srcOff]);
            }
        }
    }

    @Override
    public void transform(double[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        while (--numPts >= 0) {
            dstPts[dstOff++] = (float)Math.log(srcPts[srcOff++]);
        }
    }

    @Override
    public void transform(float[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        while (--numPts >= 0) {
            dstPts[dstOff++] = Math.log(srcPts[srcOff++]);
        }
    }

    static final class Base10
    extends LogarithmicTransform1D {
        private static final long serialVersionUID = -5435804027536647558L;
        private static final double LOG_10 = 2.302585092994046;
        static final Base10 INSTANCE = new Base10(0.0);
        private final double offset;

        private Base10(double offset) {
            this.offset = offset;
        }

        public static Base10 create(double offset) {
            return offset == 0.0 ? INSTANCE : new Base10(offset);
        }

        @Override
        double base() {
            return 10.0;
        }

        @Override
        double lnBase() {
            return 2.302585092994046;
        }

        @Override
        double offset() {
            return this.offset;
        }

        @Override
        public double derivative(double value) {
            return 0.43429448190325176 / value;
        }

        @Override
        double pow(double value) {
            return MathFunctions.pow10((double)value);
        }

        @Override
        double log(double value) {
            return Math.log10(value);
        }

        @Override
        public double transform(double value) {
            return Math.log10(value) + this.offset;
        }

        @Override
        public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
            if (srcPts != dstPts || srcOff >= dstOff) {
                while (--numPts >= 0) {
                    dstPts[dstOff++] = Math.log10(srcPts[srcOff++]) + this.offset;
                }
            } else {
                srcOff += numPts;
                dstOff += numPts;
                while (--numPts >= 0) {
                    dstPts[--dstOff] = Math.log10(srcPts[--srcOff]) + this.offset;
                }
            }
        }

        @Override
        public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
            if (srcPts != dstPts || srcOff >= dstOff) {
                while (--numPts >= 0) {
                    dstPts[dstOff++] = (float)(Math.log10(srcPts[srcOff++]) + this.offset);
                }
            } else {
                srcOff += numPts;
                dstOff += numPts;
                while (--numPts >= 0) {
                    dstPts[--dstOff] = (float)(Math.log10(srcPts[--srcOff]) + this.offset);
                }
            }
        }

        @Override
        public void transform(double[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
            while (--numPts >= 0) {
                dstPts[dstOff++] = (float)(Math.log10(srcPts[srcOff++]) + this.offset);
            }
        }

        @Override
        public void transform(float[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
            while (--numPts >= 0) {
                dstPts[dstOff++] = Math.log10(srcPts[srcOff++]) + this.offset;
            }
        }

        @Override
        protected int computeHashCode() {
            return Double.hashCode(this.offset) ^ super.computeHashCode();
        }

        @Override
        public boolean equals(Object object, ComparisonMode mode) {
            if (object == this) {
                return true;
            }
            if (super.equals(object, mode)) {
                return Numerics.equals((double)this.offset, (double)((Base10)object).offset);
            }
            return false;
        }
    }
}

