/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.sql.feature;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.logging.Level;
import javax.sql.DataSource;
import org.apache.sis.geometry.wrapper.Geometries;
import org.apache.sis.metadata.sql.internal.shared.Dialect;
import org.apache.sis.setup.GeometryLibrary;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.IllegalNameException;
import org.apache.sis.storage.InternalDataStoreException;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.storage.sql.ResourceDefinition;
import org.apache.sis.storage.sql.duckdb.DuckDB;
import org.apache.sis.storage.sql.feature.Column;
import org.apache.sis.storage.sql.feature.Database;
import org.apache.sis.storage.sql.feature.InfoStatements;
import org.apache.sis.storage.sql.feature.QueryAnalyzer;
import org.apache.sis.storage.sql.feature.Resources;
import org.apache.sis.storage.sql.feature.SchemaModifier;
import org.apache.sis.storage.sql.feature.Table;
import org.apache.sis.storage.sql.feature.TableAnalyzer;
import org.apache.sis.storage.sql.feature.TableReference;
import org.apache.sis.storage.sql.feature.ValueGetter;
import org.apache.sis.storage.sql.postgis.Postgres;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.iso.DefaultNameFactory;
import org.apache.sis.util.resources.ResourceInternationalString;
import org.opengis.util.GenericName;
import org.opengis.util.NameFactory;
import org.opengis.util.NameSpace;

public final class Analyzer {
    private static final String[] ACCEPTED_TABLE_TYPES = new String[]{"TABLE", "VIEW", "BASE TABLE", "MATERIALIZED VIEW"};
    public final Database<?> database;
    InfoStatements spatialInformation;
    final DatabaseMetaData metadata;
    final NameFactory nameFactory;
    private final Map<String, String> uniqueStrings;
    private final String[] tableTypes;
    private final Map<String, Boolean> ignoredTables;
    private final Map<GenericName, Table> featureTables;
    private final Set<ResourceInternationalString> warnings;
    private transient String lastCatalog;
    private transient String lastSchema;
    private transient NameSpace namespace;
    SchemaModifier customizer;
    private SQLFeatureNotSupportedException featureNotSupported;

    public Analyzer(DataSource source, DatabaseMetaData metadata, GeometryLibrary geomLibrary, Locale contentLocale, StoreListeners listeners, ReadWriteLock locks) throws Exception {
        this.metadata = metadata;
        this.nameFactory = DefaultNameFactory.provider();
        this.featureTables = new HashMap<GenericName, Table>();
        this.uniqueStrings = new HashMap<String, String>();
        this.warnings = new LinkedHashSet<ResourceInternationalString>();
        HashSet<String> types = new HashSet<String>(4);
        try (ResultSet reflect = metadata.getTableTypes();){
            while (reflect.next()) {
                String type = reflect.getString("TABLE_TYPE");
                if (!ArraysExt.containsIgnoreCase((String[])ACCEPTED_TABLE_TYPES, (String)type)) continue;
                types.add(type);
            }
        }
        this.tableTypes = (String[])types.toArray(String[]::new);
        Geometries g = Geometries.factory((GeometryLibrary)geomLibrary);
        Dialect dialect = Dialect.guess((DatabaseMetaData)metadata);
        switch (dialect) {
            case POSTGRESQL: {
                this.database = new Postgres(source, metadata, dialect, g, contentLocale, listeners, locks);
                break;
            }
            case DUCKDB: {
                this.database = new DuckDB(source, metadata, dialect, g, contentLocale, listeners, locks);
                break;
            }
            default: {
                this.database = new Database(source, metadata, dialect, g, contentLocale, listeners, locks);
            }
        }
        this.ignoredTables = this.database.detectSpatialSchema(metadata, this.tableTypes);
    }

    final boolean skipInfoTable(String table) {
        return Boolean.FALSE.equals(this.ignoredTables.get(table));
    }

    final List<Table> findFeatureTables(GenericName[] tableNames, ResourceDefinition[] queries) throws Exception {
        LinkedHashSet<TableReference> declared = new LinkedHashSet<TableReference>();
        for (GenericName tableName : tableNames) {
            String[] names = TableReference.splitName(tableName);
            try (ResultSet reflect = this.metadata.getTables(names[2], names[1], names[0], this.tableTypes);){
                while (reflect.next()) {
                    String table = this.getUniqueString(reflect, "TABLE_NAME");
                    if (this.ignoredTables.containsKey(table)) continue;
                    String catalog = this.getUniqueString(reflect, "TABLE_CAT");
                    declared.add(new TableReference(catalog, this.getUniqueString(reflect, "TABLE_SCHEM"), table, this.getUniqueString(reflect, "REMARKS")));
                }
            }
        }
        ArrayList<Table> tableList = new ArrayList<Table>(tableNames.length);
        for (TableReference reference : declared) {
            tableList.add(this.table(reference, reference.getName(this), null));
        }
        for (ResourceDefinition resource : queries) {
            tableList.add(this.query(resource.getName(), resource.getQuery().get()));
        }
        return tableList;
    }

    final ValueGetter<?> setValueGetterOf(Column column) {
        ValueGetter<Object> getter = this.database.getMapping(column);
        if (getter == null) {
            getter = this.database.getDefaultMapping();
            this.warning((short)4, column.typeName);
        }
        column.valueGetter = getter;
        return getter;
    }

    final String getUniqueString(ResultSet reflect, String column) throws SQLException {
        String p;
        String value = reflect.getString(column);
        if (value != null && (p = this.uniqueStrings.putIfAbsent(value, value)) != null) {
            value = p;
        }
        return value;
    }

    final NameSpace namespace(String catalog, String schema) {
        if (!Objects.equals(this.lastSchema, schema) || !Objects.equals(this.lastCatalog, catalog)) {
            if (schema != null) {
                Object name = catalog == null ? this.nameFactory.createLocalName(null, (CharSequence)schema) : this.nameFactory.createGenericName(null, new CharSequence[]{catalog, schema});
                this.namespace = this.nameFactory.createNameSpace((GenericName)name, Map.of("separator", "."));
            } else {
                this.namespace = null;
            }
            this.lastCatalog = catalog;
            this.lastSchema = schema;
        }
        return this.namespace;
    }

    final Table table(TableReference id, GenericName name, TableReference dependencyOf) throws Exception {
        Table table = this.featureTables.get(name);
        if (table == null && !this.featureTables.containsKey(name)) {
            this.featureTables.put(name, null);
            table = new Table(this.database, new TableAnalyzer(this, id, dependencyOf), null);
            if (this.featureTables.put(name, table) != null) {
                throw new InternalDataStoreException(this.internalError());
            }
        }
        return table;
    }

    private Table query(GenericName name, String query) throws Exception {
        Table table = new Table(this.database, new QueryAnalyzer(this, name, query, null), query);
        if (!this.featureTables.containsKey(name) && this.featureTables.put(name, table) == null) {
            return table;
        }
        throw new IllegalNameException(this.resources().getString((short)13, name));
    }

    final Resources resources() {
        return Resources.forLocale(this.database.listeners.getLocale());
    }

    final String internalError() {
        return this.resources().getString((short)6);
    }

    final void unavailableMetadata(SQLFeatureNotSupportedException e) {
        if (this.featureNotSupported == null) {
            this.featureNotSupported = e;
        } else if (!Analyzer.equivalent(this.featureNotSupported, e)) {
            for (Throwable s : this.featureNotSupported.getSuppressed()) {
                if (!Analyzer.equivalent(s, e)) continue;
                return;
            }
            this.featureNotSupported.addSuppressed(e);
        }
    }

    private static boolean equivalent(Throwable e1, SQLException e2) {
        return e1.getClass() == e2.getClass() && Objects.equals(e1.getMessage(), e2.getMessage());
    }

    private void warning(short key, Object argument) {
        this.warnings.add(Resources.formatInternational(key, argument));
    }

    final Collection<Table> finish() throws DataStoreException {
        for (Table table : this.featureTables.values()) {
            table.setDeferredSearchTables(this, this.featureTables);
        }
        if (this.featureNotSupported != null) {
            this.database.warning((short)17, this.featureNotSupported);
        }
        for (ResourceInternationalString warning : this.warnings) {
            this.database.log(warning.toLogRecord(Level.WARNING));
        }
        return this.featureTables.values();
    }
}

