/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.handler.predicate;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.validation.constraints.NotEmpty;
import org.springframework.cloud.gateway.handler.predicate.AbstractRoutePredicateFactory;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.server.ServerWebExchange;

public class HeaderRoutePredicateFactory
extends AbstractRoutePredicateFactory<Config> {
    public static final String HEADER_KEY = "header";
    public static final String REGEXP_KEY = "regexp";

    public HeaderRoutePredicateFactory() {
        super(Config.class);
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Arrays.asList(HEADER_KEY, REGEXP_KEY);
    }

    @Override
    public Predicate<ServerWebExchange> apply(Config config) {
        boolean hasRegex = !StringUtils.isEmpty((Object)config.regexp);
        return exchange -> {
            List values = (List)exchange.getRequest().getHeaders().getOrDefault((Object)config.header, Collections.emptyList());
            if (values.isEmpty()) {
                return false;
            }
            if (hasRegex) {
                return values.stream().anyMatch(value -> value.matches(config.regexp));
            }
            return true;
        };
    }

    @Validated
    public static class Config {
        @NotEmpty
        private String header;
        private String regexp;

        public String getHeader() {
            return this.header;
        }

        public Config setHeader(String header) {
            this.header = header;
            return this;
        }

        public String getRegexp() {
            return this.regexp;
        }

        public Config setRegexp(String regexp) {
            this.regexp = regexp;
            return this;
        }
    }
}

