/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.js.jx;

import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.royale.compiler.codegen.ISubEmitter;
import org.apache.royale.compiler.codegen.js.IJSEmitter;
import org.apache.royale.compiler.common.IMetaInfo;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.JSSubEmitter;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleEmitterTokens;
import org.apache.royale.compiler.internal.projects.RoyaleJSProject;
import org.apache.royale.compiler.internal.scopes.FunctionScope;
import org.apache.royale.compiler.internal.tree.as.LiteralNode;
import org.apache.royale.compiler.internal.tree.as.RegExpLiteralNode;
import org.apache.royale.compiler.internal.tree.as.XMLLiteralNode;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IFunctionNode;
import org.apache.royale.compiler.tree.as.ILiteralNode;
import org.apache.royale.utils.JSXUtil;

public class LiteralEmitter
extends JSSubEmitter
implements ISubEmitter<ILiteralNode> {
    private final List<String> JSX_ATTRIBUTES_NO_RENAME = Arrays.asList("ref", "key");

    public LiteralEmitter(IJSEmitter emitter) {
        super(emitter);
    }

    @Override
    public void emit(ILiteralNode node) {
        boolean isWritten = false;
        String newlineReplacement = "\\\\n";
        String s = node.getValue(true);
        if (!(node instanceof RegExpLiteralNode)) {
            boolean withEscapedSingleQuote = false;
            if (node.getLiteralType() == ILiteralNode.LiteralType.XML) {
                boolean jsx = false;
                IFunctionNode functionNode = (IFunctionNode)node.getAncestorOfType(IFunctionNode.class);
                if (functionNode != null) {
                    IMetaInfo[] metaInfos;
                    for (IMetaInfo metaInfo : metaInfos = functionNode.getMetaInfos()) {
                        if (!metaInfo.getTagName().equals(JSRoyaleEmitterTokens.JSX.getToken())) continue;
                        jsx = true;
                        break;
                    }
                }
                if (node instanceof XMLLiteralNode) {
                    XMLLiteralNode xmlNode = (XMLLiteralNode)node;
                    if (jsx) {
                        this.emitJSX(xmlNode);
                        return;
                    }
                    newlineReplacement = "\\\\\n";
                    if (xmlNode.getContentsNode().getChildCount() == 1) {
                        s = s.contains("'") ? "\"" + s + "\"" : "'" + s.trim() + "'";
                    } else {
                        StringBuilder sb = new StringBuilder();
                        boolean inAttribute = false;
                        int n = xmlNode.getContentsNode().getChildCount();
                        for (int i = 0; i < n; ++i) {
                            IASNode child;
                            if (i > 0) {
                                sb.append(" + ");
                            }
                            if ((child = xmlNode.getContentsNode().getChild(i)) instanceof LiteralNode) {
                                s = ((LiteralNode)child).getValue(true);
                                if ((s = s.replace("\n", "")).contains("'")) {
                                    s = s.replace("'", "__ESC_SNGLE_QUOT_PLACEHOLDER__");
                                    withEscapedSingleQuote = true;
                                }
                                sb.append("'" + s + "'");
                            } else {
                                s = this.getEmitter().stringifyNode(child);
                                if (inAttribute) {
                                    sb.append("'\"' + ");
                                    sb.append(s);
                                    sb.append(" + '\"'");
                                } else {
                                    sb.append(s);
                                }
                            }
                            inAttribute = s.endsWith("=");
                        }
                        s = sb.toString();
                    }
                    char c = s.charAt(0);
                    if (c == '\"') {
                        s = s.substring(1, s.length() - 1).trim();
                        s = s.replace("\"", "__QUOTE_PLACEHOLDER__");
                        s = "\"" + s + "\"";
                    }
                    if (this.getModel().defaultXMLNamespaceActive.booleanValue() && xmlNode.getContainingScope().getScope() instanceof FunctionScope && this.getModel().getDefaultXMLNamespace((FunctionScope)xmlNode.getContainingScope().getScope()) != null) {
                        s = this.getEmitter().formatQualifiedName("XML") + ASEmitterTokens.MEMBER_ACCESS.getToken() + "constructWithDefaultXmlNS(" + s + "," + this.getEmitter().stringifyNode((IASNode)this.getModel().getDefaultXMLNamespace((FunctionScope)xmlNode.getContainingScope().getScope())) + ")";
                    } else {
                        newlineReplacement = "\\\\n";
                        s = s.replaceAll("\r", "");
                        s = "new " + this.getEmitter().formatQualifiedName("XML") + "( " + s + ")";
                    }
                } else {
                    s = node.getValue();
                    s = s.contains("'") ? "\"" + s + "\"" : "'" + s + "'";
                    s = "new " + this.getEmitter().formatQualifiedName("XML") + "( " + s + ")";
                }
            }
            s = s.replaceAll("\n", "__NEWLINE_PLACEHOLDER__");
            s = s.replaceAll("\r", "__CR_PLACEHOLDER__");
            s = s.replaceAll("\t", "__TAB_PLACEHOLDER__");
            s = s.replaceAll("\f", "__FORMFEED_PLACEHOLDER__");
            s = s.replaceAll("\b", "__BACKSPACE_PLACEHOLDER__");
            s = s.replaceAll("\\\\", "__ESCAPE_PLACEHOLDER__");
            s = s.replaceAll("\\\\\"", "__QUOTE_PLACEHOLDER__");
            s = s.replaceAll("__QUOTE_PLACEHOLDER__", "\\\\\"");
            s = s.replaceAll("__ESCAPE_PLACEHOLDER__", "\\\\\\\\");
            if (withEscapedSingleQuote) {
                s = s.replaceAll("__ESC_SNGLE_QUOT_PLACEHOLDER__", "\\\\'");
            }
            s = s.replaceAll("__BACKSPACE_PLACEHOLDER__", "\\\\b");
            s = s.replaceAll("__FORMFEED_PLACEHOLDER__", "\\\\f");
            s = s.replaceAll("__TAB_PLACEHOLDER__", "\\\\t");
            s = s.replaceAll("__CR_PLACEHOLDER__", "\\\\r");
            s = s.replaceAll("__NEWLINE_PLACEHOLDER__", newlineReplacement);
            if (node.getLiteralType() == ILiteralNode.LiteralType.STRING && s.length() > 0) {
                char c = s.charAt(0);
                if (c == '\"') {
                    s = s.substring(1, s.length() - 1);
                    s = s.replace("\"", "\\\"");
                    s = "\"" + s + "\"";
                } else if (c == '\'') {
                    s = s.substring(1, s.length() - 1);
                    s = s.replace("'", "\\'");
                    s = "'" + s + "'";
                }
                s = s.replace("\u00a0", "\\u00A0");
                s = s.replace("\u2028", "\\u2028");
                s = s.replace("\u2029", "\\u2029");
                s = s.replace("\u3000", "\\u3000");
            }
        } else {
            s = s.replaceAll("\\\\\\\\", "__ESCAPE__ESCAPE__PLACEHOLDER__");
            s = s.replaceAll("\\\\/", "__SLASH_PLACEHOLDER__");
            s = s.replaceAll("\\\\([^u])", "__ESCAPE_PLACEHOLDER__$1");
            s = s.replaceAll("\"", "__DOUBLE_QUOTE_PLACEHOLDER__");
            s = StringEscapeUtils.escapeJava((String)s);
            s = s.replaceAll("__DOUBLE_QUOTE_PLACEHOLDER__", "\"");
            s = s.replaceAll("__ESCAPE_PLACEHOLDER__", "\\\\");
            s = s.replaceAll("__SLASH_PLACEHOLDER__", "\\\\/");
            s = s.replaceAll("__ESCAPE__ESCAPE__PLACEHOLDER__", "\\\\\\\\");
            s = s.replaceAll("\\\\n", "\\\\u000a");
            s = s.replaceAll("\\\\r", "\\\\u000d");
            s = s.replaceAll("\\\\t", "\\\\u0009");
            s = s.replaceAll(" ", "\\\\u0020");
        }
        if (!isWritten) {
            this.startMapping((ISourceLocation)node);
            this.write(s);
            this.endMapping((ISourceLocation)node);
        }
    }

    private void emitJSX(XMLLiteralNode node) {
        RoyaleJSProject project = (RoyaleJSProject)this.getProject();
        String jsxFactory = project.config.getJsxFactory();
        int childCount = node.getContentsNode().getChildCount();
        Stack<String> elementStack = new Stack<String>();
        String elementName = null;
        boolean endsWithAttribute = false;
        boolean afterOpenTag = false;
        for (int i = 0; i < childCount; ++i) {
            IASNode child = node.getContentsNode().getChild(i);
            if (child instanceof ILiteralNode) {
                ILiteralNode literalChild = (ILiteralNode)child;
                if (literalChild.getLiteralType() != ILiteralNode.LiteralType.XML) {
                    if (afterOpenTag) {
                        this.writeToken(ASEmitterTokens.COMMA);
                    }
                    this.getEmitter().getWalker().walk((IASNode)literalChild);
                    continue;
                }
                String value = literalChild.getValue(true);
                while (value.length() > 0) {
                    int nextTagStartIndex = value.indexOf("<");
                    int nextTagEndIndex = value.indexOf(">");
                    boolean selfClosing = false;
                    boolean startsWithAttribute = false;
                    if (nextTagEndIndex > 0 && value.charAt(nextTagEndIndex - 1) == '/') {
                        selfClosing = true;
                    }
                    if (endsWithAttribute) {
                        endsWithAttribute = false;
                        startsWithAttribute = true;
                        elementName = (String)elementStack.peek();
                    } else if (nextTagStartIndex == 0) {
                        int endNameIndex = nextTagEndIndex;
                        if (endNameIndex == -1) {
                            endNameIndex = value.length() - 1;
                        }
                        int attributeIndex = -1;
                        int count = value.length();
                        for (int j = 0; j < count; ++j) {
                            char charAt = value.charAt(j);
                            if (charAt != ' ' && charAt != '\t' && charAt != '\r' && charAt != '\n') continue;
                            attributeIndex = j;
                            break;
                        }
                        if (attributeIndex > 0 && attributeIndex < endNameIndex) {
                            endNameIndex = attributeIndex;
                        }
                        if ((elementName = value.substring(1, endNameIndex)).endsWith("/")) {
                            elementName = elementName.substring(0, elementName.length() - 1);
                        }
                        if (elementName.startsWith("/")) {
                            elementName = elementName.substring(1);
                            elementName = this.getElementNameToEmit(elementName, (IASNode)node);
                            if (elementStack.size() > 0) {
                                this.indentPop();
                            }
                            this.write(ASEmitterTokens.PAREN_CLOSE);
                            String topOfStack = (String)elementStack.pop();
                            assert (topOfStack.equals(elementName));
                            value = value.substring(nextTagEndIndex + 1);
                            continue;
                        }
                        if (elementStack.size() > 0) {
                            this.indentPush();
                            this.writeNewline(ASEmitterTokens.COMMA);
                        }
                        elementName = this.getElementNameToEmit(elementName, (IASNode)node);
                        elementStack.push(elementName);
                        this.write(jsxFactory);
                        this.write(ASEmitterTokens.PAREN_OPEN);
                        this.write(elementName);
                        value = value.substring(endNameIndex);
                        value = value.replaceAll("^\\s+", "");
                        nextTagEndIndex = value.indexOf(">");
                        afterOpenTag = false;
                    } else {
                        if (nextTagStartIndex == -1) {
                            nextTagStartIndex = value.length();
                        }
                        String elementText = value.substring(0, nextTagStartIndex);
                        int oldLength = elementText.length();
                        elementText = elementText.replaceAll("\r", "");
                        elementText = elementText.replaceAll("\n\\s+", "\n");
                        elementText = elementText.replaceAll("\\s+\n", "\n");
                        if (oldLength != (elementText = elementText.replaceAll("\n", "")).length() && nextTagStartIndex != value.length()) {
                            elementText = elementText.replaceAll("\\s+$", "");
                        }
                        if (!elementText.matches("^\\s*$") || nextTagStartIndex == value.length()) {
                            this.writeToken(ASEmitterTokens.COMMA);
                            this.emitJSXText(elementText);
                        }
                        value = value.substring(nextTagStartIndex);
                        continue;
                    }
                    if (nextTagEndIndex == -1) {
                        endsWithAttribute = true;
                        nextTagEndIndex = value.length() - 1;
                    }
                    int attributesEndIndex = selfClosing && nextTagEndIndex > 0 ? nextTagEndIndex - 1 : nextTagEndIndex;
                    String attributes = value.substring(0, attributesEndIndex);
                    this.emitJSXAttributes(attributes, startsWithAttribute, endsWithAttribute, ((String)elementStack.peek()).startsWith("'"));
                    if (selfClosing) {
                        this.write(ASEmitterTokens.PAREN_CLOSE);
                        if (elementStack.size() > 0) {
                            this.indentPop();
                        }
                        String topOfStack = (String)elementStack.pop();
                        assert (topOfStack.equals(elementName));
                    }
                    value = value.substring(nextTagEndIndex + 1);
                    if (endsWithAttribute) continue;
                    afterOpenTag = true;
                }
                continue;
            }
            if (!endsWithAttribute || afterOpenTag) {
                this.writeToken(ASEmitterTokens.COMMA);
            }
            this.getEmitter().getWalker().walk(child);
        }
    }

    private void emitJSXAttributes(String value, boolean startsWithAttribute, boolean endsWithAttribute, boolean isHTML) {
        int charCount;
        int attributeCount = 0;
        while ((charCount = value.length()) != 0) {
            int endAttributeValueIndex;
            int endAttributeNameIndex = value.indexOf("=");
            if (endAttributeNameIndex == -1) {
                endAttributeNameIndex = value.length();
            }
            String attributeName = value.substring(0, endAttributeNameIndex);
            this.writeToken(ASEmitterTokens.COMMA);
            if (!startsWithAttribute && attributeCount == 0) {
                this.writeToken(ASEmitterTokens.BLOCK_OPEN);
            }
            attributeName = attributeName.trim();
            if (isHTML || this.JSX_ATTRIBUTES_NO_RENAME.contains(attributeName)) {
                this.emitJSXText(attributeName);
            } else {
                this.write(attributeName);
            }
            this.writeToken(ASEmitterTokens.COLON);
            ++attributeCount;
            if (endAttributeNameIndex + 1 >= charCount) break;
            char quoteChar = value.charAt(endAttributeNameIndex + 1);
            int startAttributeValueIndex = endAttributeNameIndex + 2;
            if (startAttributeValueIndex > charCount) {
                startAttributeValueIndex = charCount;
            }
            if ((endAttributeValueIndex = value.indexOf(quoteChar, startAttributeValueIndex)) == -1 || endAttributeValueIndex > charCount) {
                endAttributeValueIndex = charCount;
            }
            if (endAttributeValueIndex <= 0) continue;
            String attributeValue = value.substring(startAttributeValueIndex, endAttributeValueIndex);
            this.emitJSXText(attributeValue);
            value = value.substring(endAttributeValueIndex + 1);
            value = value.replaceAll("^\\s+", "");
        }
        if (!endsWithAttribute) {
            if (!startsWithAttribute && attributeCount == 0) {
                this.writeToken(ASEmitterTokens.COMMA);
                this.write(ASEmitterTokens.NULL);
            } else {
                this.write(ASEmitterTokens.SPACE);
                this.write(ASEmitterTokens.BLOCK_CLOSE);
            }
        }
    }

    private void emitJSXText(String elementText) {
        this.write(ASEmitterTokens.SINGLE_QUOTE);
        elementText = elementText.replaceAll("'", "\\\\'");
        this.write(elementText);
        this.write(ASEmitterTokens.SINGLE_QUOTE);
    }

    private String getElementNameToEmit(String elementName, IASNode node) {
        String qualifiedTypeName = JSXUtil.getQualifiedTypeForElementName((String)elementName, (IASNode)node, (ICompilerProject)this.getProject());
        if (qualifiedTypeName != null) {
            return this.getEmitter().formatQualifiedName(qualifiedTypeName);
        }
        return ASEmitterTokens.SINGLE_QUOTE.getToken() + elementName + ASEmitterTokens.SINGLE_QUOTE.getToken();
    }
}

