/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.abc;

import org.apache.royale.abc.visitors.IClassVisitor;
import org.apache.royale.abc.visitors.ITraitsVisitor;
import org.apache.royale.compiler.definitions.INamespaceDefinition;
import org.apache.royale.compiler.internal.abc.ABCScopeBuilder;
import org.apache.royale.compiler.internal.abc.ScopedDefinitionTraitsVisitor;
import org.apache.royale.compiler.internal.definitions.ClassDefinition;
import org.apache.royale.compiler.internal.definitions.InterfaceDefinition;
import org.apache.royale.compiler.internal.definitions.TypeDefinitionBase;
import org.apache.royale.compiler.internal.scopes.ASScope;
import org.apache.royale.compiler.internal.scopes.TypeScope;

class TypeDefinitionBuilder
implements IClassVisitor {
    private final ABCScopeBuilder scopeBuilder;
    private final TypeDefinitionBase definition;
    private final ASScope scope;

    protected TypeDefinitionBuilder(ABCScopeBuilder scopeBuilder, TypeDefinitionBase typeDefinition) {
        assert (typeDefinition instanceof ClassDefinition || typeDefinition instanceof InterfaceDefinition);
        this.scope = new TypeScope(null, typeDefinition);
        this.definition = typeDefinition;
        this.definition.setContainedScope(this.scope);
        this.scopeBuilder = scopeBuilder;
    }

    @Override
    public void visit() {
    }

    @Override
    public void visitEnd() {
    }

    @Override
    public ITraitsVisitor visitClassTraits() {
        return new ScopedDefinitionTraitsVisitor(this.scopeBuilder, this.scope, true);
    }

    @Override
    public ITraitsVisitor visitInstanceTraits() {
        INamespaceDefinition.ILanguageNamespaceDefinition interfNs = null;
        if (this.definition instanceof InterfaceDefinition) {
            interfNs = ((InterfaceDefinition)this.definition).getInterfaceNamespaceReference();
        }
        return new ScopedDefinitionTraitsVisitor(this.scopeBuilder, this.scope, false, interfNs);
    }
}

