/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.linter.rules;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.royale.compiler.parsing.IASToken;
import org.apache.royale.compiler.problems.CompilerProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IBlockNode;
import org.apache.royale.compiler.tree.as.IFunctionNode;
import org.apache.royale.linter.LinterRule;
import org.apache.royale.linter.NodeVisitor;
import org.apache.royale.linter.TokenQuery;
import org.apache.royale.linter.problems.ILinterProblem;

public class NoThisInClosureRule
extends LinterRule {
    @Override
    public Map<ASTNodeID, NodeVisitor> getNodeVisitors() {
        HashMap<ASTNodeID, NodeVisitor> result = new HashMap<ASTNodeID, NodeVisitor>();
        result.put(ASTNodeID.FunctionID, (node, tokenQuery, problems) -> this.checkFunctionNode((IFunctionNode)node, tokenQuery, problems));
        return result;
    }

    private void checkFunctionNode(IFunctionNode functionNode, TokenQuery tokenQuery, Collection<ICompilerProblem> problems) {
        IFunctionNode ancestorFunction = (IFunctionNode)functionNode.getAncestorOfType(IFunctionNode.class);
        if (ancestorFunction == null) {
            return;
        }
        IBlockNode blockNode = this.getBody(functionNode);
        if (blockNode == null) {
            return;
        }
        for (IASToken token : tokenQuery.getTokens(blockNode)) {
            if (token.getType() != 123) continue;
            problems.add(new NoThisInClosureLinterProblem(token));
        }
    }

    private IBlockNode getBody(IFunctionNode functionNode) {
        if (functionNode.getChildCount() == 0) {
            return null;
        }
        IASNode lastChild = functionNode.getChild(functionNode.getChildCount() - 1);
        if (lastChild instanceof IBlockNode) {
            return (IBlockNode)lastChild;
        }
        return null;
    }

    public static class NoThisInClosureLinterProblem
    extends CompilerProblem
    implements ILinterProblem {
        public static final String DESCRIPTION = "Closure must not contain 'this' keyword";

        public NoThisInClosureLinterProblem(IASToken token) {
            super(token);
        }
    }
}

