/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.args4j.spi;

import java.util.HashMap;
import java.util.Map;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.FieldSetter;
import org.kohsuke.args4j.spi.Messages;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Parameters;
import org.kohsuke.args4j.spi.Setter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapOptionHandler
extends OptionHandler<Map<?, ?>> {
    public MapOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super Map<?, ?>> setter) {
        super(parser, option, setter);
        if (setter.asFieldSetter() == null) {
            throw new IllegalArgumentException("MapOptionHandler can only work with fields");
        }
    }

    @Override
    public String getDefaultMetaVariable() {
        return null;
    }

    @Override
    public int parseArguments(Parameters params) throws CmdLineException {
        FieldSetter fs = this.setter.asFieldSetter();
        Map v = (Map)fs.getValue();
        if (v == null) {
            v = this.createNewCollection(fs.getType());
            fs.addValue(v);
        }
        this.addToMap(params.getParameter(0), v);
        return 1;
    }

    protected Map createNewCollection(Class<? extends Map> type) {
        return new HashMap();
    }

    protected void addToMap(String argument, Map m) throws CmdLineException {
        String mapValue;
        String mapKey;
        if (String.valueOf(argument).indexOf(61) == -1) {
            throw new CmdLineException(this.owner, Messages.FORMAT_ERROR_FOR_MAP.format(new Object[0]));
        }
        int idx = argument.indexOf(61);
        if (idx >= 0) {
            mapKey = argument.substring(0, idx);
            mapValue = argument.substring(idx + 1);
            if (mapValue.length() == 0) {
                mapValue = null;
            }
        } else {
            mapKey = argument;
            mapValue = null;
        }
        if (mapKey.length() == 0) {
            throw new CmdLineException(this.owner, Messages.MAP_HAS_NO_KEY.format(new Object[0]));
        }
        this.addToMap(m, mapKey, mapValue);
    }

    protected void addToMap(Map m, String key, String value) {
        m.put(key, value);
    }
}

